/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.cargo.module.Descriptor;
import org.codehaus.cargo.module.DescriptorTag;
import org.codehaus.cargo.module.Grammar;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractDescriptor
implements Descriptor {
    private Document document;
    private Element rootElement;
    private Grammar grammar;

    public AbstractDescriptor(Document document, Grammar grammar) {
        this.document = document;
        this.rootElement = document.getDocumentElement();
        this.grammar = grammar;
    }

    public Document getDocument() {
        return this.document;
    }

    public Element getRootElement() {
        return this.rootElement;
    }

    public Iterator getElements(DescriptorTag tag) {
        ArrayList<Node> elements = new ArrayList<Node>();
        NodeList nodeList = this.getRootElement().getElementsByTagName(tag.getTagName());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            elements.add(nodeList.item(i));
        }
        return elements.iterator();
    }

    protected void checkElement(Element element, DescriptorTag expectedTag) throws IllegalArgumentException {
        if (!expectedTag.getTagName().equals(element.getNodeName())) {
            throw new IllegalArgumentException("Not a [" + expectedTag + "] element");
        }
    }

    protected Iterator getNestedElements(Element parent, DescriptorTag tag) {
        ArrayList<Node> elements = new ArrayList<Node>();
        NodeList nodeList = parent.getElementsByTagName(tag.getTagName());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            elements.add(nodeList.item(i));
        }
        return elements.iterator();
    }

    protected Element createNestedText(DescriptorTag tag, String text) {
        Element element = this.document.createElement(tag.getTagName());
        element.appendChild(this.document.createTextNode(text));
        return element;
    }

    protected String getNestedText(Element parent, DescriptorTag tag) {
        String text = null;
        NodeList nestedElements = parent.getElementsByTagName(tag.getTagName());
        if (nestedElements.getLength() > 0) {
            text = this.getText((Element)nestedElements.item(0));
        }
        return text;
    }

    protected String getText(Element element) {
        String text = null;
        Node nestedText = element.getFirstChild();
        if (nestedText != null) {
            text = nestedText.getNodeValue();
        }
        return text;
    }

    protected Element getImmediateChild(Element parent, DescriptorTag tag) {
        Element e = null;
        NodeList nl = parent.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!n.getNodeName().equals(tag.getTagName()) || n.getNodeType() != 1) continue;
            e = (Element)n;
        }
        return e;
    }

    protected String getChildText(Element parent, DescriptorTag tag) {
        String text = null;
        Element e = this.getImmediateChild(parent, tag);
        if (e != null) {
            text = this.getText(e);
        }
        return text;
    }

    protected Element addElement(DescriptorTag tag, Element child, Element parent) {
        Node importedNode = this.getDocument().importNode(child, true);
        Node refNode = this.getInsertionPointFor(tag, parent.getNodeName());
        return (Element)parent.insertBefore(importedNode, refNode);
    }

    public Element replaceElement(DescriptorTag tag, Element child, Element parent) {
        Iterator elements = this.getElements(tag);
        while (elements.hasNext()) {
            Element e = (Element)elements.next();
            e.getParentNode().removeChild(e);
        }
        return this.addElement(tag, child, parent);
    }

    protected Node getInsertionPointFor(DescriptorTag tag, String parent) {
        List elementOrder = this.grammar.getElementOrder(parent);
        for (int i = 0; i < elementOrder.size(); ++i) {
            DescriptorTag orderTag = (DescriptorTag)elementOrder.get(i);
            if (!orderTag.equals(tag)) continue;
            for (int j = i + 1; j < elementOrder.size(); ++j) {
                NodeList elements = this.getRootElement().getElementsByTagName(((DescriptorTag)elementOrder.get(j)).getTagName());
                if (elements.getLength() <= 0) continue;
                Node result = elements.item(0);
                Node previous = result.getPreviousSibling();
                while (previous != null && (previous.getNodeType() == 8 || previous.getNodeType() == 3)) {
                    result = previous;
                    previous = result.getPreviousSibling();
                }
                return result;
            }
            break;
        }
        return null;
    }
}

