/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.ejb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.cargo.module.AbstractDescriptor;
import org.codehaus.cargo.module.Dtd;
import org.codehaus.cargo.module.J2eeDescriptor;
import org.codehaus.cargo.module.ejb.EjbJarXmlTag;
import org.codehaus.cargo.module.ejb.Entity;
import org.codehaus.cargo.module.ejb.Session;
import org.codehaus.cargo.module.ejb.VendorEjbDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EjbJarXml
extends AbstractDescriptor
implements J2eeDescriptor {
    private List vendorDescriptors = new ArrayList();

    public EjbJarXml(Document theDocument) {
        super(theDocument, new Dtd("http://java.sun.com/dtd/ejb-jar_2_0.dtd"));
    }

    public String getFileName() {
        return "ejb-jar.xml";
    }

    public void addVendorDescriptor(VendorEjbDescriptor descr) {
        this.vendorDescriptors.add(descr);
    }

    public Iterator getVendorDescriptors() {
        return this.vendorDescriptors.iterator();
    }

    public final Iterator getSessionEjbs() {
        ArrayList<Session> ejbs = new ArrayList<Session>();
        Iterator sessionElements = this.getElements(EjbJarXmlTag.SESSION);
        while (sessionElements.hasNext()) {
            Element sessionElement = (Element)sessionElements.next();
            Session session = new Session();
            session.setId(sessionElement.getAttribute("id"));
            session.setName(this.getChildText(sessionElement, EjbJarXmlTag.EJB_NAME));
            session.setLocal(this.getChildText(sessionElement, EjbJarXmlTag.LOCAL));
            session.setLocalHome(this.getChildText(sessionElement, EjbJarXmlTag.LOCAL_HOME));
            ejbs.add(session);
        }
        return ejbs.iterator();
    }

    public final Iterator getEntityEjbs() {
        ArrayList<Entity> ejbs = new ArrayList<Entity>();
        Iterator sessionElements = this.getElements(EjbJarXmlTag.ENTITY);
        while (sessionElements.hasNext()) {
            Element sessionElement = (Element)sessionElements.next();
            Entity entity = new Entity();
            entity.setId(sessionElement.getAttribute("id"));
            entity.setName(this.getChildText(sessionElement, EjbJarXmlTag.EJB_NAME));
            entity.setLocal(this.getChildText(sessionElement, EjbJarXmlTag.LOCAL));
            entity.setLocalHome(this.getChildText(sessionElement, EjbJarXmlTag.LOCAL_HOME));
            ejbs.add(entity);
        }
        return ejbs.iterator();
    }

    public final Session getSessionEjb(String name) {
        Session result = null;
        Iterator sessions = this.getSessionEjbs();
        while (sessions.hasNext()) {
            Session ejb = (Session)sessions.next();
            if (!ejb.getName().equals(name)) continue;
            result = ejb;
            break;
        }
        return result;
    }

    public final Entity getEntityEjb(String name) {
        Entity result = null;
        Iterator entities = this.getEntityEjbs();
        while (entities.hasNext()) {
            Entity ejb = (Entity)entities.next();
            if (!ejb.getName().equals(name)) continue;
            result = ejb;
            break;
        }
        return result;
    }
}

