/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.ejb.websphere;

import java.util.Iterator;
import org.codehaus.cargo.module.AbstractDescriptor;
import org.codehaus.cargo.module.DescriptorTag;
import org.codehaus.cargo.module.ejb.EjbDef;
import org.codehaus.cargo.module.ejb.VendorEjbDescriptor;
import org.codehaus.cargo.module.ejb.websphere.IbmEjbJarBndXmiGrammar;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class IbmEjbJarBndXmi
extends AbstractDescriptor
implements VendorEjbDescriptor {
    public IbmEjbJarBndXmi(Document document) {
        super(document, new IbmEjbJarBndXmiGrammar());
    }

    public String getFileName() {
        return "ibm-ejb-jar-bnd.xmi";
    }

    public String getJndiName(EjbDef ejb) {
        String jndiName = null;
        Element bindings = this.getEjbBindings(ejb.getId());
        if (bindings != null) {
            jndiName = bindings.getAttribute("jndiName");
        }
        return jndiName;
    }

    private Element getEjbBindings(String id) {
        Element ejbElement = null;
        String wantedHref = "META-INF/ejb-jar.xml#" + id;
        Iterator names = this.getElements(new DescriptorTag("ejbBindings", true));
        while (names.hasNext()) {
            Element bindingsElement = (Element)names.next();
            NodeList nl = bindingsElement.getElementsByTagName("enterpriseBean");
            Element beanElement = (Element)nl.item(0);
            String href = beanElement.getAttribute("href");
            if (!wantedHref.equals(href)) continue;
            ejbElement = bindingsElement;
            break;
        }
        return ejbElement;
    }
}

