/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;
import org.codehaus.cargo.util.AntUtils;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.cargo.util.FileHandler;

public class DefaultFileHandler
implements FileHandler {
    private static int uniqueNameCounter = -1;
    private AntUtils antUtils = new AntUtils();
    private FileUtils fileUtils = FileUtils.newFileUtils();

    private AntUtils getAntUtils() {
        return this.antUtils;
    }

    private FileUtils getFileUtils() {
        return this.fileUtils;
    }

    public void copyFile(String source, String target) {
        try {
            this.getFileUtils().copyFile(new File(source).getAbsolutePath(), new File(target).getAbsolutePath());
        }
        catch (IOException e) {
            throw new CargoException("Failed to copy source file [" + source + "] to [" + target + "]", e);
        }
    }

    public void copyDirectory(String source, String target) {
        this.copyDirectory(source, target, new ArrayList());
    }

    public void copyDirectory(String source, String target, List excludes) {
        try {
            Copy copyTask = (Copy)this.getAntUtils().createAntTask("copy");
            copyTask.setTodir(new File(target));
            FileSet fileSet = new FileSet();
            fileSet.setDir(new File(source));
            Iterator it = excludes.iterator();
            while (it.hasNext()) {
                String excludeName = (String)it.next();
                fileSet.createExclude().setName(excludeName);
            }
            copyTask.addFileset(fileSet);
            copyTask.setFailOnError(true);
            copyTask.setIncludeEmptyDirs(true);
            copyTask.setOverwrite(true);
            copyTask.execute();
        }
        catch (BuildException e) {
            throw new CargoException("Failed to copy source directory [" + source + "] to [" + target + "]", e);
        }
    }

    public String createDirectory(String parentDir, String name) {
        File dir = new File(parentDir, name);
        dir.mkdirs();
        if (!dir.isDirectory()) {
            throw new CargoException("Couldn't create directory " + dir.getAbsolutePath());
        }
        return dir.getPath();
    }

    public void copy(InputStream in, OutputStream out, int bufSize) {
        try {
            int length;
            byte[] buf = new byte[bufSize];
            while ((length = in.read(buf)) != -1) {
                out.write(buf, 0, length);
            }
        }
        catch (IOException e) {
            throw new CargoException("Failed to copy input stream [" + in.toString() + "] to output stream [" + out.toString() + "]", e);
        }
    }

    public void copy(InputStream in, OutputStream out) {
        this.copy(in, out, 1024);
    }

    public String getTmpPath(String name) {
        return new File(new File(System.getProperty("java.io.tmpdir"), "cargo"), name).getPath();
    }

    public synchronized String createUniqueTmpDirectory() {
        File tmpDir;
        if (uniqueNameCounter == -1) {
            uniqueNameCounter = new Random().nextInt() & 0xFFFF;
        }
        while ((tmpDir = new File(new File(System.getProperty("java.io.tmpdir")), "cargo/" + Integer.toString(++uniqueNameCounter))).exists()) {
        }
        tmpDir.deleteOnExit();
        tmpDir.mkdirs();
        return tmpDir.getPath();
    }

    public void delete(String path) {
        File pathAsFile = new File(path);
        if (pathAsFile.isDirectory()) {
            File[] children = pathAsFile.listFiles();
            for (int i = 0; i < children.length; ++i) {
                this.delete(children[i].getPath());
            }
        }
        pathAsFile.delete();
    }

    public InputStream getInputStream(String file) {
        FileInputStream is;
        try {
            is = new FileInputStream(new File(file).getAbsoluteFile());
        }
        catch (FileNotFoundException e) {
            throw new CargoException("Failed to find file [" + file + "]", e);
        }
        return is;
    }

    public OutputStream getOutputStream(String file) {
        FileOutputStream os;
        try {
            os = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new CargoException("Failed to open output stream for file [" + file + "]", e);
        }
        return os;
    }

    public String append(String path, String suffixToAppend) {
        String result = !path.endsWith("/") && !path.endsWith("\\") ? path + "/" + suffixToAppend : path + suffixToAppend;
        return result;
    }

    public void mkdirs(String path) {
        File pathFile = new File(path);
        boolean success = pathFile.exists() ? true : pathFile.mkdirs();
        if (!success) {
            throw new CargoException("Failed to create folders for path [" + path + "]");
        }
    }

    public String getParent(String path) {
        return new File(path).getParent();
    }

    public boolean exists(String path) {
        return new File(path).exists();
    }

    public void createFile(String file) {
        try {
            new File(file).createNewFile();
        }
        catch (IOException e) {
            throw new CargoException("Failed to create file [" + file + "]", e);
        }
    }

    public boolean isDirectoryEmpty(String dir) {
        return new File(dir).list().length == 0;
    }

    public String getName(String file) {
        return new File(file).getName();
    }

    public String getURL(String path) {
        URL result;
        try {
            result = new File(path).toURL();
        }
        catch (MalformedURLException e) {
            throw new CargoException("Failed to return URL for [" + path + "]", e);
        }
        return result.toString();
    }

    public boolean isDirectory(String path) {
        return new File(path).isDirectory();
    }

    public String[] getChildren(String directory) {
        File[] files = new File(directory).listFiles();
        String[] results = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            results[i] = files[i].getPath();
        }
        return results;
    }
}

