/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.logging;

import com.opencloud.logging.LogLevelUtil;
import com.opencloud.util.SimpleDateFormat;
import java.io.PrintWriter;
import java.io.StringWriter;

public final class LogMessageUtil {
    private static final String COL_SEPERATOR = "  ";

    public static final String makeLogMessage(int n, String string) {
        return LogMessageUtil.makeLogMessage(n, string, true, true);
    }

    public static final void writeLogMessageHeader(StringWriter stringWriter, int n, boolean bl, boolean bl2) {
        LogMessageUtil.writeLogMessageHeader(stringWriter, System.currentTimeMillis(), n, bl, bl2);
    }

    public static final void writeLogMessageHeader(StringWriter stringWriter, long l, int n, boolean bl, boolean bl2) {
        if (bl) {
            stringWriter.write(SimpleDateFormat.toString(l));
            stringWriter.write(COL_SEPERATOR);
        }
        if (bl2) {
            stringWriter.write(LogLevelUtil.toString(n));
            stringWriter.write(COL_SEPERATOR);
        }
    }

    public static final void writeLogMessage(StringWriter stringWriter, String string) {
        stringWriter.write(string);
    }

    public static final void writeLogMessage(StringWriter stringWriter, Throwable throwable) {
        stringWriter.write(throwable instanceof Error ? "Error    : " : "Exception: ");
        stringWriter.write(throwable.getClass().getName());
        stringWriter.write(" => ");
        stringWriter.write(throwable.getMessage());
        stringWriter.write("\nStack Trace:\n ");
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
    }

    public static final void writeLogMessageSubHeader(StringWriter stringWriter, String string) {
        stringWriter.write(91);
        stringWriter.write(string);
        stringWriter.write(93);
        stringWriter.write(COL_SEPERATOR);
    }

    public static final void writeLogMessageThreadHeader(StringWriter stringWriter, Thread thread) {
        stringWriter.write(60);
        stringWriter.write(thread.getName());
        stringWriter.write(62);
        stringWriter.write(COL_SEPERATOR);
    }

    public static final String makeLogMessage(int n, String string, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(256);
        if (bl) {
            SimpleDateFormat.toString(System.currentTimeMillis(), stringBuffer);
            stringBuffer.append(' ');
        }
        if (bl2) {
            switch (n) {
                case 5: {
                    stringBuffer.append("CRITICAL ");
                    break;
                }
                case 4: {
                    stringBuffer.append("ERROR    ");
                    break;
                }
                case 3: {
                    stringBuffer.append("WARNING  ");
                    break;
                }
                case 2: {
                    stringBuffer.append("NORMAL   ");
                    break;
                }
                case 1: {
                    stringBuffer.append("INFO     ");
                    break;
                }
                case 0: {
                    stringBuffer.append("<DEBUG>  ");
                    break;
                }
                case 11: {
                    stringBuffer.append("SEVERE   ");
                    break;
                }
                case 14: {
                    stringBuffer.append("CONFIG   ");
                    break;
                }
                case 15: {
                    stringBuffer.append("FINE     ");
                    break;
                }
                case 16: {
                    stringBuffer.append("FINER    ");
                    break;
                }
                case 17: {
                    stringBuffer.append("FINEST   ");
                    break;
                }
                default: {
                    stringBuffer.append("** UNKNOWN LOGLEVEL ** : ");
                }
            }
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static final String makeLogMessage(int n, Throwable throwable) {
        return LogMessageUtil.makeLogMessage(n, throwable, true, true);
    }

    public static String makeLogMessage(int n, Throwable throwable, boolean bl, boolean bl2) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(throwable instanceof Error ? "Error    : " : "Exception: ").append(throwable.getClass().getName()).append(" => ").append(throwable.getMessage()).append("\nStack Trace:\n ").append(stringWriter.toString());
        return LogMessageUtil.makeLogMessage(n, stringBuffer.toString(), bl, bl2);
    }
}

