/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.resource.adaptor;

import com.opencloud.logging.Logable;
import com.opencloud.logging.StdErrLog;
import com.opencloud.sleetck.lib.resource.adaptor.TCKResourceAdaptorInterface;
import com.opencloud.sleetck.lib.resource.adaptor.TCKResourceFactory;
import com.opencloud.sleetck.lib.resource.adaptor.TCKResourceSetupInterface;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;

public class StandaloneTCKResourceSetup {
    private Logable log = new StdErrLog();
    private Registry rmiRegistryForTestInterface;
    private Registry rmiRegistryForRAInterface;

    public static void main(String[] stringArray) {
        String string = "java StandaloneTCKResourceSetup test-interface-port resource-adaptor-interface-port";
        try {
            int n = Integer.parseInt(stringArray[0]);
            int n2 = Integer.parseInt(stringArray[1]);
            new StandaloneTCKResourceSetup().setup(n, n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(string);
            System.exit(1);
        }
    }

    public void setup(int n, int n2) throws Exception {
        if (n < 0 || n > 65535) {
            throw new Exception("Invalid port value for testInterfacePort: " + n);
        }
        if (n2 < 0 || n2 > 65535) {
            throw new Exception("Invalid port value for resourceAdaptorPort: " + n2);
        }
        TCKResourceSetupInterface tCKResourceSetupInterface = TCKResourceFactory.createResource();
        tCKResourceSetupInterface.setLog(this.log);
        TCKResourceAdaptorInterface tCKResourceAdaptorInterface = tCKResourceSetupInterface.getResourceAdaptorInterface();
        this.log.finer("StandaloneTCKResourceSetup: Locating registry at port " + n2 + " on localhost...");
        this.rmiRegistryForRAInterface = LocateRegistry.getRegistry(n2);
        this.log.finer("StandaloneTCKResourceSetup: Registry located");
        this.log.finer("StandaloneTCKResourceSetup: Binding resource adaptor interface...");
        this.rmiRegistryForRAInterface.rebind("TCKResourceAdaptorInterface", tCKResourceAdaptorInterface);
        this.log.fine("StandaloneTCKResourceSetup: bound resource adaptor interface in rmi registry");
        TCKResourceTestInterface tCKResourceTestInterface = tCKResourceSetupInterface.getTestInterface();
        if (n == n2) {
            this.rmiRegistryForTestInterface = this.rmiRegistryForRAInterface;
        } else {
            this.log.finer("StandaloneTCKResourceSetup: Locating registry at port " + n + " on localhost...");
            this.rmiRegistryForTestInterface = LocateRegistry.getRegistry(n);
        }
        this.log.finer("StandaloneTCKResourceSetup: Registry located");
        this.log.finer("StandaloneTCKResourceSetup: Binding test interface...");
        this.rmiRegistryForTestInterface.rebind("TCKResourceTestInterface", tCKResourceTestInterface);
        this.log.fine("StandaloneTCKResourceSetup: bound test interface in rmi registry");
    }

    public void stop() {
        try {
            this.rmiRegistryForTestInterface.unbind("TCKResourceTestInterface");
            this.rmiRegistryForRAInterface.unbind("TCKResourceAdaptorInterface");
        }
        catch (Exception exception) {
            this.log.warning("Caught exception while unbinding TCK resource interfaces: " + exception);
        }
        this.log = null;
        this.rmiRegistryForTestInterface = null;
        this.rmiRegistryForRAInterface = null;
    }
}

