/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.resource.impl;

import com.opencloud.logging.Logable;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.adaptor.TCKResourceEventHandler;
import com.opencloud.sleetck.lib.resource.events.TCKResourceEvent;
import com.opencloud.sleetck.lib.resource.impl.EventDelegator;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.slee.Address;

public class EventDelegatorImpl
implements EventDelegator {
    private LinkedList activeEventHandlers;
    private LinkedList deactivatingHandlers;
    private Map activityToHandlerMap;
    private Logable log;

    public EventDelegatorImpl(Logable logable) {
        this.log = logable;
        this.activeEventHandlers = new LinkedList();
        this.deactivatingHandlers = new LinkedList();
        this.activityToHandlerMap = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventHandler(TCKResourceEventHandler tCKResourceEventHandler) {
        LinkedList linkedList = this.activeEventHandlers;
        synchronized (linkedList) {
            if (!this.activeEventHandlers.contains(tCKResourceEventHandler)) {
                this.activeEventHandlers.add(tCKResourceEventHandler);
                this.deactivatingHandlers.remove(tCKResourceEventHandler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventHandlerDeactivating(TCKResourceEventHandler tCKResourceEventHandler) {
        LinkedList linkedList = this.activeEventHandlers;
        synchronized (linkedList) {
            if (this.activeEventHandlers.contains(tCKResourceEventHandler)) {
                this.activeEventHandlers.remove(tCKResourceEventHandler);
                this.deactivatingHandlers.add(tCKResourceEventHandler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventHandler(TCKResourceEventHandler tCKResourceEventHandler) {
        Map map = this.activityToHandlerMap;
        synchronized (map) {
            LinkedList linkedList = this.activeEventHandlers;
            synchronized (linkedList) {
                this.activeEventHandlers.remove(tCKResourceEventHandler);
                this.deactivatingHandlers.remove(tCKResourceEventHandler);
                if (this.activityToHandlerMap.containsValue(tCKResourceEventHandler)) {
                    Iterator iterator = this.activityToHandlerMap.keySet().iterator();
                    while (iterator.hasNext()) {
                        if (!this.activityToHandlerMap.get(iterator.next()).equals(tCKResourceEventHandler)) continue;
                        iterator.remove();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onActivitiesCleared() {
        Map map = this.activityToHandlerMap;
        synchronized (map) {
            this.activityToHandlerMap.clear();
        }
    }

    public void handleEvent(TCKResourceEvent tCKResourceEvent, String string, TCKActivityID tCKActivityID, Address address) throws TCKTestErrorException, RemoteException {
        this.getHandlerFor(tCKActivityID).handleEvent(tCKResourceEvent, string, tCKActivityID, address);
    }

    public void handleActivityEnd(TCKActivityID tCKActivityID, boolean bl) throws TCKTestErrorException, RemoteException {
        this.getHandlerFor(tCKActivityID).handleActivityEnd(tCKActivityID, bl);
    }

    public void handleActivityCreatedBySbb(TCKActivityID tCKActivityID) throws TCKTestErrorException, RemoteException {
        this.getHandlerFor(tCKActivityID).handleActivityCreatedBySbb(tCKActivityID);
    }

    void setLog(Logable logable) {
        this.log = logable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TCKResourceEventHandler getHandlerFor(TCKActivityID tCKActivityID) throws TCKTestErrorException {
        Map map = this.activityToHandlerMap;
        synchronized (map) {
            TCKResourceEventHandler tCKResourceEventHandler = (TCKResourceEventHandler)this.activityToHandlerMap.get(tCKActivityID);
            if (tCKResourceEventHandler == null) {
                LinkedList linkedList = this.activeEventHandlers;
                synchronized (linkedList) {
                    if (!this.activeEventHandlers.isEmpty()) {
                        tCKResourceEventHandler = (TCKResourceEventHandler)this.activeEventHandlers.getLast();
                    } else if (!this.deactivatingHandlers.isEmpty()) {
                        this.log.warning("Assigning an deactivating event handler for a new activity, as there are no active event handlers registered with the TCK resource.");
                        tCKResourceEventHandler = (TCKResourceEventHandler)this.deactivatingHandlers.getLast();
                    } else {
                        throw new TCKTestErrorException("No event handlers registered with the TCK resource");
                    }
                    this.activityToHandlerMap.put(tCKActivityID, tCKResourceEventHandler);
                }
            }
            return tCKResourceEventHandler;
        }
    }
}

