/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.alizer.api;

import com.redhat.devtools.alizer.api.Component;
import com.redhat.devtools.alizer.api.ComponentRecognizer;
import com.redhat.devtools.alizer.api.DevFileRecognizer;
import com.redhat.devtools.alizer.api.DevfileType;
import com.redhat.devtools.alizer.api.Language;
import com.redhat.devtools.alizer.api.LanguageRecognizer;
import com.redhat.devtools.alizer.api.LanguageScore;
import com.redhat.devtools.alizer.api.Recognizer;
import com.redhat.devtools.alizer.api.RecognizerFactory;
import java.io.IOException;
import java.util.List;
import java.util.Optional;

public class DevFileRecognizerImpl
extends Recognizer
implements DevFileRecognizer {
    private RecognizerFactory builder;

    DevFileRecognizerImpl(RecognizerFactory builder) {
        super(builder);
        this.builder = builder;
    }

    @Override
    public <T extends DevfileType> T selectDevFileFromTypes(String srcPath, List<T> devfileTypes) throws IOException {
        ComponentRecognizer componentRecognizer = this.builder.createComponentRecognizer();
        List<Component> componentsInRoot = componentRecognizer.analyzeRoot(srcPath);
        if (!componentsInRoot.isEmpty()) {
            return this.selectDevFileFromTypes(componentsInRoot.get(0).getLanguages(), devfileTypes);
        }
        List<Component> componentsWithinFullProject = componentRecognizer.analyze(srcPath);
        if (!componentsWithinFullProject.isEmpty()) {
            return this.selectDevFileFromTypes(componentsWithinFullProject.get(0).getLanguages(), devfileTypes);
        }
        LanguageRecognizer languageRecognizer = this.builder.createLanguageRecognizer();
        List<Language> languages = languageRecognizer.analyze(srcPath);
        return this.selectDevFileFromTypes(languages, devfileTypes);
    }

    @Override
    public <T extends DevfileType> T selectDevFileFromTypes(List<Language> languages, List<T> devfileTypes) {
        for (Language language : languages) {
            Optional<LanguageScore> score = devfileTypes.stream().map(devfileType -> new LanguageScore(language, (DevfileType)devfileType)).sorted().findFirst();
            if (!score.isPresent() || score.get().getScore() <= 0) continue;
            return (T)score.get().getDevfileType();
        }
        return null;
    }
}

