/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.alizer.api;

import com.redhat.devtools.alizer.api.DevfileType;
import com.redhat.devtools.alizer.api.Language;
import java.util.List;

public class LanguageScore
implements Comparable<LanguageScore> {
    private static final int FRAMEWORK_WEIGHT = 10;
    private static final int TOOL_WEIGHT = 5;
    private int score;
    private DevfileType devfileType;

    public LanguageScore(Language language, DevfileType devfileType) {
        this.devfileType = devfileType;
        this.computeScore(language);
    }

    private static boolean matches(List<String> list, String val) {
        return list.stream().filter(s -> s.equalsIgnoreCase(val)).count() > 0L;
    }

    private void computeScore(Language language) {
        if (this.devfileType.getLanguage().equalsIgnoreCase(language.getName()) || LanguageScore.matches(language.getAliases(), this.devfileType.getLanguage())) {
            ++this.score;
            if (this.devfileType.getProjectType() != null && LanguageScore.matches(language.getFrameworks(), this.devfileType.getProjectType())) {
                this.score += 10;
            }
            this.devfileType.getTags().forEach(tag -> {
                if (LanguageScore.matches(language.getFrameworks(), tag)) {
                    this.score += 10;
                }
                if (LanguageScore.matches(language.getTools(), tag)) {
                    this.score += 5;
                }
            });
        }
    }

    public DevfileType getDevfileType() {
        return this.devfileType;
    }

    public int getScore() {
        return this.score;
    }

    @Override
    public int compareTo(LanguageScore other) {
        return other.getScore() - this.getScore();
    }
}

