/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.alizer.api.spi;

import com.redhat.devtools.alizer.api.Language;
import com.redhat.devtools.alizer.api.spi.LanguageEnricherProvider;
import com.redhat.devtools.alizer.api.spi.framework.FrameworkDetectorProvider;
import com.redhat.devtools.alizer.api.spi.framework.java.JavaFrameworkDetectorProvider;
import com.redhat.devtools.alizer.api.utils.DocumentParser;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JavaLanguageEnricherProviderImpl
extends LanguageEnricherProvider {
    @Override
    public LanguageEnricherProvider create() {
        return new JavaLanguageEnricherProviderImpl();
    }

    @Override
    public List<String> getSupportedLanguages() {
        return Arrays.asList("JAVA");
    }

    @Override
    public Language getEnrichedLanguage(Language language, List<File> files) throws IOException {
        Optional<File> gradle = files.stream().filter(file -> file.getName().equalsIgnoreCase("build.gradle")).findFirst();
        Optional<File> maven = files.stream().filter(file -> file.getName().equalsIgnoreCase("pom.xml")).findFirst();
        Optional<File> ant = files.stream().filter(file -> file.getName().equalsIgnoreCase("build.xml")).findFirst();
        if (gradle.isPresent()) {
            language.setTools(Arrays.asList("Gradle"));
            language.setFrameworks(this.getFrameworks(gradle.get()));
        } else if (maven.isPresent()) {
            language.setTools(Arrays.asList("Maven"));
            language.setFrameworks(this.getFrameworks(maven.get()));
        } else if (ant.isPresent()) {
            language.setTools(Arrays.asList("Ant"));
        }
        return language;
    }

    private List<String> getFrameworks(File file) throws IOException {
        ArrayList<String> frameworks = new ArrayList<String>();
        ServiceLoader<FrameworkDetectorProvider> loader = ServiceLoader.load(FrameworkDetectorProvider.class, JavaLanguageEnricherProviderImpl.class.getClassLoader());
        for (FrameworkDetectorProvider provider : loader) {
            JavaFrameworkDetectorProvider configProvider;
            if (!(provider instanceof JavaFrameworkDetectorProvider) || !(configProvider = (JavaFrameworkDetectorProvider)provider.create()).hasFramework(file)) continue;
            frameworks.addAll(configProvider.getFrameworks());
        }
        return frameworks;
    }

    @Override
    public boolean isConfigurationValidForComponent(String language, File file) {
        return super.isConfigurationValidForComponent(language, file) && !this.isParentModuleMaven(file);
    }

    private boolean isParentModuleMaven(File file) {
        if (!file.toPath().endsWith("pom.xml")) {
            return false;
        }
        try {
            NodeList modules = DocumentParser.getElementsByTag(file, "modules");
            return modules != null && modules.getLength() > 0;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            return false;
        }
    }
}

