/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.alizer.api.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.redhat.devtools.alizer.api.spi.LanguageEnricherProvider;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.ServiceLoader;

public class Utils {
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();

    public static LanguageEnricherProvider getEnricherByLanguage(String language) {
        ServiceLoader<LanguageEnricherProvider> loader = ServiceLoader.load(LanguageEnricherProvider.class, Utils.class.getClassLoader());
        for (LanguageEnricherProvider provider : loader) {
            if (!provider.create().getSupportedLanguages().stream().anyMatch(supported -> supported.equalsIgnoreCase(language))) continue;
            return provider;
        }
        return null;
    }

    public static Map getJsonFileAsMap(File file) throws IOException {
        return (Map)JSON_MAPPER.readValue(file, Map.class);
    }
}

