/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.alizer.cli;

import com.redhat.devtools.alizer.api.DevfileType;
import com.redhat.devtools.alizer.api.LanguageRecognizer;
import com.redhat.devtools.alizer.api.RecognizerFactory;
import com.redhat.devtools.alizer.cli.BaseCommand;
import com.redhat.devtools.alizer.cli.DevfileTypeAdapter;
import com.redhat.devtools.alizer.registry.support.DevfileRegistryMetadataProviderBuilder;
import io.quarkus.qute.TemplateInstance;
import io.quarkus.qute.api.CheckedTemplate;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import picocli.CommandLine;

@CommandLine.Command(name="devfile")
public class DevfileCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Option(names={"-r", "--registry"}, description={"Pass the registry"})
    List<String> registries;

    @Override
    public void run() {
        LanguageRecognizer reco = new RecognizerFactory().createLanguageRecognizer();
        DevfileType type = null;
        try {
            if (this.registries != null && !this.registries.isEmpty()) {
                List devfiles = new DevfileRegistryMetadataProviderBuilder().withURLs(this.registries).build().getDevfileMetada();
                type = reco.selectDevFileFromTypes(this.name, devfiles.stream().map(DevfileTypeAdapter::new).collect(Collectors.toList()));
            }
            System.out.println(this.getTemplateForFormat(Templates.result(type)).render());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @CheckedTemplate
    public static class Templates {
        public static native TemplateInstance result(DevfileType var0);
    }
}

