/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.alizer.registry.support;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.redhat.devtools.alizer.registry.support.DevfileMetadata;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

public class DevfileRegistryProxy {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String INDEX_PATH = "index";
    private static final String DEVFILES_INDEX_JSON = "blob/HEAD/devfiles/index.json";
    private final String url;

    public DevfileRegistryProxy(String url) {
        this.url = url;
    }

    private static String append(String url, String path) {
        if (url.endsWith("/")) {
            return url + path;
        }
        return url + '/' + path;
    }

    private static String adapt(String url) throws MalformedURLException {
        url = url.replaceFirst("^https://github.com/(.*)/blob/(.*)$", "https://raw.githubusercontent.com/$1/$2");
        url = url.replaceFirst("^https://gitlab.com/(.*)/-/blob/(.*)$", "https://gitlab.com/$1/-/raw/$2");
        url = url.replaceFirst("^https://bitbucket.org/(.*)/src/(.*)$", "https://bitbucket.org/$1/raw/$2");
        return url;
    }

    public void collect(List<DevfileMetadata> devfileMetadata) throws IOException {
        try {
            URL u = new URL(DevfileRegistryProxy.adapt(DevfileRegistryProxy.append(this.url, INDEX_PATH)));
            ((List)MAPPER.readValue(u.openStream(), (TypeReference)new TypeReference<List<DevfileMetadata>>(){})).forEach(devfile -> devfileMetadata.add((DevfileMetadata)devfile));
        }
        catch (IOException e) {
            URL u = new URL(DevfileRegistryProxy.adapt(DevfileRegistryProxy.append(this.url, DEVFILES_INDEX_JSON)));
            ((List)MAPPER.readValue(u.openStream(), (TypeReference)new TypeReference<List<DevfileMetadata>>(){})).forEach(devfile -> devfileMetadata.add((DevfileMetadata)devfile));
        }
    }
}

