/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.rcm.maven.plugin.buildmetadata.data;

import com.redhat.rcm.maven.plugin.buildmetadata.common.MojoUtils;
import com.redhat.rcm.maven.plugin.buildmetadata.common.Property;
import com.redhat.rcm.maven.plugin.buildmetadata.data.AbstractMetaDataProvider;
import com.redhat.rcm.maven.plugin.buildmetadata.data.MavenMetaDataSelection;
import com.redhat.rcm.maven.plugin.buildmetadata.maven.MavenPropertyHelper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.RuntimeInformation;
import org.apache.maven.model.Profile;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MavenMetaDataProvider
extends AbstractMetaDataProvider {
    private final MavenMetaDataSelection selection;

    public MavenMetaDataProvider(MavenProject project, MavenSession session, RuntimeInformation runtime, MavenMetaDataSelection selection) {
        this.project = project;
        this.session = session;
        this.runtime = runtime;
        this.selection = selection;
    }

    @Override
    public void provideBuildMetaData(Properties buildMetaDataProperties) {
        List<Property> selectedProperties;
        if (this.runtime != null) {
            this.provideRuntimeInfo(buildMetaDataProperties);
        }
        if (this.session != null) {
            this.provideSessionInfo(buildMetaDataProperties);
        }
        if (this.project != null) {
            this.provideProjectInfo(buildMetaDataProperties);
        }
        if ((selectedProperties = this.selection.getSelectedSystemProperties()) != null && !selectedProperties.isEmpty()) {
            this.provideSelectedProperties(buildMetaDataProperties, selectedProperties);
        }
    }

    private void provideRuntimeInfo(Properties buildMetaDataProperties) {
        ArtifactVersion mavenVersion = this.runtime.getApplicationVersion();
        String mavenVersionString = mavenVersion.toString();
        buildMetaDataProperties.setProperty("build.maven.version", mavenVersionString);
        if (this.selection.isAddJavaRuntimeInfo()) {
            this.providePropertyIfExists(buildMetaDataProperties, "java.runtime.name", "build.java.runtime.name");
            this.providePropertyIfExists(buildMetaDataProperties, "java.runtime.version", "build.java.runtime.version");
            this.providePropertyIfExists(buildMetaDataProperties, "java.vendor", "build.java.vendor");
            this.providePropertyIfExists(buildMetaDataProperties, "java.vm.name", "build.java.vm");
            this.providePropertyIfExists(buildMetaDataProperties, "sun.management.compiler", "build.java.compiler");
        }
        if (this.selection.isAddOsInfo()) {
            this.providePropertyIfExists(buildMetaDataProperties, "os.name", "build.os.name");
            this.providePropertyIfExists(buildMetaDataProperties, "os.arch", "build.os.arch");
            this.providePropertyIfExists(buildMetaDataProperties, "os.version", "build.os.version");
        }
    }

    private void providePropertyIfExists(Properties buildMetaDataProperties, String systemPropertyName, String propName) {
        String value = System.getProperty(systemPropertyName);
        if (StringUtils.isNotBlank((String)value)) {
            buildMetaDataProperties.setProperty(propName, value);
        }
    }

    private void provideSelectedProperties(Properties buildMetaDataProperties, List<Property> selectedProperties) {
        MavenPropertyHelper helper = new MavenPropertyHelper(this.project);
        for (Property property : selectedProperties) {
            String name = property.getName();
            String fixedValue = property.getValue();
            if (fixedValue != null) {
                MavenMetaDataProvider.setProperty(buildMetaDataProperties, property, fixedValue);
                continue;
            }
            String mavenPropertyValue = helper.getProperty(name);
            if (mavenPropertyValue != null) {
                MavenMetaDataProvider.setProperty(buildMetaDataProperties, property, mavenPropertyValue);
                continue;
            }
            String value = System.getProperty(name);
            if (StringUtils.isNotBlank((String)value)) {
                MavenMetaDataProvider.setProperty(buildMetaDataProperties, property, value);
                continue;
            }
            String envValue = System.getenv(name);
            if (!StringUtils.isNotBlank((String)envValue)) continue;
            MavenMetaDataProvider.setProperty(buildMetaDataProperties, property, envValue);
        }
    }

    private static void setProperty(Properties buildMetaDataProperties, Property property, String value) {
        String name = property.getMappedName();
        buildMetaDataProperties.setProperty(name, value);
    }

    private void provideSessionInfo(Properties buildMetaDataProperties) {
        Properties executionProperties = this.provideExecutionProperties(buildMetaDataProperties);
        if (this.selection.isAddMavenExecutionInfo()) {
            this.provideGoals(buildMetaDataProperties);
            this.provideSpecialEnvVars(buildMetaDataProperties, executionProperties);
        }
    }

    private void provideProjectInfo(Properties buildMetaDataProperties) {
        if (this.selection.isAddMavenExecutionInfo()) {
            this.provideActiveProfiles(buildMetaDataProperties);
            this.provideExecutedProjectInfo(buildMetaDataProperties);
            String filters = MojoUtils.toPrettyString(this.project.getFilters());
            if (StringUtils.isNotBlank((String)filters)) {
                buildMetaDataProperties.setProperty("build.maven.execution.filters", filters);
            }
        }
        if (this.selection.isAddProjectInfo()) {
            Properties projectProperties;
            String projectUrl = this.project.getUrl();
            if (StringUtils.isNotBlank((String)projectUrl)) {
                buildMetaDataProperties.setProperty("project.page.home.url", projectUrl);
            }
            if ((projectProperties = this.project.getProperties()) != null) {
                MavenMetaDataProvider.providePropertiesProperty(buildMetaDataProperties, projectProperties, "project.page.ops.url");
                MavenMetaDataProvider.providePropertiesProperty(buildMetaDataProperties, projectProperties, "project.category");
                MavenMetaDataProvider.providePropertiesProperty(buildMetaDataProperties, projectProperties, "project.subcategory");
                MavenMetaDataProvider.providePropertiesProperty(buildMetaDataProperties, projectProperties, "project.tags");
            }
        }
    }

    private static void providePropertiesProperty(Properties buildMetaDataProperties, Properties projectProperties, String name) {
        String value = projectProperties.getProperty(name);
        if (StringUtils.isNotBlank((String)value)) {
            buildMetaDataProperties.setProperty(name, value);
        }
    }

    private void provideExecutedProjectInfo(Properties buildMetaDataProperties) {
        buildMetaDataProperties.setProperty("build.maven.execution.isRoot", String.valueOf(this.project.isExecutionRoot()));
        MavenProject executionProject = this.project.getExecutionProject();
        if (executionProject != null) {
            buildMetaDataProperties.setProperty("build.maven.execution.project", executionProject.getId());
        }
    }

    private void provideActiveProfiles(Properties buildMetaDataProperties) {
        List<Profile> profiles = this.getActiveProfiles();
        if (profiles != null && !profiles.isEmpty()) {
            ArrayList<String> profileIds = new ArrayList<String>(profiles.size());
            for (Profile profile : profiles) {
                String profileId = profile.getId();
                if (profileIds.contains(profileId)) continue;
                String key = "build.maven.execution.profile.active." + profileId;
                String value = profile.getSource();
                buildMetaDataProperties.setProperty(key, value);
                profileIds.add(profileId);
            }
            buildMetaDataProperties.setProperty("build.maven.execution.profiles.active", MojoUtils.toPrettyString(profileIds));
        }
    }

    private List<Profile> getActiveProfiles() {
        return this.project.getActiveProfiles();
    }

    private void provideGoals(Properties buildMetaDataProperties) {
        String goals = MojoUtils.toPrettyString(this.session.getGoals());
        buildMetaDataProperties.setProperty("build.maven.execution.goals", goals);
    }

    private Properties provideExecutionProperties(Properties buildMetaDataProperties) {
        Properties executionProperties = this.session.getExecutionProperties();
        if (this.selection.isAddEnvInfo()) {
            TreeSet<Object> sortedKeys = new TreeSet<Object>();
            sortedKeys.addAll(executionProperties.keySet());
            for (Object e : sortedKeys) {
                String key = "execution.property." + e;
                String value = executionProperties.getProperty((String)e);
                buildMetaDataProperties.setProperty(key, value);
            }
        }
        return executionProperties;
    }

    private void provideSpecialEnvVars(Properties buildMetaDataProperties, Properties executionProperties) {
        String javaOpts;
        String mavenOpts;
        String commandLine;
        if (!this.selection.isHideCommandLineInfo() && !StringUtils.isEmpty((String)(commandLine = MavenMetaDataProvider.getCommandLine(executionProperties)))) {
            buildMetaDataProperties.setProperty("build.maven.execution.cmdline", commandLine);
        }
        if (!this.selection.isHideMavenOptsInfo() && !StringUtils.isEmpty((String)(mavenOpts = executionProperties.getProperty("env.MAVEN_OPTS")))) {
            buildMetaDataProperties.setProperty("build.maven.execution.opts", mavenOpts);
        }
        if (!this.selection.isHideJavaOptsInfo() && !StringUtils.isEmpty((String)(javaOpts = executionProperties.getProperty("env.JAVA_OPTS")))) {
            buildMetaDataProperties.setProperty("build.maven.execution.java.opts", javaOpts);
        }
    }

    private static String getCommandLine(Properties executionProperties) {
        String commandLine = MavenMetaDataProvider.probEnv(executionProperties);
        if (StringUtils.isNotBlank((String)commandLine)) {
            return commandLine;
        }
        commandLine = MavenMetaDataProvider.probeSunVm(executionProperties);
        if (StringUtils.isNotBlank((String)commandLine)) {
            return commandLine;
        }
        commandLine = MavenMetaDataProvider.probeLinuxPs();
        if (StringUtils.isBlank((String)commandLine)) {
            commandLine = MavenMetaDataProvider.probeJmx();
        }
        return commandLine;
    }

    private static String probEnv(Properties executionProperties) {
        String commandLine = executionProperties.getProperty("env.MAVEN_CMD_LINE_ARGS");
        return commandLine;
    }

    private static String probeSunVm(Properties executionProperties) {
        String commandLine = executionProperties.getProperty("sun.java.command");
        if (commandLine != null) {
            String prefix = "org.codehaus.plexus.classworlds.launcher.Launcher ";
            if (commandLine.startsWith("org.codehaus.plexus.classworlds.launcher.Launcher ")) {
                commandLine = commandLine.substring("org.codehaus.plexus.classworlds.launcher.Launcher ".length());
            }
        }
        return commandLine;
    }

    private static String probeLinuxPs() {
        Long pid = MavenMetaDataProvider.getProcessId();
        if (pid != null) {
            try {
                Process process = Runtime.getRuntime().exec("ps -o args -p " + pid);
                try {
                    process.waitFor();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                int exit = process.exitValue();
                if (exit == 0) {
                    String commandLine = IOUtil.toString((InputStream)process.getInputStream());
                    return commandLine;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Long getProcessId() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        int index = name.indexOf(64);
        if (index > 0) {
            try {
                return Long.parseLong(name.substring(0, index));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private static String probeJmx() {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        String commandLine = runtime.getInputArguments().toString();
        return commandLine;
    }
}

