/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.rcm.maven.plugin.buildmetadata;

import com.redhat.rcm.maven.plugin.buildmetadata.FileMapping;
import com.redhat.rcm.maven.plugin.buildmetadata.PropertyOutputFileMapper;
import com.redhat.rcm.maven.plugin.buildmetadata.common.Property;
import com.redhat.rcm.maven.plugin.buildmetadata.common.ScmInfo;
import com.redhat.rcm.maven.plugin.buildmetadata.data.MetaDataProvider;
import com.redhat.rcm.maven.plugin.buildmetadata.data.MetaDataProviderBuilder;
import com.redhat.rcm.maven.plugin.buildmetadata.data.Provider;
import com.redhat.rcm.maven.plugin.buildmetadata.io.BuildPropertiesFileHelper;
import com.redhat.rcm.maven.plugin.buildmetadata.util.ManifestHelper;
import com.redhat.rcm.maven.plugin.buildmetadata.util.MojoFileUtils;
import com.redhat.rcm.maven.plugin.buildmetadata.util.SettingsDecrypter;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.RuntimeInformation;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBuildMojo
extends AbstractMojo {
    protected MavenProject project;
    protected MavenSession session;
    protected RuntimeInformation runtime;
    protected File propertiesOutputFile;
    private boolean activateOutputFileMapping;
    private List<FileMapping> propertyOutputFileMapping;
    private List<FileMapping> xmlOutputFileMapping;
    protected File xmlOutputFile;
    protected File manifestFile;
    protected String manifestSection;
    protected boolean createManifestFile;
    protected boolean createPropertiesReport;
    protected boolean createXmlReport;
    protected boolean writeProtectFiles;
    protected List<Provider> providers;
    protected List<Property> properties;
    protected boolean addToFilters;
    protected String remoteVersion;
    private SecDispatcher securityDispatcher;
    private String settingsSecurityLocation;
    protected SettingsDecrypter settingsDecrypter;

    public final MavenProject getProject() {
        return this.project;
    }

    public final void setProject(MavenProject project) {
        this.project = project;
    }

    public final void setSession(MavenSession session) {
        this.session = session;
    }

    public final void setPropertiesOutputFile(File propertiesOutputFile) {
        this.propertiesOutputFile = propertiesOutputFile;
    }

    public boolean isCreatePropertiesReport() {
        return this.createPropertiesReport;
    }

    public void setCreatePropertiesReport(boolean createPropertiesReport) {
        this.createPropertiesReport = createPropertiesReport;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        String propertiesFileName = AbstractBuildMojo.calcFileName(this.propertiesOutputFile, "build.properties");
        if (this.createPropertiesReport) {
            this.settingsDecrypter = this.securityDispatcher != null ? new SettingsDecrypter(this.securityDispatcher, this.settingsSecurityLocation) : null;
            PropertyOutputFileMapper mapperProperties = new PropertyOutputFileMapper(this.project, this.propertyOutputFileMapping, propertiesFileName);
            this.propertyOutputFileMapping = mapperProperties.initOutputFileMapping();
            this.propertiesOutputFile = mapperProperties.getPropertiesOutputFile(this.activateOutputFileMapping, this.propertiesOutputFile);
        } else {
            this.propertiesOutputFile = new File(this.project.getBuild().getDirectory(), propertiesFileName);
        }
        if (this.createXmlReport) {
            String xmlFileName = AbstractBuildMojo.calcFileName(this.xmlOutputFile, "buildmetadata.xml");
            PropertyOutputFileMapper mapperXml = new PropertyOutputFileMapper(this.project, this.xmlOutputFileMapping, xmlFileName);
            this.xmlOutputFileMapping = mapperXml.initOutputFileMapping();
            this.xmlOutputFile = mapperXml.getPropertiesOutputFile(this.activateOutputFileMapping, this.xmlOutputFile);
        }
    }

    private static String calcFileName(File file, String defaultName) {
        String fileName = file != null ? file.getName() : defaultName;
        return fileName;
    }

    protected final void provideBuildMetaData(Properties buildMetaDataProperties, ScmInfo scmInfo, List<Provider> providers, boolean runAtEndOfBuild) throws MojoExecutionException {
        if (providers != null && !providers.isEmpty()) {
            MetaDataProviderBuilder builder = new MetaDataProviderBuilder(this.project, this.session, this.runtime, scmInfo);
            for (Provider providerConfig : providers) {
                if (providerConfig.isRunAtEndOfBuild() != runAtEndOfBuild) continue;
                MetaDataProvider provider = builder.build(providerConfig);
                provider.provideBuildMetaData(buildMetaDataProperties);
            }
        }
    }

    protected final void updateMavenEnvironment(Properties buildMetaDataProperties, BuildPropertiesFileHelper helper) throws MojoExecutionException {
        Properties projectProperties = helper.getProjectProperties(this.project);
        if (this.addToFilters) {
            this.project.getBuild().addFilter(this.propertiesOutputFile.getAbsolutePath());
        }
        if (this.createManifestFile) {
            ManifestHelper manifestHelper = new ManifestHelper(this.manifestFile, this.manifestSection);
            try {
                MojoFileUtils.ensureExists(this.manifestFile.getParentFile());
                manifestHelper.createManifest(buildMetaDataProperties);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot create Manifest file: " + this.manifestFile.getAbsolutePath(), (Exception)e);
            }
        }
        projectProperties.putAll((Map<?, ?>)buildMetaDataProperties);
    }
}

