/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.rcm.maven.plugin.buildmetadata;

import com.redhat.rcm.maven.plugin.buildmetadata.FileMapping;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Build;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PropertyOutputFileMapper {
    private final MavenProject project;
    private List<FileMapping> propertyOutputFileMapping;
    private final String fileName;

    PropertyOutputFileMapper(MavenProject project, List<FileMapping> propertyOutputFileMapping, String fileName) {
        this.project = project;
        this.propertyOutputFileMapping = propertyOutputFileMapping;
        this.fileName = fileName;
    }

    List<FileMapping> initOutputFileMapping() {
        if (this.propertyOutputFileMapping == null) {
            this.propertyOutputFileMapping = new ArrayList<FileMapping>(10);
            Build build = this.project.getBuild();
            String classesDir = build.getOutputDirectory();
            File jarFile = new File(classesDir, "META-INF/" + this.fileName);
            File targetDir = new File(build.getDirectory());
            String finalName = build.getFinalName();
            File deploymentUnitFile = new File(targetDir, finalName + "/META-INF/" + this.fileName);
            this.propertyOutputFileMapping.add(new FileMapping("pom", new File(targetDir, this.fileName)));
            this.propertyOutputFileMapping.add(new FileMapping("war", deploymentUnitFile));
            this.propertyOutputFileMapping.add(new FileMapping("ear", deploymentUnitFile));
            this.propertyOutputFileMapping.add(new FileMapping("sar", deploymentUnitFile));
            this.propertyOutputFileMapping.add(new FileMapping("rar", deploymentUnitFile));
            this.propertyOutputFileMapping.add(new FileMapping("par", deploymentUnitFile));
            this.propertyOutputFileMapping.add(new FileMapping("jar", jarFile));
            this.propertyOutputFileMapping.add(new FileMapping("bundle", jarFile));
            this.propertyOutputFileMapping.add(new FileMapping("ejb", jarFile));
            this.propertyOutputFileMapping.add(new FileMapping("maven-plugin", jarFile));
            this.propertyOutputFileMapping.add(new FileMapping("atlassian-plugin", jarFile));
            this.propertyOutputFileMapping.add(new FileMapping("maven-archetype", jarFile));
            this.propertyOutputFileMapping.add(new FileMapping("eclipse-plugin", new File(targetDir, this.fileName)));
            this.propertyOutputFileMapping.add(new FileMapping("eclipse-feature", new File(targetDir, this.fileName)));
            this.propertyOutputFileMapping.add(new FileMapping("eclipse-repository", new File(targetDir, this.fileName)));
            this.propertyOutputFileMapping.add(new FileMapping("eclipse-update-site", new File(targetDir, this.fileName)));
            this.propertyOutputFileMapping.add(new FileMapping("targetplatform", new File(targetDir, this.fileName)));
            return this.propertyOutputFileMapping;
        }
        return this.propertyOutputFileMapping;
    }

    File getPropertiesOutputFile(boolean activatePropertyOutputFileMapping, File propertiesOutputFile) {
        if (activatePropertyOutputFileMapping) {
            String packaging = this.project.getPackaging();
            for (FileMapping mapping : this.propertyOutputFileMapping) {
                if (!packaging.equals(mapping.getPackaging())) continue;
                return mapping.getOutputFile();
            }
        }
        return propertiesOutputFile;
    }
}

