/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.rcm.maven.plugin.buildmetadata.io;

import com.redhat.rcm.maven.plugin.buildmetadata.util.MojoFileUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class AdditionalLocationsSupport {
    private final MavenProject project;
    private final Config config;

    public AdditionalLocationsSupport(MavenProject project, Config config) {
        this.project = project;
        this.config = config;
    }

    public void handle(File file) throws MojoExecutionException {
        if (this.isToAttachSources()) {
            this.addFileToSources(file, "generated-sources", true);
        }
        if (this.config.addToLocations != null) {
            for (String location : this.config.addToLocations) {
                this.addFileToSources(file, location, false);
            }
        }
    }

    private boolean isToAttachSources() {
        if (!this.config.addToGeneratedSources) {
            return false;
        }
        Map plugins = this.project.getBuild().getPluginsAsMap();
        Plugin sourcesPlugin = (Plugin)plugins.get(Plugin.constructKey((String)"org.apache.maven.plugins", (String)"maven-source-plugin"));
        return sourcesPlugin != null;
    }

    private void addFileToSources(File propertiesFile, String targetLocation, boolean attach) throws MojoExecutionException {
        File generatedSourcesMetaInfDir;
        File targetLocationDir;
        File testFile = new File(targetLocation);
        if (testFile.isAbsolute()) {
            targetLocationDir = null;
            generatedSourcesMetaInfDir = testFile;
        } else {
            targetLocationDir = new File(this.project.getBuild().getDirectory(), targetLocation);
            generatedSourcesMetaInfDir = new File(targetLocationDir, "META-INF");
        }
        MojoFileUtils.ensureExists(generatedSourcesMetaInfDir);
        try {
            File propertiesFileInSources = new File(generatedSourcesMetaInfDir, propertiesFile.getName());
            FileUtils.copyFile((File)propertiesFile, (File)propertiesFileInSources);
            if (attach && targetLocationDir != null) {
                this.project.addCompileSourceRoot(targetLocationDir.getAbsolutePath());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot copy properties to generated sources.", (Exception)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Config {
        private boolean addToGeneratedSources;
        private List<String> addToLocations;

        public Config setAddToGeneratedSources(boolean addToGeneratedSources) {
            this.addToGeneratedSources = addToGeneratedSources;
            return this;
        }

        public Config setAddToLocations(List<String> addToLocations) {
            this.addToLocations = addToLocations;
            return this;
        }
    }
}

