/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.rcm.maven.plugin.buildmetadata.io;

import com.redhat.rcm.maven.plugin.buildmetadata.common.MojoUtils;
import com.redhat.rcm.maven.plugin.buildmetadata.common.SortedProperties;
import com.redhat.rcm.maven.plugin.buildmetadata.util.FilePathNormalizer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public final class BuildPropertiesFileHelper {
    private final Log log;
    private final File propertiesOutputFile;
    private final FilePathNormalizer filePathNormalizer;

    public BuildPropertiesFileHelper(Log log, File propertiesOutputFile, FilePathNormalizer filePathNormalizer) {
        this.log = log;
        this.propertiesOutputFile = propertiesOutputFile;
        this.filePathNormalizer = filePathNormalizer;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File writePropertiesFile(Properties buildMetaDataProperties) throws MojoExecutionException {
        File buildMetaDataFile = this.createBuildMetaDataFile(this.propertiesOutputFile);
        if (this.log.isInfoEnabled()) {
            this.log.info((CharSequence)("Writing properties '" + buildMetaDataFile.getAbsolutePath() + "'..."));
        }
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(buildMetaDataFile));
            String comments = "Created by buildmetadata-maven-plugin.";
            Properties sortedBuildMetaDataProperties = SortedProperties.createSorted(buildMetaDataProperties);
            this.normalizeProperties(sortedBuildMetaDataProperties);
            sortedBuildMetaDataProperties.store(out, "Created by buildmetadata-maven-plugin.");
        }
        catch (FileNotFoundException e) {
            try {
                String message = "Cannot find file '" + buildMetaDataFile + "' to write properties to.";
                throw MojoUtils.createException(this.log, e, message);
                catch (IOException e2) {
                    message = "Cannot write properties to file '" + buildMetaDataFile + "'.";
                    throw MojoUtils.createException(this.log, e2, message);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(out);
                throw throwable;
            }
        }
        IOUtil.close((OutputStream)out);
        return buildMetaDataFile;
    }

    private void normalizeProperties(Properties buildMetaDataProperties) {
        String filters = buildMetaDataProperties.getProperty("build.maven.execution.filters");
        if (filters != null) {
            String slashedFilters = filters.trim().replace('\\', '/');
            String slashedBaseDir = this.filePathNormalizer.getBaseDir().replace('\\', '/');
            String normBaseDir = slashedBaseDir.endsWith("/") ? slashedBaseDir : slashedBaseDir + '/';
            String normFilters = StringUtils.replace((String)slashedFilters, (String)normBaseDir, (String)"");
            buildMetaDataProperties.setProperty("build.maven.execution.filters", normFilters);
        }
    }

    private File createBuildMetaDataFile(File propertiesOutputFile) throws MojoExecutionException {
        boolean created;
        File outputDirectory = propertiesOutputFile.getParentFile();
        if (!outputDirectory.exists() && !(created = outputDirectory.mkdirs())) {
            throw new MojoExecutionException("Cannot create output directory '" + outputDirectory + "'.");
        }
        return propertiesOutputFile;
    }

    public void readBuildPropertiesFile(Properties buildMetaDataProperties) throws MojoExecutionException {
        BufferedInputStream inStream = null;
        try {
            inStream = new BufferedInputStream(new FileInputStream(this.propertiesOutputFile));
            buildMetaDataProperties.load(inStream);
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Cannot read provided properties file: " + this.propertiesOutputFile.getAbsolutePath(), (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(inStream);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)inStream);
    }

    public Properties getProjectProperties(MavenProject project) {
        Properties projectProperties = project.getProperties();
        if (projectProperties == null) {
            projectProperties = new Properties();
            project.getModel().setProperties(projectProperties);
        }
        return projectProperties;
    }
}

