/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.rcm.maven.plugin.buildmetadata.io;

import com.redhat.rcm.maven.plugin.buildmetadata.common.Constant;
import com.redhat.rcm.maven.plugin.buildmetadata.common.Property;
import com.redhat.rcm.maven.plugin.buildmetadata.common.SortedProperties;
import com.redhat.rcm.maven.plugin.buildmetadata.util.FilePathNormalizer;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.plexus.util.StringUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SdocBuilder {
    private static final String XML_SCHEMA_INSTANCE = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String CODE_URI = "http://www.smartics.de/project/process/implementation/buildmetadata";
    private static final String GI_VERSION = "version";
    private static final String GI_NAME = "name";
    private static final Log LOG = LogFactory.getLog(SdocBuilder.class);
    private final FilePathNormalizer filePathNormalizer;
    private final Document document;
    private final Properties buildMetaDataProperties;
    private final List<Property> selectedProperties;

    public SdocBuilder(FilePathNormalizer filePathNormalizer, Document document, Properties buildMetaDataProperties, List<Property> selectedProperties) {
        this.filePathNormalizer = filePathNormalizer;
        this.document = document;
        this.buildMetaDataProperties = buildMetaDataProperties;
        this.selectedProperties = selectedProperties;
    }

    public Document writeDocumentContent() throws IOException {
        Element docRoot = this.createDocRoot();
        this.createContentElement(GI_NAME, "build.version.full", docRoot);
        this.createContentElement("category", "project.category", docRoot);
        this.createContentElement("subcategory", "project.subcategory", docRoot);
        this.createContentElement(GI_VERSION, "build.version", docRoot);
        this.createContentElement("groupId", "build.groupId", docRoot);
        this.createContentElement("artifactId", "build.artifactId", docRoot);
        String date = this.formatDate("build.date");
        this.createValueElement("date", date, docRoot);
        this.createContentElement("timestamp", "build.timestamp.millis", docRoot);
        this.createTagsElement(docRoot);
        this.createContentElement("build-year", "build.year", docRoot);
        this.createProjectElement(docRoot);
        this.createScmElement(docRoot);
        this.createRuntimeElement(docRoot);
        this.createMiscElement(docRoot);
        return this.document;
    }

    private void createTagsElement(Element docRoot) {
        Element tags = this.document.createElement("tags");
        String tagsString = this.buildMetaDataProperties.getProperty("project.tags");
        this.renderList(tags, "tag", tagsString);
        if (tags.hasChildNodes()) {
            docRoot.appendChild(tags);
        }
    }

    private String formatDate(String datePropertyKey) {
        String originalDateString = this.buildMetaDataProperties.getProperty(datePropertyKey);
        if (StringUtils.isNotBlank((String)originalDateString)) {
            try {
                String originalPattern = this.buildMetaDataProperties.getProperty("build.date.pattern");
                SimpleDateFormat format = new SimpleDateFormat(originalPattern, Locale.ENGLISH);
                Date date = format.parse(originalDateString);
                String dateString = DateFormatUtils.ISO_DATETIME_FORMAT.format(date);
                return dateString;
            }
            catch (ParseException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Cannot parse date of property '" + datePropertyKey + "': " + originalDateString + ". Skipping..."));
                }
                return null;
            }
        }
        return null;
    }

    private void createScmElement(Element docRoot) {
        Element parent = this.document.createElement("scm");
        this.createContentElement("revision", "build.scmRevision.id", parent);
        String date = this.formatDate("build.scmRevision.date");
        this.createValueElement("revision-date", date, parent);
        this.createContentElement("url", "build.scmRevision.url", parent);
        this.createLocallyModifiedFiles(parent);
        docRoot.appendChild(parent);
    }

    private void createLocallyModifiedFiles(Element scm) {
        String value = this.buildMetaDataProperties.getProperty("build.scmLocallyModified.files");
        if (StringUtils.isNotBlank((String)value)) {
            Element parent = this.document.createElement("locally-modified-files");
            String filesValue = Constant.prettifyFilesValue(value);
            this.renderFiles(parent, filesValue);
            scm.appendChild(parent);
        }
    }

    private void renderFiles(Element lmf, String value) {
        String stringValue = Constant.prettify(value);
        StringTokenizer tokenizer = new StringTokenizer(stringValue, ",");
        while (tokenizer.hasMoreTokens()) {
            String filePath;
            Element file;
            String subValue = tokenizer.nextToken();
            int colonIndex = subValue.indexOf(58);
            if (colonIndex <= -1 || (file = this.createValueElement("file", filePath = subValue.substring(0, colonIndex), lmf)) == null || colonIndex >= subValue.length() - 1) continue;
            String modType = subValue.substring(colonIndex + 1).trim();
            file.setAttribute("modtype", modType);
        }
    }

    private void createProjectElement(Element docRoot) {
        Element parent = this.document.createElement("project");
        this.createContentElement("copyright-year", "build.copyright.year", parent);
        this.createContentElement("home-page-url", "project.page.home.url", parent);
        this.createContentElement("ops-home-page-url", "project.page.ops.url", parent);
        if (parent.hasChildNodes()) {
            docRoot.appendChild(parent);
        }
    }

    private void renderList(Element tags, String itemTag, String value) {
        if (StringUtils.isNotBlank((String)value)) {
            String stringValue = Constant.prettify(value);
            StringTokenizer tokenizer = new StringTokenizer(stringValue, ",");
            while (tokenizer.hasMoreTokens()) {
                String item = tokenizer.nextToken();
                this.createValueElement(itemTag, item.trim(), tags);
            }
        }
    }

    private void createRuntimeElement(Element docRoot) {
        Element parent = this.document.createElement("runtime");
        this.createContentElement("build-server", "build.host.name", parent);
        this.createContentElement("build-user", "build.user", parent);
        this.createOsElement(parent);
        this.createJavaElement(parent);
        this.createMavenElement(parent);
        this.createEnvElement(parent);
        docRoot.appendChild(parent);
    }

    private void createOsElement(Element runtime) {
        Element parent = this.document.createElement("os");
        this.createContentElement("arch", "build.os.arch", parent);
        this.createContentElement(GI_NAME, "build.os.name", parent);
        this.createContentElement(GI_VERSION, "build.os.version", parent);
        if (parent.hasChildNodes()) {
            runtime.appendChild(parent);
        }
    }

    private void createJavaElement(Element runtime) {
        Element parent = this.document.createElement("java");
        this.createContentElement(GI_NAME, "build.java.runtime.name", parent);
        this.createContentElement(GI_VERSION, "build.java.runtime.version", parent);
        this.createContentElement("vendor", "build.java.vendor", parent);
        this.createContentElement("vm", "build.java.vm", parent);
        this.createContentElement("compiler", "build.java.compiler", parent);
        this.createContentElement("options", "build.maven.execution.java.opts", parent);
        if (parent.hasChildNodes()) {
            runtime.appendChild(parent);
        }
    }

    private void createMavenElement(Element runtime) {
        Element parent = this.document.createElement("maven");
        this.createContentElement(GI_VERSION, "build.maven.version", parent);
        this.createContentElement("commandline", "build.maven.execution.cmdline", parent);
        this.createContentElement("execution-project", "build.maven.execution.project", parent);
        this.createContentElement("is-excution-root", "build.maven.execution.isRoot", parent);
        Element goals = this.document.createElement("goals");
        String goalsString = this.buildMetaDataProperties.getProperty("build.maven.execution.goals");
        this.renderList(goals, "goal", goalsString);
        parent.appendChild(goals);
        Element filters = this.document.createElement("filters");
        String filtersString = this.buildMetaDataProperties.getProperty("build.maven.execution.filters");
        this.renderFiles(filters, "filter", filtersString);
        if (filters.hasChildNodes()) {
            parent.appendChild(filters);
        }
        Element profiles = this.document.createElement("profiles");
        String profilesString = this.buildMetaDataProperties.getProperty("build.maven.execution.profiles.active");
        if (StringUtils.isNotBlank((String)profilesString)) {
            this.renderProfiles(profiles, profilesString);
            parent.appendChild(profiles);
        }
        this.createContentElement("options", "build.maven.execution.opts", parent);
        if (parent.hasChildNodes()) {
            runtime.appendChild(parent);
        }
    }

    private void renderFiles(Element parent, String itemTag, String value) {
        if (StringUtils.isNotBlank((String)value)) {
            String stringValue = Constant.prettify(value);
            StringTokenizer tokenizer = new StringTokenizer(stringValue, ",");
            while (tokenizer.hasMoreTokens()) {
                String item = tokenizer.nextToken();
                String itemTrimmed = item.trim();
                String itemNorm = this.filePathNormalizer.normalize(itemTrimmed);
                this.createValueElement(itemTag, itemNorm, parent);
            }
        }
    }

    private void renderProfiles(Element profiles, String value) {
        String stringValue = Constant.prettify(value);
        StringTokenizer tokenizer = new StringTokenizer(stringValue, ",");
        while (tokenizer.hasMoreTokens()) {
            String profileName = tokenizer.nextToken().trim();
            Element profile = this.createValueElement("profile", profileName, profiles);
            if (profile == null) continue;
            String profileSourceKey = "build.maven.execution.profile.active." + profileName;
            String source = this.buildMetaDataProperties.getProperty(profileSourceKey);
            profile.setAttribute("source", source);
        }
    }

    private void createEnvElement(Element runtime) {
        Element parent = this.document.createElement("env");
        Properties sorted = SortedProperties.createSorted(this.buildMetaDataProperties);
        String matchPrefix = "execution.property.";
        for (Map.Entry<Object, Object> entry : sorted.entrySet()) {
            String value;
            Element env;
            String key = String.valueOf(entry.getKey());
            if (!key.startsWith("execution.property.") || (env = this.createValueElement("var", value = String.valueOf(entry.getValue()), parent)) == null) continue;
            env.setAttribute(GI_NAME, key);
        }
        if (parent.hasChildNodes()) {
            runtime.appendChild(parent);
        }
    }

    private void createMiscElement(Element docRoot) {
        Properties nonStandardProperties = Constant.calcNonStandardProperties(this.buildMetaDataProperties, this.selectedProperties);
        if (!nonStandardProperties.isEmpty()) {
            Element parent = this.document.createElement("misc");
            Enumeration<Object> en = nonStandardProperties.keys();
            while (en.hasMoreElements()) {
                String key = String.valueOf(en.nextElement());
                this.createMetaDataElement(parent, key);
            }
            docRoot.appendChild(parent);
        }
    }

    private void createMetaDataElement(Element parent, String key) {
        Element metadata;
        if (Constant.isIntendedForMiscSection(key) && (metadata = this.createContentElement("metadata", key, parent)) != null) {
            metadata.setAttribute(GI_NAME, key);
        }
    }

    private Element createDocRoot() throws DOMException {
        Element docRoot = this.document.createElement("buildmetadata");
        docRoot.setAttribute("xmlns:xsi", XML_SCHEMA_INSTANCE);
        docRoot.setAttribute("xmlns", CODE_URI);
        docRoot.setAttribute("xsi:schemaLocation", "http://www.smartics.de/project/process/implementation/buildmetadata http://www.smartics.de/project/process/implementation/buildmetadata");
        this.document.appendChild(docRoot);
        return docRoot;
    }

    private Element createContentElement(String gi, String propertyKey, Element parent) {
        String content = this.buildMetaDataProperties.getProperty(propertyKey);
        return this.createValueElement(gi, content, parent);
    }

    private Element createValueElement(String gi, String value, Element parent) {
        if (value != null) {
            Element element = this.document.createElement(gi);
            Text text = this.document.createTextNode(value);
            element.appendChild(text);
            parent.appendChild(element);
            return element;
        }
        return null;
    }
}

