/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.rcm.maven.plugin.buildmetadata.maven;

import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.maven.project.MavenProject;

public final class MavenPropertyHelper {
    private static final String PROJECT_PROPERTY_NAME_PREFIX = "project.";
    private static final int PROJECT_PROPERTY_NAME_PREFIX_LENGTH = "project.".length();
    private final MavenProject project;

    public MavenPropertyHelper(MavenProject project) {
        if (project == null) {
            throw new NullPointerException("The property helper requires the project reference to be not 'null'.");
        }
        this.project = project;
    }

    public String getProperty(String name) {
        if (name == null) {
            throw new NullPointerException("Name of requested property must not be 'null'");
        }
        String value = null;
        if (this.isProjectProperty(name)) {
            value = this.getProjectProperty(name);
        }
        if (value == null) {
            value = this.getPropertiesProperty(name);
        }
        return value;
    }

    private boolean isProjectProperty(String name) {
        return name != null && name.length() >= PROJECT_PROPERTY_NAME_PREFIX_LENGTH && name.startsWith(PROJECT_PROPERTY_NAME_PREFIX);
    }

    private String getProjectProperty(String name) {
        String projectName = name.substring(PROJECT_PROPERTY_NAME_PREFIX_LENGTH);
        if (PropertyUtils.isReadable((Object)this.project, (String)projectName)) {
            try {
                return MavenPropertyHelper.getProjectProperty(this.project, projectName);
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot access project property '" + name + "'.");
            }
        }
        return null;
    }

    private static String getProjectProperty(MavenProject project, String projectName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (project != null) {
            Object value = PropertyUtils.getProperty((Object)project, (String)projectName);
            if (value != null) {
                return String.valueOf(value);
            }
            return MavenPropertyHelper.getProjectProperty(project.getParent(), projectName);
        }
        return null;
    }

    private String getPropertiesProperty(String name) {
        return MavenPropertyHelper.getPropertiesProperty(this.project, name);
    }

    private static String getPropertiesProperty(MavenProject project, String name) {
        String value = null;
        Properties properties = project.getProperties();
        if (properties != null) {
            value = properties.getProperty(name);
        }
        if (value == null) {
            value = MavenPropertyHelper.getPropertiesPropertyFromParent(project, name);
        }
        return value;
    }

    private static String getPropertiesPropertyFromParent(MavenProject project, String name) {
        MavenProject parentProject = project.getParent();
        String value = parentProject != null ? MavenPropertyHelper.getPropertiesProperty(parentProject, name) : null;
        return value;
    }
}

