/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.rcm.maven.plugin.buildmetadata.util;

import com.redhat.rcm.maven.plugin.buildmetadata.util.Normalizer;

public final class FilePathNormalizer
implements Normalizer {
    private final String baseDir;
    private final int prefixLength;

    public FilePathNormalizer(String baseDir) throws NullPointerException {
        this.baseDir = baseDir.trim();
        this.prefixLength = baseDir.length();
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public String normalize(String input) {
        String prefixed = input.startsWith(this.baseDir) ? input.substring(this.prefixLength) : input;
        String norm = prefixed.replace('\\', '/');
        if (norm.charAt(0) == '/' && norm.length() > 1) {
            return norm.substring(1);
        }
        return norm;
    }
}

