/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.rcm.maven.plugin.buildmetadata.data;

import com.redhat.rcm.maven.plugin.buildmetadata.common.RevisionHelper;
import com.redhat.rcm.maven.plugin.buildmetadata.common.ScmControl;
import com.redhat.rcm.maven.plugin.buildmetadata.common.ScmCredentials;
import com.redhat.rcm.maven.plugin.buildmetadata.common.ScmInfo;
import com.redhat.rcm.maven.plugin.buildmetadata.data.AbstractMetaDataProvider;
import com.redhat.rcm.maven.plugin.buildmetadata.scm.ScmNoRevisionException;
import com.redhat.rcm.maven.plugin.buildmetadata.scm.maven.ScmAccessInfo;
import com.redhat.rcm.maven.plugin.buildmetadata.scm.maven.ScmConnectionInfo;
import java.util.Locale;
import java.util.Properties;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.provider.ScmProviderRepositoryWithHost;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.codehaus.plexus.util.StringUtils;

public class ScmMetaDataProvider
extends AbstractMetaDataProvider {
    public ScmMetaDataProvider(MavenProject project, ScmInfo scmInfo) {
        this.project = project;
        this.scmInfo = scmInfo;
    }

    @Override
    public final void provideBuildMetaData(Properties buildMetaDataProperties) {
        ScmControl scmControl = this.scmInfo.getScmControl();
        if (scmControl.isAddScmInfo() && !scmControl.isOffline() && this.project.getScm() != null) {
            try {
                ScmConnectionInfo scmConnectionInfo = this.loadConnectionInfo();
                ScmAccessInfo scmAccessInfo = this.createScmAccessInfo();
                RevisionHelper helper = new RevisionHelper(this.scmInfo.getScmManager(), scmConnectionInfo, scmAccessInfo, this.scmInfo.getBuildDatePattern());
                helper.provideScmBuildInfo(buildMetaDataProperties, scmControl);
            }
            catch (ScmRepositoryException e) {
                throw new ScmNoRevisionException("Unable to determine SCM revision information.", e);
            }
            catch (NoSuchScmProviderException e) {
                throw new ScmNoRevisionException("Unable to determine SCM revision information.", e);
            }
        } else {
            this.getLog().debug((CharSequence)("Skipping SCM data since addScmInfo=" + scmControl.isAddScmInfo() + ", offline=" + scmControl.isOffline() + ", scmInfoProvided=" + (this.project.getScm() != null) + "."));
        }
    }

    private ScmConnectionInfo loadConnectionInfo() throws IllegalStateException, ScmRepositoryException, NoSuchScmProviderException {
        ScmRepository repository;
        String scmConnection = this.getConnection();
        ScmCredentials credentials = this.scmInfo.getScmCrendentials();
        if ((credentials.getUserName() == null || credentials.getPassword() == null) && (repository = this.scmInfo.getScmManager().makeScmRepository(scmConnection)).getProviderRepository() instanceof ScmProviderRepositoryWithHost) {
            ScmProviderRepositoryWithHost repositoryWithHost = (ScmProviderRepositoryWithHost)repository.getProviderRepository();
            String host = this.createHostName(repositoryWithHost);
            credentials.configureByServer(host);
        }
        ScmConnectionInfo info = new ScmConnectionInfo();
        info.setUserName(credentials.getUserName());
        info.setPassword(credentials.getPassword());
        info.setPrivateKey(credentials.getPrivateKey());
        info.setScmConnectionUrl(scmConnection);
        info.setTagBase(this.scmInfo.getTagBase());
        info.setRemoteVersion(this.scmInfo.getRemoteVersion());
        return info;
    }

    protected final String getConnection() throws IllegalStateException {
        if (this.project.getScm() == null) {
            throw new IllegalStateException("SCM Connection is not set.");
        }
        String scmConnection = this.project.getScm().getConnection();
        String connectionType = this.scmInfo.getConnectionType();
        if (StringUtils.isNotEmpty((String)scmConnection) && "connection".equals(connectionType.toLowerCase(Locale.ENGLISH))) {
            return scmConnection;
        }
        String scmDeveloper = this.project.getScm().getDeveloperConnection();
        if (StringUtils.isNotEmpty((String)scmDeveloper) && "developerconnection".equals(connectionType.toLowerCase(Locale.ENGLISH))) {
            return scmDeveloper;
        }
        throw new IllegalStateException("SCM Connection is not set.");
    }

    private String createHostName(ScmProviderRepositoryWithHost repositoryWithHost) {
        String host = repositoryWithHost.getHost();
        int port = repositoryWithHost.getPort();
        if (port > 0) {
            return host + ":" + port;
        }
        return host;
    }

    private ScmAccessInfo createScmAccessInfo() {
        ScmAccessInfo accessInfo = new ScmAccessInfo();
        accessInfo.setDateFormat(this.scmInfo.getScmDateFormat());
        accessInfo.setRootDirectory(this.scmInfo.getBasedir());
        accessInfo.setFailOnLocalModifications(this.scmInfo.getScmControl().isFailOnLocalModifications());
        accessInfo.setIgnoreDotFilesInBaseDir(this.scmInfo.getScmControl().isIgnoreDotFilesInBaseDir());
        accessInfo.setQueryRangeInDays(this.scmInfo.getQueryRangeInDays());
        return accessInfo;
    }
}

