/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.rcm.maven.plugin.buildmetadata.scm.maven;

import com.redhat.rcm.maven.plugin.buildmetadata.scm.ScmException;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmRevision;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.changelog.ChangeLogScmRequest;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogSet;
import org.apache.maven.scm.command.info.InfoItem;
import org.apache.maven.scm.command.info.InfoScmResult;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.codehaus.plexus.util.StringUtils;

public final class ScmAccessInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_RETRY_COUNT = 5;
    private String dateFormat;
    private File rootDirectory;
    private int queryRangeInDays;
    private boolean failOnLocalModifications;
    private boolean ignoreDotFilesInBaseDir;

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public File getRootDirectory() {
        return this.rootDirectory;
    }

    public void setRootDirectory(File rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    public int getQueryRangeInDays() {
        return this.queryRangeInDays;
    }

    public void setQueryRangeInDays(int queryRangeInDays) {
        this.queryRangeInDays = queryRangeInDays;
    }

    public boolean isFailOnLocalModifications() {
        return this.failOnLocalModifications;
    }

    public void setFailOnLocalModifications(boolean failOnLocalModifications) {
        this.failOnLocalModifications = failOnLocalModifications;
    }

    public boolean isIgnoreDotFilesInBaseDir() {
        return this.ignoreDotFilesInBaseDir;
    }

    public void setIgnoreDotFilesInBaseDir(boolean ignoreDotFilesInBaseDir) {
        this.ignoreDotFilesInBaseDir = ignoreDotFilesInBaseDir;
    }

    public ChangeLogScmResult fetchChangeLog(ScmRepository repository, ScmProvider provider) throws ScmException {
        try {
            ChangeLogScmResult result = null;
            ScmRevision endRev = null;
            ScmRevision startRev = null;
            ScmFileSet fileSet = this.createFileSet();
            InfoScmResult isr = provider.info(repository.getProviderRepository(), fileSet, null);
            if (isr != null) {
                for (InfoItem ii : isr.getInfoItems()) {
                    if (!StringUtils.isNotEmpty((String)ii.getRevision())) continue;
                    endRev = new ScmRevision(ii.getRevision().replaceAll("\\+$", ""));
                }
            }
            int currentRange = this.queryRangeInDays;
            if (repository.getProvider().equals("git")) {
                startRev = new ScmRevision("HEAD^");
            } else if (repository.getProvider().equals("svn")) {
                startRev = endRev;
                endRev = new ScmRevision("1");
            } else if (repository.getProvider().equals("hg") && endRev.getName().contains("abort: there is no Mercurial repository here")) {
                return result;
            }
            for (int i = 0; i <= 5; ++i) {
                ChangeLogScmRequest scmRequest = new ChangeLogScmRequest(repository, fileSet);
                scmRequest.setStartRevision((ScmVersion)startRev);
                scmRequest.setEndRevision((ScmVersion)endRev);
                scmRequest.setDatePattern(this.dateFormat);
                scmRequest.setNumDays(currentRange);
                scmRequest.setDateRange(null, null);
                scmRequest.setLimit(Integer.valueOf(1));
                result = provider.changeLog(scmRequest);
                if (!this.isEmpty(result)) {
                    return result;
                }
                currentRange += this.queryRangeInDays;
            }
            return result;
        }
        catch (org.apache.maven.scm.ScmException e) {
            throw new ScmException("Cannot fetch change log from repository.", e);
        }
    }

    private boolean isEmpty(ChangeLogScmResult result) {
        ChangeLogSet changeLogSet;
        if (result != null && (changeLogSet = result.getChangeLog()) != null) {
            return this.isEmpty(changeLogSet);
        }
        return false;
    }

    private boolean isEmpty(ChangeLogSet changeLogSet) {
        List changeLogSets = changeLogSet.getChangeSets();
        if (changeLogSets != null) {
            return changeLogSets.isEmpty();
        }
        return false;
    }

    protected ScmFileSet createFileSet() {
        return new ScmFileSet(this.rootDirectory);
    }

    public boolean isFailIndicated() {
        return this.isFailOnLocalModifications() && !this.isIgnoreDotFilesInBaseDir();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("SCM access info: rootDirectory=").append(this.rootDirectory);
        ScmAccessInfo.appendIfExists(buffer, "dateFormat", this.dateFormat);
        ScmAccessInfo.appendIfExists(buffer, "queryRangeInDays", String.valueOf(this.queryRangeInDays));
        ScmAccessInfo.appendIfExists(buffer, "failOnLocalModifications", String.valueOf(this.failOnLocalModifications));
        ScmAccessInfo.appendIfExists(buffer, "ignoreDotFilesInBaseDir", String.valueOf(this.ignoreDotFilesInBaseDir));
        return buffer.toString();
    }

    private static void appendIfExists(StringBuilder buffer, String label, String value) {
        if (StringUtils.isNotBlank((String)value)) {
            buffer.append(", ").append(label).append('=').append(value);
        }
    }
}

