/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.rcm.maven.plugin.buildmetadata.util;

import java.io.File;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

public final class SettingsDecrypter {
    private final SecDispatcher securityDispatcher;
    private final String settingsSecurityLocation;

    public SettingsDecrypter(SecDispatcher securityDispatcher, String settingsSecurityLocation) {
        this.securityDispatcher = securityDispatcher;
        this.settingsSecurityLocation = SettingsDecrypter.init(settingsSecurityLocation);
    }

    private static String init(String settingsSecurityLocation) {
        File file = new File(settingsSecurityLocation);
        if (!file.canRead()) {
            return null;
        }
        System.setProperty("settings.security", settingsSecurityLocation);
        return settingsSecurityLocation;
    }

    public String decrypt(String encrypted) throws SecDispatcherException {
        if (this.settingsSecurityLocation != null) {
            return this.securityDispatcher.decrypt(encrypted);
        }
        return encrypted;
    }
}

