/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.generate;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class PropertyManager {
    public static final String JSP_VERSION_PROPERTY = "jsp.version";
    public static final String TAGLIB_SHORT_NAME = "taglib.shortname";
    public static final String TAGLIB_DISPLAY_NAME = "taglib.displayname";
    public static final String TAGLIB_URI = "taglib.uri";
    public static final String TAGLIB_DESCRIPTION = "taglib.description";
    public static final String TAGLIB_FILE_NAME = "taglib.file.name";
    public static final String TAGLIB_INCLUDE = "taglib.include";
    public static final String TAGLIB_EXCLUDED_RENDERER_TYPES = "taglib.excludedRendererTypes";
    public static final String COPYRIGHT = "copyright";
    public static final String RENDERKIT_ID = "renderkit.id";
    public static final String TARGET_PACKAGE = "target.package";
    public static final String BASE_OUTPUT_DIR = "base.output.dir";
    private static final String[] VALID_PROPS = new String[]{"jsp.version", "taglib.uri", "taglib.description", "taglib.shortname", "copyright", "renderkit.id", "target.package", "taglib.file.name", "taglib.include", "base.output.dir", "taglib.excludedRendererTypes"};
    private static final String[] NULLABLE_PROPS = new String[]{"copyright", "taglib.description", "taglib.include", "taglib.excludedRendererTypes"};
    private Properties props;
    private Map<String, Boolean> excludedRenderers;

    private PropertyManager(Properties props) {
        this.props = props;
    }

    public static PropertyManager newInstance(String propertyFile) {
        Properties props = new Properties();
        try {
            props.load(new BufferedInputStream(new FileInputStream(new File(propertyFile))));
        }
        catch (Exception e) {
            throw new IllegalStateException(e.toString());
        }
        return new PropertyManager(props);
    }

    public String getProperty(String propertyName) {
        if (Arrays.binarySearch(VALID_PROPS, propertyName) < 0) {
            throw new IllegalArgumentException("Unknown Property '" + propertyName + '\'');
        }
        String propValue = this.props.getProperty(propertyName);
        if (propValue == null) {
            if (Arrays.binarySearch(NULLABLE_PROPS, propertyName) >= 0) {
                propValue = "";
            } else {
                throw new IllegalStateException("Property '" + propertyName + "' must be defined.");
            }
        }
        return propValue.trim();
    }

    public boolean isExcludeRenderer(String rendererType) {
        boolean result = false;
        if (null == this.excludedRenderers) {
            this.initializeExcludedRenderers();
        }
        result = this.excludedRenderers.containsKey(rendererType);
        return result;
    }

    private void initializeExcludedRenderers() {
        String excludedRenderersProp = this.getProperty(TAGLIB_EXCLUDED_RENDERER_TYPES);
        if (null == excludedRenderersProp) {
            this.excludedRenderers = Collections.emptyMap();
        } else {
            String[] toAdd;
            this.excludedRenderers = new HashMap<String, Boolean>();
            for (String cur : toAdd = excludedRenderersProp.split(",")) {
                this.excludedRenderers.put(cur, Boolean.TRUE);
            }
        }
    }

    public String toString() {
        ByteArrayOutputStream propsOutput = new ByteArrayOutputStream();
        this.props.list(new PrintStream(propsOutput));
        return propsOutput.toString();
    }

    static {
        Arrays.sort(VALID_PROPS);
        Arrays.sort(NULLABLE_PROPS);
    }
}

