/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag;

import com.sun.faces.el.ELUtils;
import com.sun.faces.facelets.el.ContextualCompositeMethodExpression;
import com.sun.faces.facelets.el.ContextualCompositeValueExpression;
import com.sun.faces.facelets.el.ELText;
import com.sun.faces.facelets.el.TagMethodExpression;
import com.sun.faces.facelets.el.TagValueExpression;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;
import javax.el.MethodInfo;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.view.Location;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;

public final class TagAttributeImpl
extends TagAttribute {
    private final boolean literal;
    private final String localName;
    private final Location location;
    private final String namespace;
    private final String qName;
    private final String value;
    private String string;

    public TagAttributeImpl(Location location, String ns, String localName, String qName, String value) {
        this.location = location;
        this.namespace = ns;
        this.localName = null == localName || 0 == localName.length() ? qName : localName;
        this.qName = qName;
        this.value = value;
        try {
            this.literal = ELText.isLiteral(this.value);
        }
        catch (ELException e) {
            throw new TagAttributeException((TagAttribute)this, (Throwable)e);
        }
    }

    @Override
    public boolean getBoolean(FaceletContext ctx) {
        if (this.literal) {
            return Boolean.valueOf(this.value);
        }
        return (Boolean)this.getObject(ctx, Boolean.class);
    }

    @Override
    public int getInt(FaceletContext ctx) {
        if (this.literal) {
            return Integer.parseInt(this.value);
        }
        return ((Number)this.getObject(ctx, Integer.class)).intValue();
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public MethodExpression getMethodExpression(FaceletContext ctx, Class type, Class[] paramTypes) {
        MethodExpression result;
        try {
            ExpressionFactory f = ctx.getExpressionFactory();
            if (ELUtils.isCompositeComponentLookupWithArgs(this.value)) {
                String message = MessageUtils.getExceptionMessageString("com.sun.faces.ARGUMENTS_NOT_LEGAL_WITH_CC_ATTRS_EXPR", new Object[0]);
                throw new TagAttributeException((TagAttribute)this, message);
            }
            if (ELUtils.isCompositeComponentMethodExprLookup(this.value)) {
                result = new AttributeLookupMethodExpression(this.getValueExpression(ctx, MethodExpression.class));
            } else if (ELUtils.isCompositeComponentExpr(this.value)) {
                TagMethodExpression delegate = new TagMethodExpression(this, f.createMethodExpression((ELContext)ctx, this.value, type, paramTypes));
                result = new ContextualCompositeMethodExpression(this.getLocation(), (MethodExpression)delegate);
            } else {
                result = new TagMethodExpression(this, f.createMethodExpression((ELContext)ctx, this.value, type, paramTypes));
            }
        }
        catch (Exception e) {
            if (e instanceof TagAttributeException) {
                throw (TagAttributeException)e;
            }
            throw new TagAttributeException((TagAttribute)this, (Throwable)e);
        }
        return result;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public Object getObject(FaceletContext ctx) {
        return this.getObject(ctx, Object.class);
    }

    @Override
    public String getQName() {
        return this.qName;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String getValue(FaceletContext ctx) {
        if (this.literal) {
            return this.value;
        }
        return (String)this.getObject(ctx, String.class);
    }

    @Override
    public Object getObject(FaceletContext ctx, Class type) {
        if (this.literal) {
            if (String.class.equals((Object)type)) {
                return this.value;
            }
            try {
                return ctx.getExpressionFactory().coerceToType((Object)this.value, type);
            }
            catch (Exception e) {
                throw new TagAttributeException((TagAttribute)this, (Throwable)e);
            }
        }
        ValueExpression ve = this.getValueExpression(ctx, type);
        try {
            return ve.getValue((ELContext)ctx);
        }
        catch (Exception e) {
            throw new TagAttributeException((TagAttribute)this, (Throwable)e);
        }
    }

    @Override
    public ValueExpression getValueExpression(FaceletContext ctx, Class type) {
        return this.getValueExpression(ctx, this.value, type);
    }

    @Override
    public boolean isLiteral() {
        return this.literal;
    }

    public String toString() {
        if (this.string == null) {
            this.string = this.location + " " + this.qName + "=\"" + this.value + "\"";
        }
        return this.string;
    }

    public ValueExpression getValueExpression(FaceletContext ctx, String expr, Class type) {
        try {
            ExpressionFactory f = ctx.getExpressionFactory();
            ValueExpression delegate = f.createValueExpression((ELContext)ctx, expr, type);
            if (ELUtils.isCompositeComponentExpr(expr)) {
                if (ELUtils.isCompositeComponentLookupWithArgs(expr)) {
                    String message = MessageUtils.getExceptionMessageString("com.sun.faces.ARGUMENTS_NOT_LEGAL_WITH_CC_ATTRS_EXPR", new Object[0]);
                    throw new TagAttributeException((TagAttribute)this, message);
                }
                return new TagValueExpression(this, new ContextualCompositeValueExpression(this.getLocation(), delegate));
            }
            return new TagValueExpression(this, delegate);
        }
        catch (Exception e) {
            throw new TagAttributeException((TagAttribute)this, (Throwable)e);
        }
    }

    private static class AttributeLookupMethodExpression
    extends MethodExpression {
        private ValueExpression lookupExpression;

        public AttributeLookupMethodExpression(ValueExpression lookupExpression) {
            Util.notNull("lookupExpression", lookupExpression);
            this.lookupExpression = lookupExpression;
        }

        public AttributeLookupMethodExpression() {
        }

        public MethodInfo getMethodInfo(ELContext elContext) {
            Util.notNull("elContext", elContext);
            Object result = this.lookupExpression.getValue(elContext);
            if (result != null && result instanceof MethodExpression) {
                return ((MethodExpression)result).getMethodInfo(elContext);
            }
            return null;
        }

        public Object invoke(ELContext elContext, Object[] args) {
            Util.notNull("elContext", elContext);
            Object result = this.lookupExpression.getValue(elContext);
            if (result == null) {
                throw new FacesException("Unable to resolve composite component from using page using EL expression '" + this.lookupExpression.getExpressionString() + '\'');
            }
            if (!(result instanceof MethodExpression)) {
                throw new FacesException("Successfully resolved expression '" + this.lookupExpression.getExpressionString() + "', but the value is not a MethodExpression");
            }
            return ((MethodExpression)result).invoke(elContext, args);
        }

        public String getExpressionString() {
            return this.lookupExpression.getExpressionString();
        }

        public boolean equals(Object otherObj) {
            boolean result = false;
            if (otherObj instanceof AttributeLookupMethodExpression) {
                AttributeLookupMethodExpression other = (AttributeLookupMethodExpression)((Object)otherObj);
                result = this.lookupExpression.getExpressionString().equals(other.lookupExpression.getExpressionString());
            }
            return result;
        }

        public boolean isLiteralText() {
            return this.lookupExpression.isLiteralText();
        }

        public int hashCode() {
            return this.lookupExpression.hashCode();
        }
    }
}

