/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.mock;

import com.sun.faces.mock.MockApplication;
import com.sun.faces.mock.MockExternalContext;
import com.sun.faces.mock.MockFacesContext;
import com.sun.faces.mock.MockHttpServletRequest;
import com.sun.faces.mock.MockHttpServletResponse;
import com.sun.faces.mock.MockHttpSession;
import com.sun.faces.mock.MockLifecycle;
import com.sun.faces.mock.MockRenderKit;
import com.sun.faces.mock.MockServletConfig;
import com.sun.faces.mock.MockServletContext;
import com.sun.faces.mock.TestMockBean;
import javax.faces.FactoryFinder;
import javax.faces.application.ApplicationFactory;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class MockObjectsTestCase
extends TestCase {
    protected MockApplication application = null;
    protected MockServletConfig config = null;
    protected MockExternalContext externalContext = null;
    protected MockFacesContext facesContext = null;
    protected MockLifecycle lifecycle = null;
    protected MockHttpServletRequest request = null;
    protected MockHttpServletResponse response = null;
    protected MockServletContext servletContext = null;
    protected MockHttpSession session = null;

    public MockObjectsTestCase(String name) {
        super(name);
    }

    public void setUp() {
        this.servletContext = new MockServletContext();
        this.servletContext.addInitParameter("appParamName", "appParamValue");
        this.servletContext.setAttribute("appScopeName", "appScopeValue");
        this.servletContext.setAttribute("sameKey", "sameKeyAppValue");
        this.config = new MockServletConfig(this.servletContext);
        this.session = new MockHttpSession();
        this.session.setAttribute("sesScopeName", "sesScopeValue");
        this.session.setAttribute("sameKey", "sameKeySesValue");
        this.request = new MockHttpServletRequest(this.session);
        this.request.setAttribute("reqScopeName", "reqScopeValue");
        this.request.setAttribute("sameKey", "sameKeyReqValue");
        this.response = new MockHttpServletResponse();
        FactoryFinder.setFactory((String)"javax.faces.application.ApplicationFactory", (String)"javax.faces.mock.MockApplicationFactory");
        FactoryFinder.setFactory((String)"javax.faces.render.RenderKitFactory", (String)"javax.faces.mock.MockRenderKitFactory");
        this.externalContext = new MockExternalContext(this.servletContext, (ServletRequest)this.request, (ServletResponse)this.response);
        this.lifecycle = new MockLifecycle();
        this.facesContext = new MockFacesContext(this.externalContext, this.lifecycle);
        UIViewRoot root = new UIViewRoot();
        root.setViewId("/viewId");
        this.facesContext.setViewRoot(root);
        ApplicationFactory applicationFactory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        this.application = (MockApplication)applicationFactory.getApplication();
        this.facesContext.setApplication(this.application);
        RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        MockRenderKit renderKit = new MockRenderKit();
        try {
            renderKitFactory.addRenderKit("HTML_BASIC", (RenderKit)renderKit);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        this.request.setAttribute("test", new TestMockBean());
    }

    public static Test suite() {
        return new TestSuite(MockObjectsTestCase.class);
    }

    public void tearDown() {
        this.application = null;
        this.config = null;
        this.externalContext = null;
        this.facesContext = null;
        this.lifecycle = null;
        this.request = null;
        this.response = null;
        this.servletContext = null;
        this.session = null;
    }

    public void testMethodBindingGetTypePositive() throws Exception {
        Class[] argsString = new Class[]{String.class};
        Class[] argsNone = new Class[]{};
        this.checkMethodBindingGetType("test.getCommand", argsNone, String.class);
        this.checkMethodBindingGetType("test.setCommand", argsString, null);
        this.checkMethodBindingGetType("test.getInput", argsNone, String.class);
        this.checkMethodBindingGetType("test.setInput", argsString, null);
        this.checkMethodBindingGetType("test.getOutput", argsNone, String.class);
        this.checkMethodBindingGetType("test.setOutput", argsString, null);
        this.checkMethodBindingGetType("test.combine", argsNone, String.class);
    }

    public void testMethodBindingInvokePositive() throws Exception {
        TestMockBean bean = (TestMockBean)this.request.getAttribute("test");
        MethodBinding mb = null;
        Class[] argsString = new Class[]{String.class};
        Class[] argsNone = new Class[]{};
        MockObjectsTestCase.assertEquals((String)"::", (String)bean.combine());
        mb = this.application.createMethodBinding("test.setCommand", argsString);
        mb.invoke((FacesContext)this.facesContext, (Object[])new String[]{"command"});
        MockObjectsTestCase.assertEquals((String)"command", (String)bean.getCommand());
        mb = this.application.createMethodBinding("test.setInput", argsString);
        mb.invoke((FacesContext)this.facesContext, (Object[])new String[]{"input"});
        MockObjectsTestCase.assertEquals((String)"input", (String)bean.getInput());
        mb = this.application.createMethodBinding("test.setOutput", argsString);
        mb.invoke((FacesContext)this.facesContext, (Object[])new String[]{"output"});
        MockObjectsTestCase.assertEquals((String)"output", (String)bean.getOutput());
        mb = this.application.createMethodBinding("test.combine", null);
        MockObjectsTestCase.assertEquals((String)"command:input:output", (String)bean.combine());
        MockObjectsTestCase.assertEquals((Object)"command:input:output", (Object)mb.invoke((FacesContext)this.facesContext, null));
    }

    public void testValueBindingGetValuePositive() throws Exception {
        this.checkValueBindingGetValue("appScopeName", "appScopeValue");
        this.checkValueBindingGetValue("sesScopeName", "sesScopeValue");
        this.checkValueBindingGetValue("reqScopeName", "reqScopeValue");
        this.checkValueBindingGetValue("sameKey", "sameKeyReqValue");
        this.checkValueBindingGetValue("applicationScope.appScopeName", "appScopeValue");
        this.checkValueBindingGetValue("applicationScope.sameKey", "sameKeyAppValue");
        this.checkValueBindingGetValue("sessionScope.sesScopeName", "sesScopeValue");
        this.checkValueBindingGetValue("sessionScope.sameKey", "sameKeySesValue");
        this.checkValueBindingGetValue("requestScope.reqScopeName", "reqScopeValue");
        this.checkValueBindingGetValue("requestScope.sameKey", "sameKeyReqValue");
    }

    public void testValueBindingPutValuePositive() throws Exception {
        ValueBinding vb = null;
        MockObjectsTestCase.assertNull((Object)this.request.getAttribute("newSimpleName"));
        MockObjectsTestCase.assertNull((Object)this.session.getAttribute("newSimpleName"));
        MockObjectsTestCase.assertNull((Object)this.servletContext.getAttribute("newSimpleName"));
        vb = this.application.createValueBinding("newSimpleName");
        vb.setValue((FacesContext)this.facesContext, (Object)"newSimpleValue");
        MockObjectsTestCase.assertEquals((Object)"newSimpleValue", (Object)this.request.getAttribute("newSimpleName"));
        MockObjectsTestCase.assertNull((Object)this.session.getAttribute("newSimpleName"));
        MockObjectsTestCase.assertNull((Object)this.servletContext.getAttribute("newSimpleName"));
        MockObjectsTestCase.assertNull((Object)this.request.getAttribute("newReqName"));
        MockObjectsTestCase.assertNull((Object)this.session.getAttribute("newReqName"));
        MockObjectsTestCase.assertNull((Object)this.servletContext.getAttribute("newReqName"));
        vb = this.application.createValueBinding("requestScope.newReqName");
        vb.setValue((FacesContext)this.facesContext, (Object)"newReqValue");
        MockObjectsTestCase.assertEquals((Object)"newReqValue", (Object)this.request.getAttribute("newReqName"));
        MockObjectsTestCase.assertNull((Object)this.session.getAttribute("newReqName"));
        MockObjectsTestCase.assertNull((Object)this.servletContext.getAttribute("newReqName"));
        MockObjectsTestCase.assertNull((Object)this.request.getAttribute("newSesName"));
        MockObjectsTestCase.assertNull((Object)this.session.getAttribute("newSesName"));
        MockObjectsTestCase.assertNull((Object)this.servletContext.getAttribute("newSesName"));
        vb = this.application.createValueBinding("sessionScope.newSesName");
        vb.setValue((FacesContext)this.facesContext, (Object)"newSesValue");
        MockObjectsTestCase.assertNull((Object)this.request.getAttribute("newSesName"));
        MockObjectsTestCase.assertEquals((Object)"newSesValue", (Object)this.session.getAttribute("newSesName"));
        MockObjectsTestCase.assertNull((Object)this.servletContext.getAttribute("newSesName"));
        MockObjectsTestCase.assertNull((Object)this.request.getAttribute("newAppName"));
        MockObjectsTestCase.assertNull((Object)this.session.getAttribute("newAppName"));
        MockObjectsTestCase.assertNull((Object)this.servletContext.getAttribute("newAppName"));
        vb = this.application.createValueBinding("applicationScope.newAppName");
        vb.setValue((FacesContext)this.facesContext, (Object)"newAppValue");
        MockObjectsTestCase.assertNull((Object)this.request.getAttribute("newAppName"));
        MockObjectsTestCase.assertNull((Object)this.session.getAttribute("newAppName"));
        MockObjectsTestCase.assertEquals((Object)"newAppValue", (Object)this.servletContext.getAttribute("newAppName"));
        MockObjectsTestCase.assertEquals((Object)"newSimpleValue", (Object)this.request.getAttribute("newSimpleName"));
        MockObjectsTestCase.assertNull((Object)this.session.getAttribute("newSimpleName"));
        MockObjectsTestCase.assertNull((Object)this.servletContext.getAttribute("newSimpleName"));
        vb = this.application.createValueBinding("newSimpleName");
        vb.setValue((FacesContext)this.facesContext, (Object)"newerSimpleValue");
        MockObjectsTestCase.assertEquals((Object)"newerSimpleValue", (Object)this.request.getAttribute("newSimpleName"));
        MockObjectsTestCase.assertNull((Object)this.session.getAttribute("newSimpleName"));
        MockObjectsTestCase.assertNull((Object)this.servletContext.getAttribute("newSimpleName"));
        MockObjectsTestCase.assertEquals((Object)"sameKeyAppValue", (Object)this.servletContext.getAttribute("sameKey"));
        MockObjectsTestCase.assertEquals((Object)"sameKeySesValue", (Object)this.session.getAttribute("sameKey"));
        MockObjectsTestCase.assertEquals((Object)"sameKeyReqValue", (Object)this.request.getAttribute("sameKey"));
        vb = this.application.createValueBinding("sameKey");
        vb.setValue((FacesContext)this.facesContext, (Object)"sameKeyNewValue");
        MockObjectsTestCase.assertEquals((Object)"sameKeyAppValue", (Object)this.servletContext.getAttribute("sameKey"));
        MockObjectsTestCase.assertEquals((Object)"sameKeySesValue", (Object)this.session.getAttribute("sameKey"));
        MockObjectsTestCase.assertEquals((Object)"sameKeyNewValue", (Object)this.request.getAttribute("sameKey"));
    }

    private void checkMethodBindingGetType(String ref, Class[] params, Class expected) throws Exception {
        MethodBinding mb = this.application.createMethodBinding(ref, params);
        MockObjectsTestCase.assertNotNull((String)("MethodBinding[" + ref + "] exists"), (Object)mb);
        MockObjectsTestCase.assertEquals((String)("MethodBinding[" + ref + "] type"), (Object)expected, (Object)mb.getType((FacesContext)this.facesContext));
    }

    private void checkValueBindingGetValue(String ref, Object expected) {
        ValueBinding vb = this.application.createValueBinding(ref);
        MockObjectsTestCase.assertNotNull((String)("ValueBinding[" + ref + "] exists"), (Object)vb);
        MockObjectsTestCase.assertEquals((String)("ValueBinding[" + ref + "] value"), (Object)expected, (Object)vb.getValue((FacesContext)this.facesContext));
    }
}

