/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaee.blueprints.components.ui.renderkit;

import com.sun.javaee.blueprints.components.ui.components.ProgressBarComponent;
import com.sun.javaee.blueprints.components.ui.renderkit.BaseRenderer;
import com.sun.javaee.blueprints.components.ui.util.Util;
import java.io.IOException;
import javax.faces.FactoryFinder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import javax.servlet.http.HttpServletResponse;

public class ProgressBarRenderer
extends BaseRenderer {
    private boolean logging = true;
    private Renderer commandButtonRenderer = null;

    public void decode(FacesContext context, UIComponent component) {
        String clientId = component.getClientId(context);
        String paramValue = (String)context.getExternalContext().getRequestParameterMap().get(clientId);
        if (null == paramValue) {
            return;
        }
        if (-1 != paramValue.indexOf("ajax")) {
            ProgressBarComponent comp = (ProgressBarComponent)component;
            Object result = comp.getValue();
            HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
            response.setContentType("text/xml");
            response.setHeader("Cache-Control", "no-cache");
            try {
                ResponseWriter writer = this.setupResponseWriter(context);
                writer.startElement("message", (UIComponent)comp);
                writer.startElement("percentage", (UIComponent)comp);
                writer.writeText(result, null);
                writer.endElement("percentage");
                writer.startElement("clientId", (UIComponent)comp);
                writer.writeText((Object)component.getClientId(context), null);
                writer.endElement("clientId");
                writer.endElement("message");
            }
            catch (IOException e) {}
        } else {
            this.getButtonRenderer(context).decode(context, component);
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = component.getClientId(context);
        Util.renderMainScriptOnce(context, writer, component);
        writer.startElement("script", component);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        String idScript = "g_progressBars[g_progressBars.length] = \"" + clientId + "\";";
        writer.writeText((Object)idScript, null);
        writer.endElement("script");
        writer.startElement("div", component);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.endElement("div");
        writer.startElement("input", component);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("type", (Object)"hidden", "type");
        writer.writeAttribute("name", (Object)clientId, "clientId");
        writer.writeAttribute("value", (Object)"value", "value");
        writer.endElement("input");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (this.logging) {
            this.log("encodeChildren(" + component.getId() + ")");
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (this.logging) {
            this.log("encodeEnd(" + component.getId() + ")");
        }
    }

    private void log(String message) {
        if (this.logging) {
            System.out.println(message);
        }
    }

    public Renderer getButtonRenderer(FacesContext context) {
        if (null != this.commandButtonRenderer) {
            return this.commandButtonRenderer;
        }
        RenderKitFactory fact = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        RenderKit basic = fact.getRenderKit(context, "HTML_BASIC");
        this.commandButtonRenderer = basic.getRenderer("javax.faces.Command", "javax.faces.Button");
        return this.commandButtonRenderer;
    }
}

