/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.builder.db;

import cz.xtf.builder.builders.ApplicationBuilder;
import cz.xtf.builder.builders.DeploymentConfigBuilder;
import cz.xtf.builder.builders.EnvironmentConfiguration;
import cz.xtf.builder.builders.ServiceBuilder;
import cz.xtf.builder.builders.pod.ContainerBuilder;
import cz.xtf.builder.builders.pod.PersistentVolumeClaim;
import cz.xtf.builder.db.DefaultStatefulAuxiliary;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractDatabase
extends DefaultStatefulAuxiliary {
    protected final String username;
    protected final String password;
    protected final String dbName;
    protected final String symbolicName;
    protected String openShiftName;
    protected String jndiName = null;
    protected boolean isObjectStore = false;
    protected boolean configureEnvironment = true;
    protected boolean external = false;
    protected boolean nonXaDatasource = false;
    protected boolean withLivenessProbe;
    protected boolean withReadinessProbe;
    protected boolean withStartupProbe;

    public AbstractDatabase(String symbolicName, String dataDir) {
        this("testuser", "testpwd", "testdb", symbolicName, dataDir);
    }

    public AbstractDatabase(String symbolicName, String dataDir, boolean withLivenessProbe, boolean withReadinessProbe) {
        this("testuser", "testpwd", "testdb", symbolicName, dataDir);
        this.withLivenessProbe = withLivenessProbe;
        this.withReadinessProbe = withReadinessProbe;
    }

    public AbstractDatabase(String symbolicName, String dataDir, boolean withLivenessProbe, boolean withReadinessProbe, boolean configureEnvironment) {
        this(symbolicName, dataDir, withLivenessProbe, withReadinessProbe);
        this.configureEnvironment = configureEnvironment;
    }

    public AbstractDatabase(String symbolicName, String dataDir, boolean withLivenessProbe, boolean withReadinessProbe, boolean withStartupProbe, boolean configureEnvironment) {
        this(symbolicName, dataDir);
        this.withLivenessProbe = withLivenessProbe;
        this.withReadinessProbe = withReadinessProbe;
        this.withStartupProbe = withStartupProbe;
        this.configureEnvironment = configureEnvironment;
    }

    public AbstractDatabase(String symbolicName, String dataDir, PersistentVolumeClaim pvc) {
        this("testuser", "testpwd", "testdb", symbolicName, dataDir, pvc);
    }

    public AbstractDatabase(String symbolicName, String dataDir, PersistentVolumeClaim pvc, boolean withLivenessProbe, boolean withReadinessProbe) {
        this("testuser", "testpwd", "testdb", symbolicName, dataDir, pvc, withLivenessProbe, withReadinessProbe);
    }

    public AbstractDatabase(String username, String password, String dbName, String symbolicName, String dataDir, PersistentVolumeClaim pvc, boolean withLivenessProbe, boolean withReadinessProbe) {
        this(username, password, dbName, symbolicName, dataDir, pvc);
        this.withLivenessProbe = withLivenessProbe;
        this.withReadinessProbe = withReadinessProbe;
    }

    public AbstractDatabase(String symbolicName, String dataDir, PersistentVolumeClaim pvc, boolean withLivenessProbe, boolean withReadinessProbe, boolean withStartupProbe) {
        this("testuser", "testpwd", "testdb", symbolicName, dataDir, pvc);
        this.withLivenessProbe = withLivenessProbe;
        this.withReadinessProbe = withReadinessProbe;
        this.withStartupProbe = withStartupProbe;
    }

    public AbstractDatabase(String username, String password, String dbName, String symbolicName, String dataDir) {
        this(username, password, dbName, symbolicName, dataDir, null);
    }

    public AbstractDatabase(String username, String password, String dbName, String symbolicName, String dataDir, PersistentVolumeClaim pvc) {
        super(symbolicName, dataDir, pvc);
        this.username = username;
        this.password = password;
        this.dbName = dbName;
        this.symbolicName = symbolicName;
    }

    public AbstractDatabase(String username, String password, String dbName, String symbolicName, String dataDir, boolean withLivenessProbe, boolean withReadinessProbe) {
        this(username, password, dbName, symbolicName, dataDir);
        this.withLivenessProbe = withLivenessProbe;
        this.withReadinessProbe = withReadinessProbe;
    }

    public AbstractDatabase(String username, String password, String dbName, String symbolicName, String dataDir, boolean withLivenessProbe, boolean withReadinessProbe, boolean configureEnvironment) {
        this(username, password, dbName, symbolicName, dataDir, withLivenessProbe, withReadinessProbe);
        this.configureEnvironment = configureEnvironment;
    }

    public AbstractDatabase(String username, String password, String dbName, String symbolicName, String dataDir, boolean withLivenessProbe, boolean withReadinessProbe, boolean withStartupProbe, boolean configureEnvironment) {
        this(username, password, dbName, symbolicName, dataDir);
        this.configureEnvironment = configureEnvironment;
        this.withLivenessProbe = withLivenessProbe;
        this.withReadinessProbe = withReadinessProbe;
        this.withStartupProbe = withStartupProbe;
    }

    public abstract String getImageName();

    public abstract int getPort();

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    protected void configureContainer(ContainerBuilder containerBuilder) {
    }

    public Map<String, String> getImageVariables() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put(this.getSymbolicName() + "_USER", this.getUsername());
        vars.put(this.getSymbolicName() + "_USERNAME", this.getUsername());
        vars.put(this.getSymbolicName() + "_PASSWORD", this.getPassword());
        vars.put(this.getSymbolicName() + "_DATABASE", this.getDbName());
        return vars;
    }

    @Override
    public String getDeploymentConfigName() {
        if (this.openShiftName == null) {
            this.openShiftName = this.dbName.toLowerCase() + "-" + this.getSymbolicName().toLowerCase();
        }
        return this.openShiftName;
    }

    public String getEnvVarPrefix() {
        return this.dbName.toUpperCase() + "_" + this.getSymbolicName().toUpperCase();
    }

    private String getEnvVarName(String paramName) {
        return this.getEnvVarPrefix() + "_" + paramName.toUpperCase();
    }

    @Override
    public void configureApplicationDeployment(DeploymentConfigBuilder dcBuilder) {
        this.configureEnvironment(dcBuilder.podTemplate().container());
    }

    public void configureService(ApplicationBuilder appBuilder) {
        ServiceBuilder serviceBuilder = appBuilder.service(this.getDeploymentConfigName()).port(this.getPort()).addContainerSelector("deploymentconfig", this.getDeploymentConfigName());
        if (this.external) {
            serviceBuilder.withoutSelectors();
        }
    }

    @Override
    public DeploymentConfigBuilder configureDeployment(ApplicationBuilder appBuilder) {
        return this.configureDeployment(appBuilder, true);
    }

    @Override
    public DeploymentConfigBuilder configureDeployment(ApplicationBuilder appBuilder, boolean synchronous) {
        DeploymentConfigBuilder builder = appBuilder.deploymentConfig(this.getDeploymentConfigName());
        builder.podTemplate().container().fromImage(this.getImageName()).envVars(this.getImageVariables()).port(this.getPort());
        if (synchronous) {
            builder.onConfigurationChange();
            builder.synchronousDeployment();
        }
        this.configureContainer(builder.podTemplate().container());
        if (this.isStateful) {
            this.storagePartition.configureApplicationDeployment(appBuilder, builder);
        }
        if (this.persistentVolClaim != null) {
            builder.podTemplate().addPersistenVolumeClaim(this.persistentVolClaim.getName(), this.persistentVolClaim.getClaimName());
            builder.podTemplate().container().addVolumeMount(this.persistentVolClaim.getName(), this.dataDir, false);
        }
        this.configureService(appBuilder);
        return builder;
    }

    public void configureEnvironment(EnvironmentConfiguration envConfig) {
        String dbServiceMapping = envConfig.getConfigEntries().getOrDefault("DB_SERVICE_PREFIX_MAPPING", "");
        if (dbServiceMapping.length() != 0) {
            dbServiceMapping = dbServiceMapping.concat(",");
        }
        envConfig.configEntry("DB_SERVICE_PREFIX_MAPPING", dbServiceMapping.concat(this.getDeploymentConfigName() + "=" + this.getEnvVarPrefix())).configEntry(this.getEnvVarName("USERNAME"), this.getUsername()).configEntry(this.getEnvVarName("PASSWORD"), this.getPassword()).configEntry(this.getEnvVarName("DATABASE"), this.getDbName());
        if (this.isObjectStore) {
            envConfig.configEntry("TX_DATABASE_PREFIX_MAPPING", this.getEnvVarPrefix());
        }
        if (this.jndiName != null) {
            envConfig.configEntry(this.getEnvVarName("JNDI"), this.jndiName);
        }
        if (this.nonXaDatasource) {
            envConfig.configEntry(this.getEnvVarPrefix() + "_NONXA", "true");
        }
    }

    public AbstractDatabase jndiName(String jndiName) {
        this.jndiName = jndiName;
        return this;
    }

    public AbstractDatabase asObjectStore() {
        this.isObjectStore = true;
        return this;
    }

    public boolean isObjectStore() {
        return this.isObjectStore;
    }

    public AbstractDatabase external() {
        this.external = true;
        return this;
    }

    public AbstractDatabase withProbes() {
        this.withLivenessProbe = true;
        this.withReadinessProbe = true;
        this.withStartupProbe = true;
        return this;
    }

    public AbstractDatabase nonXaDatasource() {
        this.nonXaDatasource = true;
        return this;
    }

    public String toString() {
        return "AbstractDatabase{dbName='" + this.dbName + '\'' + '}';
    }
}

