/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.builder;

import cz.xtf.builder.builders.ApplicationBuilder;
import cz.xtf.core.openshift.OpenShift;
import cz.xtf.core.openshift.OpenShiftWaiters;
import cz.xtf.core.openshift.OpenShifts;
import cz.xtf.core.waiting.failfast.FailFastCheck;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscaler;
import io.fabric8.kubernetes.api.model.rbac.Role;
import io.fabric8.kubernetes.api.model.rbac.RoleBinding;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.Route;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenShiftApplication {
    private static final Logger log = LoggerFactory.getLogger(OpenShiftApplication.class);
    private final OpenShift openShift;
    private final String name;
    private List<Secret> secrets = new LinkedList<Secret>();
    private List<ServiceAccount> serviceAccounts = new LinkedList<ServiceAccount>();
    private List<ImageStream> imageStreams = new LinkedList<ImageStream>();
    private List<BuildConfig> buildConfigs = new LinkedList<BuildConfig>();
    private List<PersistentVolumeClaim> persistentVolumeClaims = new LinkedList<PersistentVolumeClaim>();
    private List<DeploymentConfig> deploymentConfigs = new LinkedList<DeploymentConfig>();
    private List<Service> services = new LinkedList<Service>();
    private List<Endpoints> endpoints = new LinkedList<Endpoints>();
    private List<Route> routes = new LinkedList<Route>();
    private List<ConfigMap> configMaps = new LinkedList<ConfigMap>();
    private List<HorizontalPodAutoscaler> autoScalers = new LinkedList<HorizontalPodAutoscaler>();
    private List<Role> roles = new LinkedList<Role>();
    private List<RoleBinding> roleBindings = new LinkedList<RoleBinding>();
    private FailFastCheck failFast = () -> false;

    @Deprecated
    public OpenShiftApplication(ApplicationBuilder appBuilder) {
        this(appBuilder, OpenShifts.master());
    }

    public OpenShiftApplication(ApplicationBuilder appBuilder, OpenShift openShift) {
        this.openShift = openShift;
        this.name = appBuilder.getName();
        this.secrets.addAll(appBuilder.buildSecrets());
        this.imageStreams.addAll(appBuilder.buildImageStreams());
        this.buildConfigs.addAll(appBuilder.buildBuildConfigs());
        this.persistentVolumeClaims.addAll(appBuilder.buildPVCs());
        this.deploymentConfigs.addAll(appBuilder.buildDeploymentConfigs());
        this.services.addAll(appBuilder.buildServices());
        this.routes.addAll(appBuilder.buildRoutes());
        this.configMaps.addAll(appBuilder.buildConfigMaps());
        this.roles.addAll(appBuilder.buildRoles());
        this.roleBindings.addAll(appBuilder.buildRoleBindings());
    }

    public void deploy() {
        this.createResources();
    }

    public OpenShiftApplication setFailFastCheck(FailFastCheck failFast) {
        this.failFast = failFast;
        return this;
    }

    private void createResources() {
        log.debug("Deploying application {}", (Object)this.name);
        this.secrets = this.secrets.stream().map(arg_0 -> ((OpenShift)this.openShift).createSecret(arg_0)).collect(Collectors.toList());
        this.serviceAccounts = this.serviceAccounts.stream().map(arg_0 -> ((OpenShift)this.openShift).createServiceAccount(arg_0)).collect(Collectors.toList());
        this.imageStreams = this.imageStreams.stream().map(arg_0 -> ((OpenShift)this.openShift).createImageStream(arg_0)).collect(Collectors.toList());
        this.buildConfigs = this.buildConfigs.stream().map(arg_0 -> ((OpenShift)this.openShift).createBuildConfig(arg_0)).collect(Collectors.toList());
        this.persistentVolumeClaims = this.persistentVolumeClaims.stream().map(arg_0 -> ((OpenShift)this.openShift).createPersistentVolumeClaim(arg_0)).collect(Collectors.toList());
        this.services = this.services.stream().map(arg_0 -> ((OpenShift)this.openShift).createService(arg_0)).collect(Collectors.toList());
        List syncDeployments = this.deploymentConfigs.stream().filter(x -> x.getMetadata().getLabels().containsKey("synchronousId")).sorted((dc1, dc2) -> {
            int labelDc1 = Integer.parseInt((String)dc1.getMetadata().getLabels().get("synchronousId"));
            int labelDc2 = Integer.parseInt((String)dc2.getMetadata().getLabels().get("synchronousId"));
            return labelDc1 - labelDc2;
        }).map(x -> {
            String syncId = (String)x.getMetadata().getLabels().get("synchronousId");
            DeploymentConfig dc = this.openShift.createDeploymentConfig(x);
            if (dc.getSpec().getReplicas() > 0) {
                try {
                    log.info("Waiting for a startup of pod with deploymentconfig '{}' ({} {})", new Object[]{dc.getMetadata().getName(), "synchronousId", syncId});
                    OpenShiftWaiters.get((OpenShift)this.openShift, (FailFastCheck)this.failFast).areExactlyNPodsReady(dc.getSpec().getReplicas().intValue(), dc.getMetadata().getName()).waitFor();
                }
                catch (Exception e) {
                    throw new IllegalStateException("Timeout while waiting for deployment of " + dc.getMetadata().getName(), e);
                }
            }
            return dc;
        }).collect(Collectors.toList());
        this.deploymentConfigs = this.deploymentConfigs.stream().filter(x -> !x.getMetadata().getLabels().containsKey("synchronousId")).map(arg_0 -> ((OpenShift)this.openShift).createDeploymentConfig(arg_0)).collect(Collectors.toList());
        this.deploymentConfigs.addAll(syncDeployments);
        this.endpoints = this.endpoints.stream().map(arg_0 -> ((OpenShift)this.openShift).createEndpoint(arg_0)).collect(Collectors.toList());
        this.routes = this.routes.stream().map(arg_0 -> ((OpenShift)this.openShift).createRoute(arg_0)).collect(Collectors.toList());
        this.configMaps = this.configMaps.stream().map(arg_0 -> ((OpenShift)this.openShift).createConfigMap(arg_0)).collect(Collectors.toList());
        this.autoScalers = this.autoScalers.stream().map(arg_0 -> ((OpenShift)this.openShift).createHorizontalPodAutoscaler(arg_0)).collect(Collectors.toList());
        this.roles = this.roles.stream().map(r -> (Role)this.openShift.rbac().roles().create(r)).collect(Collectors.toList());
        this.roleBindings = this.roleBindings.stream().map(arg_0 -> ((OpenShift)this.openShift).createRoleBinding(arg_0)).collect(Collectors.toList());
    }
}

