/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.core.event;

import cz.xtf.core.event.EventList;
import cz.xtf.core.event.helpers.EventHelper;
import io.fabric8.kubernetes.api.model.Event;
import java.time.ZonedDateTime;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EventListFilter {
    private Stream<Event> stream;

    public EventListFilter(EventList events) {
        this.stream = events.stream();
    }

    public EventListFilter ofEventTypes(String ... types) {
        this.stream = this.stream.filter(event -> this.isStrInArrayCaseInsensitive(event.getType(), types));
        return this;
    }

    public EventListFilter ofObjKinds(String ... kinds) {
        this.stream = this.stream.filter(event -> this.isStrInArrayCaseInsensitive(event.getInvolvedObject().getKind(), kinds));
        return this;
    }

    public boolean atLeastOneRegexMessages(String ... messagesRegex) {
        return this.stream.anyMatch(event -> {
            for (String regex : messagesRegex) {
                if (!event.getMessage().matches(regex)) continue;
                return true;
            }
            return false;
        });
    }

    public EventListFilter ofMessages(String ... messagesRegex) {
        this.stream = this.stream.filter(event -> {
            for (String regex : messagesRegex) {
                if (!event.getMessage().matches(regex)) continue;
                return true;
            }
            return false;
        });
        return this;
    }

    public EventList collect() {
        return new EventList(this.stream.collect(Collectors.toList()));
    }

    public EventListFilter ofObjNames(String ... regexNames) {
        this.stream = this.stream.filter(event -> {
            for (String regexName : regexNames) {
                if (!event.getInvolvedObject().getName().matches(regexName)) continue;
                return true;
            }
            return false;
        });
        return this;
    }

    public EventListFilter inOneOfTimeWindows(ZonedDateTime ... dates) {
        this.stream = this.stream.filter(event -> {
            if (event.getLastTimestamp() != null) {
                ZonedDateTime eventDate = EventHelper.timestampToZonedDateTime(event.getLastTimestamp());
                for (int i = 0; i < dates.length - 1; i += 2) {
                    if (!eventDate.isAfter(dates[i]) || eventDate.compareTo(dates[i + 1]) != 0 && !eventDate.isBefore(dates[i + 1])) continue;
                    return true;
                }
            }
            return false;
        });
        return this;
    }

    public EventListFilter after(ZonedDateTime date) {
        this.stream = this.stream.filter(e -> e.getLastTimestamp() != null && EventHelper.timestampToZonedDateTime(e.getLastTimestamp()).isAfter(date));
        return this;
    }

    public Stream<Event> getStream() {
        return this.stream;
    }

    public EventListFilter ofReasons(String ... reasons) {
        this.stream = this.stream.filter(event -> this.isStrInArrayCaseInsensitive(event.getReason(), reasons));
        return this;
    }

    public long count() {
        return this.stream.count();
    }

    private boolean isStrInArrayCaseInsensitive(String str, String ... array) {
        String field = str.toLowerCase();
        for (String item : array) {
            if (!field.equals(item.toLowerCase())) continue;
            return true;
        }
        return false;
    }
}

