/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.core.openshift;

import cz.xtf.core.config.OpenShiftConfig;
import cz.xtf.core.http.Https;
import cz.xtf.core.openshift.ClusterVersionInfoFactory;
import cz.xtf.core.openshift.OpenShift;
import cz.xtf.core.openshift.OpenShiftBinary;
import cz.xtf.core.openshift.OpenShiftBinaryManagerFactory;
import io.fabric8.kubernetes.client.Config;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenShifts {
    private static final Logger log = LoggerFactory.getLogger(OpenShifts.class);
    private static final String OCP3_CLIENTS_URL = "https://mirror.openshift.com/pub/openshift-v3/clients";
    private static final String OCP4_CLIENTS_URL = "https://mirror.openshift.com/pub/openshift-v4";
    private static OpenShift adminUtil;
    private static OpenShift masterUtil;

    public static OpenShift admin() {
        if (adminUtil == null) {
            adminUtil = OpenShifts.admin(OpenShiftConfig.namespace());
        }
        return adminUtil;
    }

    public static OpenShift admin(String namespace) {
        if (StringUtils.isNotEmpty((CharSequence)OpenShiftConfig.adminToken())) {
            return OpenShift.get(OpenShiftConfig.url(), namespace, OpenShiftConfig.adminToken());
        }
        if (StringUtils.isNotEmpty((CharSequence)OpenShiftConfig.adminUsername())) {
            return OpenShift.get(OpenShiftConfig.url(), namespace, OpenShiftConfig.adminUsername(), OpenShiftConfig.adminPassword());
        }
        if (StringUtils.isNotEmpty((CharSequence)OpenShiftConfig.adminKubeconfig())) {
            return OpenShift.get(Paths.get(OpenShiftConfig.adminKubeconfig(), new String[0]), namespace);
        }
        return OpenShift.get(namespace);
    }

    public static OpenShift master() {
        if (masterUtil == null) {
            masterUtil = OpenShifts.master(OpenShiftConfig.namespace());
        }
        return masterUtil;
    }

    public static OpenShift master(String namespace) {
        if (StringUtils.isNotEmpty((CharSequence)OpenShiftConfig.masterToken())) {
            return OpenShift.get(OpenShiftConfig.url(), namespace, OpenShiftConfig.masterToken());
        }
        if (StringUtils.isNotEmpty((CharSequence)OpenShiftConfig.masterUsername())) {
            return OpenShift.get(OpenShiftConfig.url(), namespace, OpenShiftConfig.masterUsername(), OpenShiftConfig.masterPassword());
        }
        if (StringUtils.isNotEmpty((CharSequence)OpenShiftConfig.masterKubeconfig())) {
            return OpenShift.get(Paths.get(OpenShiftConfig.masterKubeconfig(), new String[0]), namespace);
        }
        return OpenShift.get(namespace);
    }

    public static String getBinaryPath() {
        return OpenShiftBinaryManagerFactory.INSTANCE.getOpenShiftBinaryManager().getBinaryPath();
    }

    public static OpenShiftBinary masterBinary() {
        return OpenShifts.masterBinary(OpenShiftConfig.namespace());
    }

    public static OpenShiftBinary masterBinary(String namespace) {
        return OpenShiftBinaryManagerFactory.INSTANCE.getOpenShiftBinaryManager().masterBinary(namespace);
    }

    public static OpenShiftBinary adminBinary() {
        return OpenShifts.adminBinary(OpenShiftConfig.namespace());
    }

    public static OpenShiftBinary adminBinary(String namespace) {
        return OpenShiftBinaryManagerFactory.INSTANCE.getOpenShiftBinaryManager().adminBinary(namespace);
    }

    private static String getHomeDir() {
        File f;
        String home = System.getenv("HOME");
        if (home != null && !home.isEmpty() && (f = new File(home)).exists() && f.isDirectory()) {
            return home;
        }
        return System.getProperty("user.home", ".");
    }

    @Deprecated
    public static void saveOcOnCache(String version, String ocUrl, File ocTarFile) throws IOException {
        if (OpenShiftConfig.isBinaryCacheEnabled()) {
            File cacheRootFile = new File(OpenShiftConfig.binaryCachePath());
            if (!cacheRootFile.exists() && !cacheRootFile.mkdirs()) {
                throw new IllegalStateException("Cannot mkdirs " + cacheRootFile);
            }
            Path cachePath = OpenShifts.getOcCachePath(version, ocUrl);
            Files.createDirectories(cachePath, new FileAttribute[0]);
            FileUtils.copyFile((File)ocTarFile, (File)new File(cachePath.toFile(), ocTarFile.getName()));
        }
    }

    @Deprecated
    public static File getOcFromCache(String version, String ocUrl, File ocTarFile) throws IOException {
        return new File(OpenShifts.getOcCachePath(version, ocUrl).toFile(), ocTarFile.getName());
    }

    @Deprecated
    private static Path getOcCachePath(String version, String ocUrl) {
        return Paths.get(OpenShiftConfig.binaryCachePath(), version, DigestUtils.md5Hex((String)ocUrl));
    }

    public static String getVersion() {
        return ClusterVersionInfoFactory.INSTANCE.getClusterVersionInfo().getOpenshiftVersion();
    }

    public static String getMasterToken() {
        return OpenShifts.getToken(OpenShiftConfig.masterToken(), OpenShiftConfig.masterUsername(), OpenShiftConfig.masterPassword(), OpenShiftConfig.masterKubeconfig());
    }

    public static String getAdminToken() {
        return OpenShifts.getToken(OpenShiftConfig.adminToken(), OpenShiftConfig.adminUsername(), OpenShiftConfig.adminPassword(), OpenShiftConfig.adminKubeconfig());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getToken(String token, String username, String password, String kubeconfig) {
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            return token;
        }
        if (StringUtils.isNotEmpty((CharSequence)username)) {
            HttpURLConnection connection = null;
            try {
                connection = OpenShifts.getVersion() != null && OpenShifts.getVersion().startsWith("3") ? Https.getHttpsConnection(new URL(OpenShiftConfig.url() + "/oauth/authorize?response_type=token&client_id=openshift-challenging-client")) : Https.getHttpsConnection(new URL("https://oauth-openshift.apps." + StringUtils.substringBetween((String)OpenShiftConfig.url(), (String)"api.", (String)":") + "/oauth/authorize?response_type=token&client_id=openshift-challenging-client"));
                String encoded = Base64.getEncoder().encodeToString((username + ":" + password).getBytes(StandardCharsets.UTF_8));
                connection.setRequestProperty("Authorization", "Basic " + encoded);
                connection.setInstanceFollowRedirects(false);
                connection.connect();
                Map<String, List<String>> headers = connection.getHeaderFields();
                connection.disconnect();
                List<String> location = headers.get("Location");
                if (location != null) {
                    Optional<String> acces_token = location.stream().filter(s -> s.contains("access_token")).findFirst();
                    String string = acces_token.map(s -> StringUtils.substringBetween((String)s, (String)"#access_token=", (String)"&")).orElse(null);
                    return string;
                }
            }
            catch (IOException ex) {
                log.error("Unable to retrieve token from Location header: {} ", (Object)ex.getMessage());
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
            return null;
        }
        if (StringUtils.isNotEmpty((CharSequence)kubeconfig)) {
            try {
                Config config = Config.fromKubeconfig(null, (String)new String(Files.readAllBytes(Paths.get(kubeconfig, new String[0])), StandardCharsets.UTF_8), (String)kubeconfig);
                return config.getOauthToken();
            }
            catch (IOException e) {
                log.error("Unable to retrieve token from kubeconfig: {} ", (Object)kubeconfig, (Object)e);
                return null;
            }
        }
        File defaultKubeConfig = Paths.get(OpenShifts.getHomeDir(), ".kube", "config").toFile();
        try {
            Config config = Config.fromKubeconfig(null, (String)new String(Files.readAllBytes(defaultKubeConfig.toPath()), StandardCharsets.UTF_8), (String)defaultKubeConfig.getAbsolutePath());
            return config.getOauthToken();
        }
        catch (IOException e) {
            log.error("Unable to retrieve token from default kubeconfig: {} ", (Object)defaultKubeConfig, (Object)e);
            return null;
        }
    }
}

