/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.core.helm;

import cz.xtf.core.config.OpenShiftConfig;
import cz.xtf.core.helm.HelmBinary;
import cz.xtf.core.helm.HelmBinaryManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HelmBinaryManager {
    private static final Logger log = LoggerFactory.getLogger(HelmBinaryManager.class);
    private final String helmBinaryPath;

    HelmBinaryManager(String helmBinaryPath) {
        this.helmBinaryPath = helmBinaryPath;
    }

    String getHelmBinaryPath() {
        return this.helmBinaryPath;
    }

    public HelmBinary adminBinary() {
        return HelmBinaryManager.getBinary(OpenShiftConfig.adminToken(), OpenShiftConfig.adminUsername(), OpenShiftConfig.namespace());
    }

    public HelmBinary masterBinary() {
        return HelmBinaryManager.getBinary(OpenShiftConfig.masterToken(), OpenShiftConfig.masterUsername(), OpenShiftConfig.namespace());
    }

    private static HelmBinary getBinary(String token, String username, String namespace) {
        String helmBinaryPath = HelmBinaryManagerFactory.INSTANCE.getHelmBinaryManager().getHelmBinaryPath();
        return new HelmBinary(helmBinaryPath, username, token, namespace);
    }
}

