/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.core.openshift;

import cz.xtf.core.config.OpenShiftConfig;
import cz.xtf.core.openshift.OpenShiftBinary;
import cz.xtf.core.openshift.OpenShifts;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OpenShiftBinaryManager {
    private static final Logger log = LoggerFactory.getLogger(OpenShiftBinaryManager.class);
    private final String openShiftBinaryPath;

    OpenShiftBinaryManager(String openShiftBinaryPath) {
        this.openShiftBinaryPath = openShiftBinaryPath;
    }

    String getBinaryPath() {
        return this.openShiftBinaryPath;
    }

    OpenShiftBinary masterBinary(String namespace) {
        Objects.requireNonNull(namespace);
        return this.getBinary(OpenShiftConfig.masterToken(), OpenShiftConfig.masterUsername(), OpenShiftConfig.masterPassword(), OpenShiftConfig.masterKubeconfig(), namespace);
    }

    OpenShiftBinary adminBinary(String namespace) {
        Objects.requireNonNull(namespace);
        return this.getBinary(OpenShiftConfig.adminToken(), OpenShiftConfig.adminUsername(), OpenShiftConfig.adminPassword(), OpenShiftConfig.adminKubeconfig(), namespace);
    }

    private OpenShiftBinary getBinary(String token, String username, String password, String kubeconfig, String namespace) {
        OpenShiftBinary openShiftBinary;
        String ocConfigPath = this.createUniqueOcConfigFolder().resolve("oc.config").toAbsolutePath().toString();
        if (StringUtils.isNotEmpty((CharSequence)token) || StringUtils.isNotEmpty((CharSequence)username)) {
            openShiftBinary = new OpenShiftBinary(OpenShifts.getBinaryPath(), ocConfigPath);
            if (StringUtils.isNotEmpty((CharSequence)token)) {
                openShiftBinary.login(OpenShiftConfig.url(), token);
            } else {
                openShiftBinary.login(OpenShiftConfig.url(), username, password);
            }
        } else {
            if (StringUtils.isNotEmpty((CharSequence)kubeconfig)) {
                try {
                    Files.copy(Paths.get(kubeconfig, new String[0]), Paths.get(ocConfigPath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                File defaultKubeConfig = Paths.get(OpenShiftBinaryManager.getHomeDir(), ".kube", "config").toFile();
                if (defaultKubeConfig.isFile()) {
                    try {
                        Files.copy(defaultKubeConfig.toPath(), Paths.get(ocConfigPath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    throw new RuntimeException(defaultKubeConfig.getAbsolutePath() + " does not exist and no other OpenShift master option specified");
                }
            }
            openShiftBinary = new OpenShiftBinary(OpenShifts.getBinaryPath(), ocConfigPath);
        }
        if (StringUtils.isNotEmpty((CharSequence)namespace)) {
            openShiftBinary.project(namespace);
        }
        return openShiftBinary;
    }

    private Path createUniqueOcConfigFolder() {
        try {
            return Files.createTempDirectory(this.getProjectOcConfigDir(), "config", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Temporary folder for oc config couldn't be created", e);
        }
    }

    private static String getHomeDir() {
        File f;
        String home = System.getenv("HOME");
        if (home != null && !home.isEmpty() && (f = new File(home)).exists() && f.isDirectory()) {
            return home;
        }
        return System.getProperty("user.home", ".");
    }

    private Path getProjectOcConfigDir() {
        return Paths.get("tmp/oc/", new String[0]);
    }
}

