/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.core.service.logs.streaming;

import cz.xtf.core.service.logs.streaming.ServiceLogColor;
import cz.xtf.core.service.logs.streaming.ServiceLogUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceLogColoredPrintStream
extends PrintStream {
    private static final Logger logger = LoggerFactory.getLogger(ServiceLogColoredPrintStream.class);
    private final ServiceLogColor color;
    private final String prefix;
    private boolean needHeader = true;

    private ServiceLogColoredPrintStream(OutputStream out, ServiceLogColor color, String prefix) {
        super(out, true);
        this.color = color;
        this.prefix = prefix;
    }

    protected List<byte[]> getTokens(byte[] buf, int off, int len) throws IOException {
        ArrayList<byte[]> tokens = new ArrayList<byte[]>();
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            for (int i = off; i < off + len; ++i) {
                if ((char)buf[i] == '\n') {
                    if (baos.size() > 0) {
                        tokens.add(baos.toByteArray());
                        baos.reset();
                    }
                    tokens.add(Arrays.copyOfRange(buf, i, i + 1));
                    continue;
                }
                baos.write(buf[i]);
            }
            if (baos.size() > 0) {
                tokens.add(baos.toByteArray());
            }
        }
        if (tokens.isEmpty()) {
            tokens.add(Arrays.copyOfRange(buf, off, len));
        }
        return tokens;
    }

    private boolean isNewLine(byte[] token) {
        return token != null && token.length == 1 && (char)token[0] == '\n';
    }

    private void printLineHeader() throws IOException {
        this.out.write(this.color.value.getBytes(StandardCharsets.UTF_8));
        this.out.write(ServiceLogColor.ANSI_POD_NAME_BG.value.getBytes(StandardCharsets.UTF_8));
        this.out.write(ServiceLogUtils.formatStreamedLogLine(this.prefix).getBytes(StandardCharsets.UTF_8));
        this.out.write(ServiceLogColor.ANSI_RESET_FG.value.getBytes(StandardCharsets.UTF_8));
        this.out.write(ServiceLogColor.ANSI_RESET_BG.value.getBytes(StandardCharsets.UTF_8));
        this.out.flush();
    }

    private void printToken(byte[] buf, int off, int len) throws IOException {
        this.out.write(ServiceLogColor.ANSI_POD_LOG_BG.value.getBytes(StandardCharsets.UTF_8));
        this.out.write(this.color.value.getBytes(StandardCharsets.UTF_8));
        this.out.write(buf, off, len);
        this.out.write(ServiceLogColor.ANSI_RESET_FG.value.getBytes(StandardCharsets.UTF_8));
        this.out.write(ServiceLogColor.ANSI_RESET_BG.value.getBytes(StandardCharsets.UTF_8));
        this.out.flush();
    }

    @Override
    public void write(int b) {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] buf, int off, int len) {
        try {
            OutputStream outputStream = this.out;
            synchronized (outputStream) {
                List<byte[]> tokens;
                if (this.out == null) {
                    throw new IOException("Stream is closed");
                }
                logger.trace("TOKEN_FROM_CONTAINER: {}", (Object)new String(Arrays.copyOfRange(buf, off, len)));
                if (this.needHeader) {
                    this.printLineHeader();
                    this.needHeader = false;
                }
                if (!(tokens = this.getTokens(buf, off, len)).isEmpty()) {
                    for (int i = 0; i < tokens.size(); ++i) {
                        if (this.isNewLine(tokens.get(i))) {
                            this.out.write(10);
                            if (i < tokens.size() - 1) {
                                this.printLineHeader();
                                continue;
                            }
                            this.needHeader = true;
                            continue;
                        }
                        this.printToken(tokens.get(i), 0, tokens.get(i).length);
                    }
                }
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.setError();
        }
    }

    public static class Builder {
        private OutputStream outputStream;
        private ServiceLogColor color;
        private String prefix;

        public Builder outputTo(OutputStream outputStream) {
            this.outputStream = outputStream;
            return this;
        }

        public Builder withColor(ServiceLogColor color) {
            this.color = color;
            return this;
        }

        public Builder withPrefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public ServiceLogColoredPrintStream build() {
            if (this.outputStream == null) {
                throw new IllegalStateException("OutputStream must be specified!");
            }
            if (this.color == null) {
                throw new IllegalStateException("Color must be specified!");
            }
            if (this.prefix == null) {
                throw new IllegalStateException("Prefix must be specified!");
            }
            return new ServiceLogColoredPrintStream(this.outputStream, this.color, this.prefix);
        }
    }
}

