/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.core.namespace;

import cz.xtf.core.config.OpenShiftConfig;
import cz.xtf.core.context.TestCaseContext;
import cz.xtf.core.openshift.OpenShift;
import cz.xtf.core.openshift.OpenShifts;
import cz.xtf.core.waiting.SimpleWaiter;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.engine.descriptor.MethodBasedTestDescriptor;
import org.junit.platform.engine.TestDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceManager {
    private static final Logger log = LoggerFactory.getLogger(NamespaceManager.class);
    private static final Map<String, String> testcaseToNamespaceMap = new HashMap<String, String>();

    private static Map<String, String> getTestCaseToNamespaceMap() {
        return testcaseToNamespaceMap;
    }

    private static String getNamespaceForTestCase(String testcase) {
        return NamespaceManager.getTestCaseToNamespaceMap().get(testcase);
    }

    public static boolean createIfDoesNotExistsProject() {
        return NamespaceManager.createIfDoesNotExistsProject(NamespaceManager.getNamespace());
    }

    public static boolean createIfDoesNotExistsProject(String namespace) {
        OpenShift openShift = OpenShifts.master(namespace);
        NamespaceManager.checkAndWaitIfNamespaceIsTerminating(namespace);
        if (openShift.getProject() == null) {
            log.info("Creating namespace: " + openShift.getNamespace());
            openShift.createProjectRequest();
            openShift.waiters().isProjectReady().waitFor();
            try {
                ((Resource)OpenShifts.admin(namespace).namespaces().withName(openShift.getProject().getMetadata().getName())).edit(new Visitor[]{new Visitor<NamespaceBuilder>(){

                    public void visit(NamespaceBuilder builder) {
                        builder.editMetadata().addToLabels("xtf.cz/managed", "true");
                    }
                }});
            }
            catch (KubernetesClientException e) {
                log.warn("Couldn't assign label 'xtf.cz/managed' to the new project '" + openShift.getNamespace() + "'. Possible cause are insufficient permissions.");
                log.debug(e.getMessage());
            }
            if (OpenShiftConfig.pullSecret() != null) {
                openShift.setupPullSecret(OpenShiftConfig.pullSecret());
            }
            log.info("Created namespace: " + openShift.getNamespace());
            return true;
        }
        return false;
    }

    private static void checkAndWaitIfNamespaceIsTerminating(String namespace) {
        Namespace n = (Namespace)((Resource)OpenShifts.admin(namespace).namespaces().withName(namespace)).get();
        if (n != null && n.getStatus().getPhase().equals("Terminating")) {
            NamespaceManager.waitForNamespaceToBeDeleted(namespace);
        }
    }

    public static boolean deleteProject(boolean waitForDeletion) {
        return NamespaceManager.deleteProject(NamespaceManager.getNamespace(), waitForDeletion);
    }

    public static boolean deleteProject(String namespace, boolean waitForDeletion) {
        boolean deleted = false;
        if (((Resource)OpenShifts.admin(namespace).namespaces().withName(namespace)).get() != null) {
            OpenShift openShift = OpenShifts.master(namespace);
            log.info("Start deleting namespace: " + openShift.getNamespace() + ", wait for deletion: " + waitForDeletion);
            deleted = openShift.deleteProject();
            if (!deleted && waitForDeletion) {
                NamespaceManager.waitForNamespaceToBeDeleted(namespace);
            }
        }
        return deleted;
    }

    public static boolean deleteProjectIfUsedNamespacePerTestCase(boolean waitForDeletion) {
        if (OpenShiftConfig.useNamespacePerTestCase()) {
            return NamespaceManager.deleteProject(waitForDeletion);
        }
        return false;
    }

    private static void waitForNamespaceToBeDeleted(String namespace) {
        BooleanSupplier bs = () -> ((Resource)OpenShifts.admin(namespace).namespaces().withName(namespace)).get() == null;
        new SimpleWaiter(bs, TimeUnit.MINUTES, 2L, "Waiting for " + namespace + " project deletion").waitFor();
    }

    private static String getNamespaceForTestClass(TestDescriptor testDescriptor) {
        if (OpenShiftConfig.useNamespacePerTestCase()) {
            if ((OpenShiftConfig.namespace() + "-" + ((TestDescriptor)testDescriptor.getParent().get()).getDisplayName().toLowerCase()).length() > OpenShiftConfig.getNamespaceLengthLimitForUniqueNamespacePerTest()) {
                return OpenShiftConfig.namespace() + "-" + StringUtils.truncate((String)DigestUtils.sha256Hex((String)((TestDescriptor)testDescriptor.getParent().get()).getDisplayName().toLowerCase()), (int)(OpenShiftConfig.getNamespaceLengthLimitForUniqueNamespacePerTest() - OpenShiftConfig.namespace().length()));
            }
            return OpenShiftConfig.namespace() + "-" + ((TestDescriptor)testDescriptor.getParent().get()).getDisplayName().toLowerCase();
        }
        return OpenShiftConfig.namespace();
    }

    public static void addTestCaseToNamespaceEntryIfAbsent(TestDescriptor testDescriptor) {
        NamespaceManager.getTestCaseToNamespaceMap().putIfAbsent(((MethodBasedTestDescriptor)testDescriptor).getTestClass().getName(), NamespaceManager.getNamespaceForTestClass(testDescriptor));
    }

    public static String getNamespace() {
        if (OpenShiftConfig.useNamespacePerTestCase()) {
            String namespace = NamespaceManager.getNamespaceForTestCase(TestCaseContext.getRunningTestCaseName());
            if (StringUtils.isEmpty((CharSequence)namespace)) {
                throw new RuntimeException("There is no namespace associated with current thread or test case. This can happen in case that OpenShift instance is created in static variable. In this case avoid using static. Or in thread which is not associated with any test case.");
            }
            return namespace;
        }
        return OpenShiftConfig.namespace();
    }
}

