/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.core.openshift;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class PodShellOutput {
    private final String output;
    private final String error;

    PodShellOutput(String output, String error) {
        this.output = output;
        this.error = error;
    }

    public List<String> getOutputAsList() {
        return this.getOutputAsList("\n");
    }

    public List<String> getOutputAsList(String delimiter) {
        return Arrays.asList(StringUtils.split((String)this.getOutput(), (String)delimiter));
    }

    public Map<String, String> getOutputAsMap(String keyValueDelimiter) {
        return this.getOutputAsMap(keyValueDelimiter, "\n");
    }

    public Map<String, String> getOutputAsMap(String keyValueDelimiter, String entryDelimiter) {
        HashMap<String, String> map = new HashMap<String, String>();
        this.getOutputAsList(entryDelimiter).forEach(entry -> {
            String[] parsedEntry = StringUtils.split((String)entry, (String)keyValueDelimiter, (int)2);
            map.put(parsedEntry[0], parsedEntry.length > 1 ? parsedEntry[1] : null);
        });
        return map;
    }

    public String getOutput() {
        return this.output;
    }

    public String getError() {
        return this.error;
    }
}

