/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.core.service.logs.streaming;

import cz.xtf.core.service.logs.streaming.ServiceLogsSettings;
import cz.xtf.core.service.logs.streaming.ServiceLogsStreaming;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationBasedServiceLogsConfigurations {
    private static final Logger log = LoggerFactory.getLogger(AnnotationBasedServiceLogsConfigurations.class);
    private static final Map<String, ServiceLogsSettings> CONFIGURATIONS = new HashMap<String, ServiceLogsSettings>();

    private ServiceLogsSettings loadConfiguration(Class<?> testClazz) {
        ServiceLogsStreaming annotation = testClazz.getAnnotation(ServiceLogsStreaming.class);
        if (annotation != null) {
            return new ServiceLogsSettings.Builder().withTarget(testClazz.getName()).withFilter(annotation.filter()).withOutputPath(annotation.output()).build();
        }
        return null;
    }

    public ServiceLogsSettings forClass(Class<?> testClazz) {
        ServiceLogsSettings serviceLogsSettings = CONFIGURATIONS.get(testClazz.getName());
        if (serviceLogsSettings == null && (serviceLogsSettings = this.loadConfiguration(testClazz)) != null) {
            CONFIGURATIONS.put(testClazz.getName(), serviceLogsSettings);
        }
        return serviceLogsSettings;
    }
}

