/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.junit5.extensions;

import cz.xtf.core.config.BuildManagerConfig;
import cz.xtf.core.config.XTFConfig;
import cz.xtf.core.image.Image;
import cz.xtf.core.openshift.OpenShifts;
import cz.xtf.junit5.annotations.SkipFor;
import cz.xtf.junit5.annotations.SkipFors;
import cz.xtf.junit5.model.DockerImageMetadata;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;

public class SkipForCondition
implements ExecutionCondition {
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        SkipFor skipFor = AnnotationSupport.findAnnotation((Optional)context.getElement(), SkipFor.class).orElse(null);
        SkipFors skipFors = AnnotationSupport.findAnnotation((Optional)context.getElement(), SkipFors.class).orElse(null);
        if (skipFor != null) {
            return SkipForCondition.resolve(skipFor);
        }
        if (skipFors != null) {
            for (SkipFor sf : skipFors.value()) {
                ConditionEvaluationResult cer = SkipForCondition.resolve(sf);
                if (!cer.isDisabled()) continue;
                return cer;
            }
            return ConditionEvaluationResult.enabled((String)"Feature is expected to be available.");
        }
        return ConditionEvaluationResult.enabled((String)"SkipFor(s) annotation isn't present on target.");
    }

    public static ConditionEvaluationResult resolve(SkipFor skipFor) {
        DockerImageMetadata metadata;
        Matcher matcher;
        if (SkipForCondition.detectMultipleSkipForCriteria(skipFor)) {
            throw new RuntimeException("Only one of 'name', 'imageMetadataLabelName', 'imageMetadataLabelArchitecture' and 'subId' can be presented in 'SkipFor' annotation.");
        }
        Image image = Image.resolve((String)skipFor.image());
        if (!skipFor.name().equals("")) {
            matcher = Pattern.compile(skipFor.name()).matcher(image.getRepo());
        } else if (!skipFor.imageMetadataLabelName().equals("")) {
            metadata = DockerImageMetadata.get(OpenShifts.master((String)BuildManagerConfig.namespace()), image);
            matcher = Pattern.compile(skipFor.imageMetadataLabelName()).matcher(metadata.labels().get("name"));
        } else if (!skipFor.imageMetadataLabelArchitecture().equals("")) {
            metadata = DockerImageMetadata.get(OpenShifts.master(), image);
            matcher = Pattern.compile(skipFor.imageMetadataLabelArchitecture()).matcher(metadata.labels().get("architecture"));
        } else {
            matcher = Pattern.compile(skipFor.subId()).matcher(XTFConfig.get((String)("xtf." + skipFor.image() + ".subid")));
        }
        if (matcher.matches()) {
            String reason = skipFor.reason().equals("") ? "" : " (" + skipFor.reason() + ")";
            return ConditionEvaluationResult.disabled((String)("Tested feature isn't expected to be available in '" + image.getRepo() + "' image." + reason));
        }
        return ConditionEvaluationResult.enabled((String)("Image '" + image.getRepo() + "' is expected to contain tested feature."));
    }

    private static boolean detectMultipleSkipForCriteria(SkipFor skipFor) {
        return Stream.of(skipFor.name(), skipFor.imageMetadataLabelName(), skipFor.subId(), skipFor.imageMetadataLabelArchitecture()).filter(c -> StringUtils.isNotBlank((CharSequence)c)).count() > 1L;
    }
}

