/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.junit5.listeners;

import cz.xtf.core.config.BuildManagerConfig;
import cz.xtf.core.config.OpenShiftConfig;
import cz.xtf.core.config.XTFConfig;
import cz.xtf.core.openshift.OpenShift;
import cz.xtf.core.openshift.OpenShifts;
import cz.xtf.core.waiting.SimpleWaiter;
import cz.xtf.junit5.config.JUnitConfig;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.stream.Stream;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.engine.descriptor.MethodBasedTestDescriptor;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.launcher.PostDiscoveryFilter;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectCreator
implements TestExecutionListener,
BeforeAllCallback,
AfterAllCallback,
PostDiscoveryFilter {
    private static final Logger log = LoggerFactory.getLogger(ProjectCreator.class);

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.createProject();
    }

    public void beforeAll(ExtensionContext context) {
        if (OpenShiftConfig.useUniqueNamespacePerTestcase()) {
            OpenShiftConfig.currentlyRunningTestCase = ((Class)context.getTestClass().get()).getName();
            this.assignNamespaceToNonTestCaseOpenshiftClients((String)OpenShiftConfig.namespaces.get(((Class)context.getTestClass().get()).getName()));
            this.createProject();
        }
    }

    private void createProject() {
        OpenShift openShift = OpenShifts.master();
        if (openShift.getProject() == null) {
            openShift.createProjectRequest();
            openShift.waiters().isProjectReady().waitFor();
            try {
                ((Resource)OpenShifts.admin().namespaces().withName(openShift.getProject().getMetadata().getName())).edit(new Visitor[]{new Visitor<NamespaceBuilder>(){

                    public void visit(NamespaceBuilder builder) {
                        builder.editMetadata().addToLabels("xtf.cz/managed", "true");
                    }
                }});
            }
            catch (KubernetesClientException e) {
                log.warn("Couldn't assign label 'xtf.cz/managed' to the new project '" + openShift.getNamespace() + "'. Possible cause are insufficient permissions.");
                log.debug(e.getMessage());
            }
        }
        if (OpenShiftConfig.pullSecret() != null) {
            openShift.setupPullSecret(OpenShiftConfig.pullSecret());
        }
    }

    public void afterAll(ExtensionContext context) {
        boolean deleted;
        OpenShift openShift = OpenShifts.master();
        if (OpenShiftConfig.useUniqueNamespacePerTestcase() && JUnitConfig.cleanOpenShift() && (deleted = openShift.deleteProject())) {
            BooleanSupplier bs = () -> openShift.getProject() == null;
            new SimpleWaiter(bs, TimeUnit.MINUTES, 2L, "Waiting for old project deletion").waitFor();
        }
        OpenShiftConfig.currentlyRunningTestCase = null;
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        OpenShift openShift = OpenShifts.master();
        if (JUnitConfig.cleanOpenShift()) {
            if (OpenShiftConfig.useUniqueNamespacePerTestcase()) {
                boolean deleted = openShift.deleteProject();
                if (deleted) {
                    BooleanSupplier bs = () -> openShift.getProject() == null;
                    new SimpleWaiter(bs, TimeUnit.MINUTES, 2L, "Waiting for old project deletion").waitFor();
                }
            } else {
                ((Stream)OpenShiftConfig.namespaces.keySet().stream().parallel()).forEach(k -> {
                    boolean deleted;
                    if (!BuildManagerConfig.namespace().equals(OpenShiftConfig.namespaces.get(k)) && (deleted = openShift.deleteProject((String)OpenShiftConfig.namespaces.get(k)))) {
                        BooleanSupplier bs = () -> openShift.getProject() == null;
                        new SimpleWaiter(bs, TimeUnit.MINUTES, 2L, "Waiting for project deletion of " + (String)OpenShiftConfig.namespaces.get(k)).waitFor();
                    }
                });
            }
        }
    }

    private void assignNamespaceToNonTestCaseOpenshiftClients(String namespace) {
        for (OpenShift client2 : OpenShift.nonTestCaseScopedOpenshiftClients) {
            Class<?> cl;
            String originalNamespace;
            if (client2.getNamespace().equals(BuildManagerConfig.namespace())) continue;
            Field field = null;
            try {
                originalNamespace = client2.getNamespace();
                cl = client2.getClass();
                while (field == null && cl.getSuperclass() != null) {
                    try {
                        field = cl.getDeclaredField("namespace");
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                    cl = cl.getSuperclass();
                }
                field.setAccessible(true);
                field.set(client2, namespace);
                log.info("Changing namespace client from: " + originalNamespace + " to: " + namespace);
            }
            catch (Exception e) {
                log.error("Cannot change namespace.", (Throwable)e);
            }
            field = null;
            try {
                originalNamespace = client2.getNamespace();
                cl = client2.config().getConfiguration().getClass();
                while (field == null && cl.getSuperclass() != null) {
                    try {
                        field = cl.getDeclaredField("namespace");
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                    cl = cl.getSuperclass();
                }
                field.setAccessible(true);
                field.set(client2.config().getConfiguration(), namespace);
                log.info("Changing namespace of client config from: " + originalNamespace + " to: " + namespace);
            }
            catch (Exception e) {
                log.error("Cannot change namespace.", (Throwable)e);
            }
            log.info("client config namespace is: " + client2.config().getNamespace());
        }
        OpenShift.nonTestCaseScopedOpenshiftClients.forEach(client -> log.info("namespace current: " + namespace + " and set: " + client.getNamespace()));
    }

    public FilterResult apply(TestDescriptor testDescriptor) {
        if (testDescriptor instanceof MethodBasedTestDescriptor) {
            boolean disabled;
            boolean bl = disabled = Arrays.stream(((MethodBasedTestDescriptor)testDescriptor).getTestClass().getAnnotations()).filter(annotation -> annotation instanceof Disabled).count() > 0L;
            if (disabled) {
                log.info("Test is disabled - skip it");
            } else {
                OpenShiftConfig.namespaces.putIfAbsent(((MethodBasedTestDescriptor)testDescriptor).getTestClass().getName(), XTFConfig.get((String)"xtf.openshift.namespace") + "-" + ((TestDescriptor)testDescriptor.getParent().get()).getDisplayName().toLowerCase());
            }
        }
        return FilterResult.included((String)testDescriptor.getDisplayName());
    }
}

