/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.junit5.listeners;

import cz.xtf.core.bm.BuildManager;
import cz.xtf.core.bm.BuildManagers;
import cz.xtf.core.config.BuildManagerConfig;
import cz.xtf.core.config.WaitingConfig;
import cz.xtf.core.openshift.OpenShift;
import cz.xtf.core.openshift.OpenShifts;
import cz.xtf.core.waiting.SimpleWaiter;
import cz.xtf.core.waiting.Waiter;
import cz.xtf.core.waiting.WaiterException;
import cz.xtf.junit5.annotations.SinceVersion;
import cz.xtf.junit5.annotations.SkipFor;
import cz.xtf.junit5.annotations.UsesBuild;
import cz.xtf.junit5.config.JUnitConfig;
import cz.xtf.junit5.extensions.SinceVersionCondition;
import cz.xtf.junit5.extensions.SkipForCondition;
import cz.xtf.junit5.interfaces.BuildDefinition;
import io.fabric8.kubernetes.client.KubernetesClientException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedBuildPrebuilder
implements TestExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(ManagedBuildPrebuilder.class);

    public void testPlanExecutionStarted(TestPlan testPlan) {
        LinkedList<BuildDefinition> buildsToBeBuilt = new LinkedList<BuildDefinition>();
        HashSet<BuildDefinition> buildsSeen = new HashSet<BuildDefinition>();
        for (TestIdentifier root : testPlan.getRoots()) {
            this.process(buildsToBeBuilt, buildsSeen, root);
            for (TestIdentifier descendant : testPlan.getDescendants(root)) {
                this.process(buildsToBeBuilt, buildsSeen, descendant);
            }
        }
        LinkedList<Runnable> deferredWaits = new LinkedList<Runnable>();
        BuildManager buildManager = null;
        OpenShift buildManagerOpenShift = OpenShifts.master((String)BuildManagerConfig.namespace());
        SimpleWaiter runningBuildsBelowCapacity = new SimpleWaiter(() -> buildManagerOpenShift.getBuilds().stream().filter(build -> build.getStatus() != null && "Running".equals(build.getStatus().getPhase())).count() < (long)BuildManagerConfig.maxRunningBuilds()).timeout(TimeUnit.MILLISECONDS, WaitingConfig.timeout()).reason("Waiting for a free capacity for running builds in " + BuildManagerConfig.namespace() + " namespace.");
        for (BuildDefinition buildDefinition : buildsToBeBuilt) {
            if (buildManager == null) {
                buildManager = BuildManagers.get();
            }
            try {
                runningBuildsBelowCapacity.waitFor();
            }
            catch (WaiterException x) {
                log.warn("Timeout waiting for free capacity", (Throwable)x);
            }
            catch (KubernetesClientException x) {
                log.warn("KubernetesClientException waiting for free capacity in {} namespace", (Object)BuildManagerConfig.namespace(), (Object)x);
            }
            log.debug("Building {}", (Object)buildDefinition);
            Object managedBuild = buildDefinition.getManagedBuild();
            try {
                buildManager.deploy(managedBuild);
                Waiter buildCompleted = buildManager.hasBuildCompleted(managedBuild);
                Runnable waitForBuild = () -> {
                    try {
                        boolean status = buildCompleted.waitFor();
                        if (!status) {
                            log.warn("Build {} failed!", (Object)buildDefinition);
                        }
                    }
                    catch (WaiterException x) {
                        log.warn("Timeout building {}", (Object)buildDefinition, (Object)x);
                    }
                    catch (KubernetesClientException x) {
                        log.warn("KubernetesClientException waiting for {}", (Object)buildDefinition, (Object)x);
                    }
                };
                if (JUnitConfig.prebuilderSynchronized()) {
                    waitForBuild.run();
                    continue;
                }
                deferredWaits.add(waitForBuild);
            }
            catch (KubernetesClientException x) {
                log.error("Error building {}", (Object)buildDefinition, (Object)x);
                try {
                    managedBuild.delete(buildManagerOpenShift);
                }
                catch (KubernetesClientException y) {
                    log.error("Cannot delete managed build {}, ignoring...", (Object)buildDefinition, (Object)y);
                }
            }
        }
        if (!JUnitConfig.prebuilderSynchronized()) {
            for (Runnable deferredWait : deferredWaits) {
                deferredWait.run();
            }
        }
    }

    private void addBuildDefinition(List<BuildDefinition> buildsToBeBuilt, Set<BuildDefinition> buildsSeen, BuildDefinition buildDefinition) {
        if (!buildsSeen.contains(buildDefinition)) {
            buildsSeen.add(buildDefinition);
            buildsToBeBuilt.add(buildDefinition);
        }
    }

    private void process(List<BuildDefinition> buildsToBeBuilt, Set<BuildDefinition> buildsSeen, TestIdentifier identifier) {
        TestSource testSource;
        if (identifier.getSource().isPresent() && (testSource = (TestSource)identifier.getSource().get()) instanceof ClassSource) {
            ClassSource classSource = (ClassSource)testSource;
            Class klass = classSource.getJavaClass();
            log.debug("Processing {}", (Object)klass);
            boolean classSkippedForStream = Arrays.stream(klass.getAnnotationsByType(SkipFor.class)).anyMatch(a -> SkipForCondition.resolve((SkipFor)a).isDisabled());
            boolean classSkippedForTestedVersion = Arrays.stream(klass.getAnnotationsByType(SinceVersion.class)).anyMatch(a -> SinceVersionCondition.resolve((SinceVersion)a).isDisabled());
            if (classSkippedForStream || classSkippedForTestedVersion) {
                return;
            }
            Arrays.stream(klass.getAnnotations()).filter(a -> a.annotationType().getAnnotation(UsesBuild.class) != null).forEach(a -> {
                try {
                    Object result = a.annotationType().getMethod("value", new Class[0]).invoke(a, new Object[0]);
                    if (result instanceof BuildDefinition) {
                        this.addBuildDefinition(buildsToBeBuilt, buildsSeen, (BuildDefinition)result);
                    } else if (result instanceof BuildDefinition[]) {
                        Stream.of((BuildDefinition[])result).forEach(x -> this.addBuildDefinition(buildsToBeBuilt, buildsSeen, (BuildDefinition)x));
                    } else {
                        log.error("Value present in {} is not instance of {}, not able to get ManagedBuild to be built", result, BuildDefinition.class);
                    }
                }
                catch (Exception e) {
                    log.error("Failed to invoke value() on annotation " + a.annotationType().getName(), (Throwable)e);
                }
            });
        }
    }
}

