/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.junit5.listeners;

import cz.xtf.core.image.Image;
import cz.xtf.junit5.config.JUnitConfig;
import java.io.File;
import java.io.FileWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Properties;
import lombok.Generated;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigRecorder
implements TestExecutionListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigRecorder.class);
    private static final File RUNTIME_IMAGES_FILE = ConfigRecorder.getProjectRoot().resolve("used-images.properties").toFile();

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.recordUsedImages();
    }

    private void recordUsedImages() {
        List<String> usedImages = JUnitConfig.usedImages();
        if (usedImages.size() > 0) {
            Properties images = new Properties();
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (FileWriter writer = new FileWriter(RUNTIME_IMAGES_FILE);){
                    usedImages.forEach(name -> {
                        Object object = images.setProperty((String)name, Image.resolve((String)name).getUrl());
                    });
                    images.store(writer, "Images used in test");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.warn("Failed to record used images!");
            }
        }
    }

    private static Path getProjectRoot() {
        Path dir = Paths.get("", new String[0]).toAbsolutePath();
        while (dir.getParent().resolve("pom.xml").toFile().exists()) {
            dir = dir.getParent();
        }
        return dir;
    }
}

