/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.junit5.model;

import cz.xtf.core.config.OpenShiftConfig;
import cz.xtf.core.image.Image;
import cz.xtf.core.namespace.NamespaceManager;
import cz.xtf.core.openshift.OpenShift;
import cz.xtf.core.waiting.SimpleWaiter;
import cz.xtf.core.waiting.failfast.FailFastCheck;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamTag;
import io.fabric8.openshift.api.model.NamedTagEventList;
import io.fabric8.openshift.api.model.TagEventCondition;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class DockerImageMetadata {
    private static final String METADATA_ID = "Id";
    private static final String METADATA_CONFIG = "Config";
    private static final String METADATA_CONFIG_LABELS = "Labels";
    private static final String METADATA_CONFIG_ENV = "Env";
    private static final String METADATA_CONFIG_CMD = "Cmd";
    private static final String METADATA_CONFIG_EXPOSED_PORTS = "ExposedPorts";
    private static final ConcurrentHashMap<String, DockerImageMetadata> CACHED_METADATA = new ConcurrentHashMap();
    private final Map<String, Object> metadata;

    private DockerImageMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    private static String forgeMetadataKey(OpenShift openshift, Image image) {
        return String.format("%s;%s", openshift.getNamespace(), image.getUrl());
    }

    public static DockerImageMetadata get(OpenShift openShift, String imageUrl) {
        return DockerImageMetadata.get(openShift, Image.from((String)imageUrl));
    }

    public static DockerImageMetadata get(OpenShift openShift, Image image) {
        return CACHED_METADATA.computeIfAbsent(DockerImageMetadata.forgeMetadataKey(openShift, image), s -> DockerImageMetadata.getMetadata(openShift, image));
    }

    private static DockerImageMetadata getMetadata(OpenShift openShift, Image image) {
        ImageStreamTag imageStreamTag = openShift.getImageStreamTag(image.getRepo(), image.getMajorTag());
        DockerImageMetadata metadataFromTag = DockerImageMetadata.getMetadataFromTag(imageStreamTag);
        if (metadataFromTag != null) {
            return metadataFromTag;
        }
        boolean isNewProject = NamespaceManager.createIfDoesNotExistsProject((String)OpenShiftConfig.namespace());
        String tempName = String.valueOf(image.getRepo()) + "-" + DockerImageMetadata.randomString();
        ImageStream imageStream = image.getImageStream(tempName);
        imageStream.getMetadata().setName(tempName);
        ((Resource)openShift.imageStreams().resource((Object)imageStream)).createOrReplace();
        SimpleWaiter metadataWaiter = new SimpleWaiter(() -> DockerImageMetadata.areMetadataForImageReady(openShift.getImageStreamTag(tempName, image.getMajorTag())), "Giving OpenShift instance time to download image metadata.").failFast((FailFastCheck)new ImageStreamFailFastCheck(openShift, tempName, image));
        boolean metadataOK = metadataWaiter.waitFor();
        DockerImageMetadata metadata = metadataOK ? DockerImageMetadata.getMetadataFromTag(openShift.getImageStreamTag(tempName, image.getMajorTag())) : null;
        openShift.deleteImageStream(imageStream);
        if (isNewProject) {
            NamespaceManager.deleteProject((String)OpenShiftConfig.namespace(), (boolean)true);
        }
        return metadata;
    }

    private static DockerImageMetadata getMetadataFromTag(ImageStreamTag imageStreamTag) {
        return DockerImageMetadata.areMetadataForImageReady(imageStreamTag) ? new DockerImageMetadata((Map)imageStreamTag.getImage().getDockerImageMetadata().getValue()) : null;
    }

    private static boolean areMetadataForImageReady(ImageStreamTag tag) {
        return tag != null && tag.getImage() != null && tag.getImage().getDockerImageMetadata() != null && tag.getImage().getDockerImageMetadata().getValue() != null;
    }

    private static String randomString() {
        return new Random().ints(97, 123).limit(5L).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    private Map<String, Object> getConfig() {
        return (Map)this.metadata.get(METADATA_CONFIG);
    }

    public String getId() {
        return (String)this.metadata.get(METADATA_ID);
    }

    public Map<String, String> labels() {
        return (Map)this.getConfig().get(METADATA_CONFIG_LABELS);
    }

    public Map<String, String> envs() {
        HashMap envMap = new HashMap();
        List envList = (List)this.getConfig().get(METADATA_CONFIG_ENV);
        envList.forEach(node -> {
            String[] keyValue = node.split("=", 2);
            envMap.put(keyValue[0], keyValue[1]);
        });
        return Collections.unmodifiableMap(envMap);
    }

    public String command() {
        return String.join((CharSequence)" ", this.commandList());
    }

    public List<String> commandList() {
        return (List)this.getConfig().get(METADATA_CONFIG_CMD);
    }

    public Set<Integer> exposedPorts(String protocol) {
        HashSet<Integer> result = new HashSet<Integer>();
        Map exposedPorts = (Map)this.getConfig().get(METADATA_CONFIG_EXPOSED_PORTS);
        exposedPorts.keySet().forEach(portDef -> {
            String[] split = portDef.split("/");
            if (StringUtils.isBlank((CharSequence)protocol) || split[1].equalsIgnoreCase(protocol)) {
                result.add(Integer.parseInt(split[0]));
            }
        });
        return result;
    }

    private static final class ImageStreamFailFastCheck
    implements FailFastCheck {
        private final OpenShift openShift;
        private final String imageName;
        private final Image image;
        private String reason = "";

        ImageStreamFailFastCheck(OpenShift openShift, String imageName, Image image) {
            this.openShift = openShift;
            this.imageName = imageName;
            this.image = image;
        }

        public boolean hasFailed() {
            ImageStream imageStream = this.openShift.getImageStream(this.imageName);
            if (imageStream == null) {
                return false;
            }
            for (NamedTagEventList tag : imageStream.getStatus().getTags()) {
                if (!this.image.getTag().startsWith(tag.getTag())) continue;
                for (TagEventCondition condition : tag.getConditions()) {
                    if (!condition.getType().equals("ImportSuccess") || !condition.getStatus().equals("False")) continue;
                    this.reason = condition.getMessage();
                    return true;
                }
            }
            return false;
        }

        public String reason() {
            return this.reason;
        }
    }
}

