/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.testhelpers.image;

import cz.xtf.core.config.WaitingConfig;
import cz.xtf.core.config.XTFConfig;
import cz.xtf.core.openshift.OpenShift;
import cz.xtf.core.openshift.PodShell;
import cz.xtf.core.openshift.helpers.ResourceParsers;
import cz.xtf.core.waiting.SimpleWaiter;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodSpec;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ImageContent {
    public static final String RED_HAT_RELEASE_KEY_2 = "199e2f91fd431d51";
    public static final String RED_HAT_RELEASE_KEY_2_RPM = "gpg-pubkey-fd431d51-4ae0493b";
    public static final String RED_HAT_AUXILIARY_KEY_RPM = "gpg-pubkey-2fa658e0-45700c69";
    public static final String RED_HAT_AUXILIARY_KEY_2_RPM = "gpg-pubkey-d4082792-5b32db75";
    public static final String[] DEFAULT_JAVA_UTILITIES = new String[]{"jjs", "keytool", "orbd", "rmid", "rmiregistry", "servertool", "tnameserv", "unpack200", "javac", "appletviewer", "extcheck", "idlj", "jar", "jarsigner", "javadoc", "javah", "javap", "jcmd", "jconsole", "jdb", "jdeps", "jhat", "jinfo", "jmap", "jps", "jrunscript", "jsadebugd", "jstack", "jstat", "jstat", "jstatd", "native2ascii", "rmic", "schemagen", "serialver", "wsgen", "wsimport", "xjc", "pack200"};
    private PodShell shell;
    private boolean md5sumScriptInstalled = false;
    private boolean mavenScriptInstalled = false;

    public static ImageContent prepare(OpenShift openShift, String imageUrl) {
        return ImageContent.prepare(openShift, imageUrl, "test-pod", null);
    }

    public static ImageContent prepare(OpenShift openShift, String imageUrl, Map<String, String> envs) {
        return ImageContent.prepare(openShift, imageUrl, "test-pod", null, envs);
    }

    public static ImageContent prepare(OpenShift openShift, String imageUrl, List<String> command) {
        return ImageContent.prepare(openShift, imageUrl, "test-pod", command, Collections.emptyMap());
    }

    public static ImageContent prepare(OpenShift openShift, String imageUrl, String name, List<String> command) {
        return ImageContent.prepare(openShift, imageUrl, name, command, Collections.emptyMap());
    }

    public static ImageContent prepare(OpenShift openShift, String imageUrl, String name, List<String> command, Map<String, String> envs) {
        Pod pod = ImageContent.getPod(imageUrl, name, command, envs);
        openShift.createPod(pod);
        BooleanSupplier bs = () -> {
            Pod p = openShift.getPod(name);
            return p != null && ResourceParsers.isPodRunning((Pod)p) && ResourceParsers.isPodReady((Pod)p);
        };
        new SimpleWaiter(bs, "Waiting for '" + name + "' pod to be running and ready").timeout(WaitingConfig.timeout()).waitFor();
        return ImageContent.prepare(openShift, pod);
    }

    public static ImageContent prepare(OpenShift openShift, Pod pod) {
        return new ImageContent(new PodShell(openShift, pod));
    }

    private static Pod getPod(String imageUrl, String name, List<String> command, Map<String, String> envs) {
        Container container = ((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName(name)).withImage(imageUrl)).build();
        if (command != null) {
            container.setCommand(command);
        }
        container.setEnv(envs.entrySet().stream().map(e -> new EnvVar((String)e.getKey(), (String)e.getValue(), null)).collect(Collectors.toList()));
        PodSpec podSpec = new PodSpec();
        podSpec.setContainers(Collections.singletonList(container));
        Pod pod = new Pod();
        pod.setMetadata(((ObjectMetaBuilder)new ObjectMetaBuilder().withName(name)).build());
        pod.setSpec(podSpec);
        return pod;
    }

    private ImageContent(PodShell shell) {
        this.shell = shell;
    }

    public PodShell shell() {
        return this.shell;
    }

    public Map<String, String> runtimeEnvVars() {
        return this.shell.execute(new String[]{"env"}).getOutputAsMap("=");
    }

    public List<String> listDirContent(String path) {
        return this.listDirContent(path, false);
    }

    public List<String> listDirContent(String path, boolean hidden) {
        String flag = hidden ? "-a1 " : "-1 ";
        return this.shell.executeWithBash("ls " + flag + path).getOutputAsList();
    }

    public List<String> listZipFilesInDir(String path) {
        return this.shell.executeWithBash("ls -R1 " + path + " | grep '\\.zip$'").getOutputAsList();
    }

    public List<String> listFilesMd5sumInDir(String path) {
        String md5sumScriptPath = "/tmp/recursive-md5sum.sh";
        if (!this.md5sumScriptInstalled) {
            this.shell.executeWithBash("echo \"cd \\$1\" >> /tmp/recursive-md5sum.sh");
            this.shell.executeWithBash("echo \"for i in \\$(find . -type f)\" >> /tmp/recursive-md5sum.sh");
            this.shell.executeWithBash("echo \"do\" >> /tmp/recursive-md5sum.sh");
            this.shell.executeWithBash("echo \"  md5sum \\$i\" >> /tmp/recursive-md5sum.sh");
            this.shell.executeWithBash("echo \"done\" >> /tmp/recursive-md5sum.sh");
            this.shell.executeWithBash("chmod 777 /tmp/recursive-md5sum.sh");
            this.md5sumScriptInstalled = true;
        }
        return this.shell.executeWithBash("/tmp/recursive-md5sum.sh " + path).getOutputAsList();
    }

    public String javaVersion() {
        return this.shell.execute(new String[]{"java", "-version"}).getError().replaceAll("\n", "").replaceAll("openjdk version \"([0-9]+\\.[0-9]+\\.[0-9]+).*", "$1");
    }

    public String mavenVersion() {
        String mavenScriptPath = "/tmp/maven-version.sh";
        if (!this.mavenScriptInstalled) {
            String mavenActivationScript = this.getMavenActivationScript("/tmp/maven-version.sh");
            this.shell.executeWithBash(mavenActivationScript);
            this.shell.executeWithBash("echo mvn --version >> /tmp/maven-version.sh");
            this.shell.executeWithBash("chmod 777 /tmp/maven-version.sh");
            this.mavenScriptInstalled = true;
        }
        return this.shell.executeWithBash("/tmp/maven-version.sh").getOutput().replaceAll("\n", "").replaceAll(".*Apache Maven ([0-9]+\\.[0-9]+\\.[0-9]+) .*", "$1");
    }

    private String getMavenActivationScript(String mavenScriptPath) {
        String mavenEnableScript = XTFConfig.get((String)"xtf.maven.activation_script", (String)"/opt/rh/rh-maven35/enable");
        return "echo . " + mavenEnableScript + " >> " + mavenScriptPath;
    }

    public List<RpmPackage> rpms() {
        return Stream.of(this.shell.executeWithBash("rpm -qa --info").getOutput().split("(?=Name {8}: )")).map(packageInfo -> {
            String infoLine;
            String[] splitted;
            HashMap<String, String> map = new HashMap<String, String>();
            String[] stringArray = packageInfo.split("\n");
            int n = stringArray.length;
            for (int i = 0; i < n && !(splitted = (infoLine = stringArray[i]).split(":", 2))[0].trim().equals("Description"); ++i) {
                map.put(splitted[0].trim(), splitted[1].trim());
            }
            return new RpmPackage((String)map.get("Name"), (String)map.get("Version"), (String)map.get("Release"), (String)map.get("Signature"));
        }).collect(Collectors.toList());
    }

    public static class RpmPackage {
        private String name;
        private String version;
        private String release;
        private String signature;

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String getRelease() {
            return this.release;
        }

        public String getSignature() {
            return this.signature;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public void setRelease(String release) {
            this.release = release;
        }

        public void setSignature(String signature) {
            this.signature = signature;
        }

        public String toString() {
            return "ImageContent.RpmPackage(name=" + this.getName() + ", version=" + this.getVersion() + ", release=" + this.getRelease() + ", signature=" + this.getSignature() + ")";
        }

        public RpmPackage(String name, String version, String release, String signature) {
            this.name = name;
            this.version = version;
            this.release = release;
            this.signature = signature;
        }
    }
}

