/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.testhelpers.image;

import com.google.gson.Gson;
import cz.xtf.core.image.Image;
import cz.xtf.core.openshift.OpenShift;
import cz.xtf.core.waiting.SimpleWaiter;
import cz.xtf.core.waiting.failfast.FailFastCheck;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamTag;
import io.fabric8.openshift.api.model.NamedTagEventList;
import io.fabric8.openshift.api.model.TagEventCondition;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ImageMetadata {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImageMetadata.class);
    private final ModelNode metadata;

    public static ImageMetadata prepare(OpenShift openShift, String imageUrl) {
        return ImageMetadata.prepare(openShift, Image.from((String)imageUrl));
    }

    public static ImageMetadata prepare(OpenShift openShift, Image image) {
        openShift.createImageStream(image.getImageStream());
        Supplier<ImageStreamTag> imageStreamTagSupplier = () -> (ImageStreamTag)((Resource)openShift.imageStreamTags().withName(String.valueOf(image.getRepo()) + ":" + image.getMajorTag())).get();
        SimpleWaiter metadataWaiter = new SimpleWaiter(() -> {
            ImageStreamTag isTag = (ImageStreamTag)imageStreamTagSupplier.get();
            return isTag != null && isTag.getImage() != null && isTag.getImage().getMetadata() != null && isTag.getImage().getMetadata().getAdditionalProperties() != null;
        }, "Giving OpenShift instance time to download image metadata.");
        metadataWaiter.failFast((FailFastCheck)new ImageStreamFailFastCheck(openShift, image.getRepo(), image)).waitFor();
        return new ImageMetadata(ModelNode.fromJSONString((String)new Gson().toJson((Object)imageStreamTagSupplier.get().getImage().getMetadata().getAdditionalProperties())));
    }

    private ImageMetadata(ModelNode metadata) {
        this.metadata = metadata;
    }

    public Map<String, String> labels() {
        return this.metadata.get(new String[]{"Config", "Labels"}).asPropertyList().stream().collect(Collectors.toMap(Property::getName, property -> property.getValue().asString()));
    }

    public String command() {
        return this.metadata.get(new String[]{"Config", "Cmd"}).get(0).asString();
    }

    public Map<String, String> envs() {
        HashMap env = new HashMap();
        this.metadata.get(new String[]{"Config", "Env"}).asList().forEach(node -> {
            String[] keyValue = node.asString().split("=", 2);
            env.put(keyValue[0], keyValue[1]);
        });
        return Collections.unmodifiableMap(env);
    }

    public Set<Integer> exposedPorts(String protocol) {
        HashSet<Integer> result = new HashSet<Integer>();
        ModelNode exposedPorts = this.metadata.get(new String[]{"Config", "ExposedPorts"});
        if (exposedPorts.getType() != ModelType.UNDEFINED) {
            exposedPorts.keys().forEach(portDef -> {
                String[] split = portDef.split("/");
                if (StringUtils.isBlank((CharSequence)protocol) || split[1].equalsIgnoreCase(protocol)) {
                    result.add(Integer.parseInt(split[0]));
                }
            });
        }
        return result;
    }

    private static final class ImageStreamFailFastCheck
    implements FailFastCheck {
        private final OpenShift openShift;
        private final String imageName;
        private final Image image;
        private String reason = "";

        ImageStreamFailFastCheck(OpenShift openShift, String imageName, Image image) {
            this.openShift = openShift;
            this.imageName = imageName;
            this.image = image;
        }

        public boolean hasFailed() {
            ImageStream imageStream = this.openShift.getImageStream(this.imageName);
            if (imageStream == null) {
                return false;
            }
            for (NamedTagEventList tag : imageStream.getStatus().getTags()) {
                if (!this.image.getTag().startsWith(tag.getTag())) continue;
                for (TagEventCondition condition : tag.getConditions()) {
                    if (!condition.getType().equals("ImportSuccess") || !condition.getStatus().equals("False")) continue;
                    this.reason = condition.getMessage();
                    return true;
                }
            }
            return false;
        }

        public String reason() {
            return this.reason;
        }
    }
}

