/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.security;

import edu.internet2.middleware.security.XmlSecTool;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.GeneralSecurityException;
import java.security.KeyException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.X509TrustManager;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.x509.BasicX509Credential;
import org.opensaml.xml.security.x509.X509Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialHelper {
    private static final Logger LOG = LoggerFactory.getLogger(CredentialHelper.class);

    public static X509TrustManager buildNoTrustTrustManager() {
        X509TrustManager noTrustManager = new X509TrustManager(){

            public void checkClientTrusted(X509Certificate[] certs, String auth) {
            }

            public void checkServerTrusted(X509Certificate[] certs, String auth) {
            }

            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
        return noTrustManager;
    }

    public static BasicX509Credential getFileBasedCredentials(String keyFile, String keyPassword, String certificateFile) throws KeyException, CertificateException {
        BasicX509Credential credential = new BasicX509Credential();
        LOG.debug("Reading PEM/DER encoded credentials from the filesystem");
        if (keyFile != null) {
            LOG.debug("Reading private key from file {}", (Object)keyFile);
            credential.setPrivateKey(SecurityHelper.decodePrivateKey((File)new File(keyFile), (char[])keyPassword.toCharArray()));
            LOG.debug("Private key succesfully read");
        }
        LOG.debug("Reading certificates from file {}", (Object)certificateFile);
        credential.setEntityCertificateChain(X509Util.decodeCertificate((File)new File(certificateFile)));
        credential.setEntityCertificate((X509Certificate)credential.getEntityCertificateChain().iterator().next());
        credential.setPublicKey(credential.getEntityCertificate().getPublicKey());
        LOG.debug("Certificates successfully");
        return credential;
    }

    public static BasicX509Credential getKeystoreCredential(String keystorePath, String keystorePassword, String keystoreProvider, String keystoreType, String keyAlias, String keyPassword) throws IOException, GeneralSecurityException {
        String storePassword;
        LOG.debug("Reading credentials from keystore");
        String storeType = keystoreType;
        if (storeType == null) {
            storeType = KeyStore.getDefaultType();
        }
        if ((storePassword = keystorePassword) == null) {
            storePassword = keyPassword;
        }
        KeyStore keystore = keystoreProvider != null ? KeyStore.getInstance(storeType, keystoreProvider) : KeyStore.getInstance(storeType);
        keystore.load(new FileInputStream(keystorePath), storePassword.toCharArray());
        return CredentialHelper.getCredentialFromKeystore(keystore, keyAlias, keyPassword);
    }

    public static BasicX509Credential getPKCS11Credential(String keystoreProvider, String pkcs11Config, String keyAlias, String keyPassword) throws IOException, GeneralSecurityException {
        LOG.debug("Install PKCS11 provider");
        KeyStore keystore = null;
        try {
            if (keystoreProvider != null) {
                LOG.debug("Creating PKCS11 keystore with provider {} and configuration file {}", (Object)keystoreProvider, (Object)pkcs11Config);
                Class<?> providerClass = XmlSecTool.class.getClassLoader().loadClass(keystoreProvider);
                Constructor<?> providerConstructor = providerClass.getConstructor(String.class);
                Provider pkcs11Provider = (Provider)providerConstructor.newInstance(pkcs11Config);
                pkcs11Provider.load(new FileInputStream(pkcs11Config));
                Security.addProvider(pkcs11Provider);
                keystore = KeyStore.getInstance("PKCS11", pkcs11Provider);
            } else {
                LOG.debug("Creating PKCS11 keystore with system wide provider and configuration file");
                keystore = KeyStore.getInstance("PKCS11");
            }
        }
        catch (ClassNotFoundException e) {
            LOG.error("Unable to load keystore provider class: " + keystoreProvider);
            System.exit(1);
        }
        catch (NoSuchMethodException e) {
            LOG.error("Keystore provider class does not provide a default, no-argument, constructor");
            System.exit(1);
        }
        catch (Exception e) {
            LOG.error("Unable to construct instance of keystore provider class");
            System.exit(1);
        }
        LOG.debug("Initializing PKCS11 keystore");
        keystore.load(null, keyPassword.toCharArray());
        return CredentialHelper.getCredentialFromKeystore(keystore, keyAlias, keyPassword);
    }

    public static BasicX509Credential getCredentialFromKeystore(KeyStore keystore, String keyAlias, String keyPassword) throws GeneralSecurityException {
        KeyStore.Entry keyEntry = keystore.getEntry(keyAlias, new KeyStore.PasswordProtection(keyPassword.toCharArray()));
        BasicX509Credential credential = new BasicX509Credential();
        if (keyEntry instanceof KeyStore.PrivateKeyEntry) {
            KeyStore.PrivateKeyEntry privKeyEntry = (KeyStore.PrivateKeyEntry)keyEntry;
            List<Certificate> certChain = Arrays.asList(privKeyEntry.getCertificateChain());
            credential.setEntityCertificate((X509Certificate)privKeyEntry.getCertificate());
            credential.setEntityCertificateChain(certChain);
            credential.setPrivateKey(privKeyEntry.getPrivateKey());
            credential.setPublicKey(privKeyEntry.getCertificate().getPublicKey());
        } else if (keyEntry instanceof KeyStore.TrustedCertificateEntry) {
            KeyStore.TrustedCertificateEntry certEntry = (KeyStore.TrustedCertificateEntry)keyEntry;
            credential.setEntityCertificate((X509Certificate)certEntry.getTrustedCertificate());
            credential.setPublicKey(credential.getEntityCertificate().getPublicKey());
        }
        LOG.debug("Successfully read credentials from keystore");
        return credential;
    }
}

