/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.security;

import edu.internet2.middleware.security.CredentialHelper;
import edu.internet2.middleware.security.XmlSecToolCommandLineArguments;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.KeyName;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.transforms.Transforms;
import org.opensaml.Configuration;
import org.opensaml.DefaultBootstrap;
import org.opensaml.ws.soap.client.http.HttpClientBuilder;
import org.opensaml.ws.soap.client.http.TLSProtocolSocketFactory;
import org.opensaml.xml.schema.SchemaBuilder;
import org.opensaml.xml.security.SecurityConfiguration;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.x509.BasicX509Credential;
import org.opensaml.xml.security.x509.X509Util;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.util.Base64;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlSecTool {
    public static final int RC_OK = 0;
    public static final int RC_INIT = 1;
    public static final int RC_IO = 2;
    public static final int RC_MALFORMED_XML = 3;
    public static final int RC_INVALID_XML = 4;
    public static final int RC_INVALID_XS = 5;
    public static final int RC_INVALID_CRED = 6;
    public static final int RC_SIG = 7;
    public static final int RC_UNKNOWN = -1;
    private static Logger log;

    public static void main(String[] args) {
        XmlSecToolCommandLineArguments cli = new XmlSecToolCommandLineArguments(args);
        cli.parseCommandLineArguments(args);
        if (cli.doHelp()) {
            cli.printHelp(System.out);
            System.exit(0);
        }
        XmlSecTool.initLogging(cli);
        try {
            Init.init();
            DefaultBootstrap.bootstrap();
        }
        catch (Throwable e) {
            log.error("Unable to initialize OpenSAML and XML security libraries", e);
            System.exit(1);
        }
        try {
            Document xml = XmlSecTool.parseXML(cli);
            if (cli.doSchemaValidation()) {
                XmlSecTool.schemaValidate(cli, xml);
            }
            if (cli.doSign()) {
                XmlSecTool.sign(cli, xml);
            }
            if (cli.doSignatureVerify()) {
                XmlSecTool.verifySignature(cli, xml);
            }
            if (cli.getOutputFile() != null) {
                XmlSecTool.writeDocument(cli, xml);
            }
        }
        catch (Throwable t) {
            log.error("Unknown error", t);
            System.exit(-1);
        }
    }

    protected static Document parseXML(XmlSecToolCommandLineArguments cli) {
        InputStream xmlInputStream = cli.getInputFile() != null ? XmlSecTool.getXmlInputStreamFromFile(cli) : XmlSecTool.getXmlInputStreamFromUrl(cli);
        DocumentBuilder xmlParser = XmlSecTool.getParser(cli);
        try {
            log.debug("Parsing XML input stream");
            Document xmlDoc = xmlParser.parse(xmlInputStream);
            log.info("XML document parsed and is well-formed.");
            return xmlDoc;
        }
        catch (IOException e) {
            log.error("Error reading XML document from input source", (Throwable)e);
            System.exit(2);
        }
        catch (SAXException e) {
            log.error("XML document was not well formed", (Throwable)e);
            System.exit(3);
        }
        return null;
    }

    protected static InputStream getXmlInputStreamFromFile(XmlSecToolCommandLineArguments cli) {
        try {
            log.info("Reading XML document from file '{}'", (Object)cli.getInputFile());
            File inputFile = new File(cli.getInputFile());
            if (!inputFile.exists()) {
                log.error("Input file '{}' does not exist", (Object)cli.getInputFile());
                System.exit(2);
            }
            if (inputFile.isDirectory()) {
                log.error("Input file '{}' is a directory", (Object)cli.getInputFile());
                System.exit(2);
            }
            if (!inputFile.canRead()) {
                log.error("Input file '{}' can not be read", (Object)cli.getInputFile());
                System.exit(2);
            }
            return new FileInputStream(cli.getInputFile());
        }
        catch (FileNotFoundException e) {
            log.error(MessageFormatter.format((String)"Unable to read input file '{}'", (Object)cli.getInputFile()), (Throwable)e);
            System.exit(2);
            return null;
        }
    }

    protected static InputStream getXmlInputStreamFromUrl(XmlSecToolCommandLineArguments cli) {
        log.info("Reading XML document from URL '{}'", (Object)cli.getInputUrl());
        HttpClientBuilder httpClientBuilder = new HttpClientBuilder();
        httpClientBuilder.setHttpsProtocolSocketFactory((SecureProtocolSocketFactory)new TLSProtocolSocketFactory(null, CredentialHelper.buildNoTrustTrustManager()));
        if (cli.getHttpProxy() != null) {
            httpClientBuilder.setProxyHost(cli.getHttpProxy());
            httpClientBuilder.setProxyPort(cli.getHttpProxyPort());
            httpClientBuilder.setProxyUsername(cli.getHttpProxyUsername());
            httpClientBuilder.setProxyPassword(cli.getHttpProxyPassword());
        }
        GetMethod getMethod = new GetMethod(cli.getInputUrl());
        try {
            HttpClient httpClient = httpClientBuilder.buildClient();
            httpClient.executeMethod((HttpMethod)getMethod);
            if (getMethod.getStatusCode() != 200) {
                log.error(MessageFormatter.format((String)"Non-ok status code '{}' returned by '{}'", (Object)getMethod.getStatusCode(), (Object)cli.getInputUrl()));
                System.exit(2);
            }
            return getMethod.getResponseBodyAsStream();
        }
        catch (IOException e) {
            log.error(MessageFormatter.format((String)"Unable to read XML document from '{}'", (Object)cli.getInputUrl()), (Throwable)e);
            System.exit(2);
            return null;
        }
    }

    protected static DocumentBuilder getParser(XmlSecToolCommandLineArguments cli) {
        log.debug("Building DOM parser");
        DocumentBuilderFactory newFactory = DocumentBuilderFactory.newInstance();
        newFactory.setCoalescing(false);
        newFactory.setExpandEntityReferences(true);
        newFactory.setIgnoringComments(false);
        newFactory.setIgnoringElementContentWhitespace(false);
        newFactory.setNamespaceAware(true);
        newFactory.setValidating(false);
        newFactory.setXIncludeAware(false);
        try {
            return newFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            log.error("Unable to create XML parser", (Throwable)e);
            System.exit(-1);
            return null;
        }
    }

    protected static void schemaValidate(XmlSecToolCommandLineArguments cli, Document xml) {
        File schemaFileOrDirectory = new File(cli.getSchemaDirectory());
        try {
            Schema schema;
            if (cli.isXsdSchema()) {
                log.debug("Building W3 XML Schema from file/directory '{}'", (Object)schemaFileOrDirectory.getAbsolutePath());
                schema = SchemaBuilder.buildSchema((SchemaBuilder.SchemaLanguage)SchemaBuilder.SchemaLanguage.XML, (File)schemaFileOrDirectory);
            } else {
                log.debug("Building RELAX NG Schema from file/directory '{}'", (Object)schemaFileOrDirectory.getAbsolutePath());
                schema = SchemaBuilder.buildSchema((SchemaBuilder.SchemaLanguage)SchemaBuilder.SchemaLanguage.RELAX, (File)schemaFileOrDirectory);
            }
            Validator validator = schema.newValidator();
            log.debug("Schema validating XML document");
            validator.validate(new DOMSource(xml));
            log.info("XML document is schema valid");
        }
        catch (SAXException e) {
            log.error("Invalid XML schema files, unable to validate XML", (Throwable)e);
            System.exit(5);
        }
        catch (Exception e) {
            log.error("XML is not schema valid", (Throwable)e);
            System.exit(4);
        }
    }

    protected static void sign(XmlSecToolCommandLineArguments cli, Document xml) {
        log.debug("Preparing to sign document");
        Element documentRoot = xml.getDocumentElement();
        Element signatureElement = XmlSecTool.getSignatureElement(xml);
        if (signatureElement != null) {
            log.error("XML document is already signed");
            System.exit(7);
        }
        BasicX509Credential signingCredential = XmlSecTool.getCredential(cli);
        SecurityConfiguration securityConfig = Configuration.getGlobalSecurityConfiguration();
        String signatureAlgorithm = securityConfig.getSignatureAlgorithmURI((Credential)signingCredential);
        boolean hmac = SecurityHelper.isHMAC((String)signatureAlgorithm);
        Integer hmacOutputLength = securityConfig.getSignatureHMACOutputLength();
        String c14nAlgorithm = "http://www.w3.org/2001/10/xml-exc-c14n#";
        try {
            XMLSignature signature = null;
            signature = hmac ? new XMLSignature(xml, "#", signatureAlgorithm, hmacOutputLength.intValue(), c14nAlgorithm) : new XMLSignature(xml, "#", signatureAlgorithm, c14nAlgorithm);
            XmlSecTool.populateKeyInfo(xml, signature.getKeyInfo(), signingCredential);
            Transforms contentTransforms = new Transforms(xml);
            contentTransforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
            contentTransforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
            signature.addDocument(XmlSecTool.getSignatureReferenceUri(cli, documentRoot), contentTransforms, "http://www.w3.org/2000/09/xmldsig#sha1");
            log.debug("Creating Signature DOM element");
            signatureElement = signature.getElement();
            XmlSecTool.addSignatureELement(cli, documentRoot, signatureElement);
            signature.sign(SecurityHelper.extractSigningKey((Credential)signingCredential));
        }
        catch (XMLSecurityException e) {
            log.error("Unable to create XML document signature", (Throwable)e);
            System.exit(7);
        }
    }

    protected static void populateKeyInfo(Document doc, KeyInfo keyInfo, BasicX509Credential credential) {
        if (credential.getKeyNames() != null) {
            for (String name : credential.getKeyNames()) {
                KeyName keyName = new KeyName(doc, name);
                keyInfo.add(keyName);
            }
        }
        keyInfo.add(credential.getPublicKey());
        X509Data x509Data = new X509Data(doc);
        keyInfo.add(x509Data);
        try {
            for (X509Certificate cert : credential.getEntityCertificateChain()) {
                x509Data.addCertificate(cert);
            }
            if (credential.getCRLs() != null) {
                for (X509CRL crl : credential.getCRLs()) {
                    x509Data.addCRL(crl.getEncoded());
                }
            }
        }
        catch (XMLSecurityException e) {
            log.error("Unable to constructor signature KeyInfo", (Throwable)e);
            System.exit(-1);
        }
        catch (CRLException e) {
            log.error("Unknown CRL exception", (Throwable)e);
            System.exit(-1);
        }
    }

    protected static String getSignatureReferenceUri(XmlSecToolCommandLineArguments cli, Element rootElement) {
        Attr referenceAttribute;
        String reference = "";
        if (cli.getReferenceIdAttributeName() != null && (referenceAttribute = (Attr)rootElement.getAttributes().getNamedItem(cli.getReferenceIdAttributeName())) != null && (reference = DatatypeHelper.safeTrim((String)referenceAttribute.getValue())).length() > 0) {
            reference = "#" + reference;
        }
        return reference;
    }

    protected static void addSignatureELement(XmlSecToolCommandLineArguments cli, Element root, Element signature) {
        if ("FIRST".equalsIgnoreCase(cli.getSignaturePosition()) || cli.getSignaturePosition() == null) {
            root.insertBefore(signature, root.getFirstChild());
            return;
        }
        if ("LAST".equalsIgnoreCase(cli.getSignaturePosition())) {
            root.appendChild(signature);
            return;
        }
        try {
            NodeList children = root.getChildNodes();
            int position = Integer.parseInt(cli.getSignaturePosition());
            boolean signatureInserted = false;
            if (children.getLength() > position) {
                int elementCount = 0;
                int i = 0;
                while (i < children.getLength()) {
                    if (children.item(i).getNodeType() == 1 && ++elementCount == position) {
                        root.insertBefore(signature, children.item(i));
                        signatureInserted = true;
                    }
                    ++i;
                }
            }
            if (!signatureInserted) {
                root.appendChild(signature);
            }
        }
        catch (NumberFormatException e) {
            log.error("Invalid signature position: " + cli.getSignaturePosition());
            System.exit(7);
        }
    }

    protected static void verifySignature(XmlSecToolCommandLineArguments cli, Document xmlDocument) {
        Element signatureElement = XmlSecTool.getSignatureElement(xmlDocument);
        if (signatureElement == null) {
            if (cli.isSignatureRequired()) {
                log.error("Signature required but XML document is not signed");
                System.exit(7);
            } else {
                log.info("XML document is not signed, no verification performed");
                return;
            }
        }
        log.debug("XML document cotnained Signature element\n{}", (Object)XMLHelper.prettyPrintXML((Node)signatureElement));
        log.debug("Creating XML security library XMLSignature object");
        XMLSignature signature = null;
        try {
            signature = new XMLSignature(signatureElement, "");
        }
        catch (XMLSecurityException e) {
            log.error("Unable to read XML signature", (Throwable)e);
            System.exit(7);
        }
        Key verificationKey = SecurityHelper.extractVerificationKey((Credential)XmlSecTool.getCredential(cli));
        log.debug("Verifying XML signature with key\n{}", (Object)Base64.encodeBytes((byte[])verificationKey.getEncoded()));
        try {
            if (signature.checkSignatureValue(verificationKey)) {
                log.info("XML document signature verified.");
            }
        }
        catch (XMLSignatureException e) {
            log.error("XML document signature verification failed", (Throwable)e);
            System.exit(7);
        }
    }

    protected static Element getSignatureElement(Document xmlDoc) {
        List sigElements = XMLHelper.getChildElementsByTagNameNS((Element)xmlDoc.getDocumentElement(), (String)Signature.DEFAULT_ELEMENT_NAME.getNamespaceURI(), (String)Signature.DEFAULT_ELEMENT_NAME.getLocalPart());
        if (sigElements.isEmpty()) {
            return null;
        }
        if (sigElements.size() > 1) {
            log.error("XML document contained more than on signature, unable to process");
            System.exit(7);
        }
        return (Element)sigElements.get(0);
    }

    protected static BasicX509Credential getCredential(XmlSecToolCommandLineArguments cli) {
        BasicX509Credential credential = null;
        if (cli.getCertificate() != null) {
            try {
                credential = CredentialHelper.getFileBasedCredentials(cli.getKey(), cli.getKeyPassword(), cli.getCertificate());
            }
            catch (KeyException e) {
                log.error("Unable to read key file " + cli.getKey(), (Throwable)e);
                System.exit(2);
            }
            catch (CertificateException e) {
                log.error("Unable to read certificate file " + cli.getKey(), (Throwable)e);
                System.exit(2);
            }
        } else if (cli.getPkcs11Config() != null) {
            try {
                credential = CredentialHelper.getPKCS11Credential(cli.getKeystore(), cli.getPkcs11Config(), cli.getKey(), cli.getKeyPassword());
            }
            catch (IOException e) {
                log.error("Error accessing PKCS11 store", (Throwable)e);
                System.exit(2);
            }
            catch (GeneralSecurityException e) {
                log.error("Unable to recover key entry from PKCS11 store", (Throwable)e);
                System.exit(2);
            }
        } else {
            try {
                credential = CredentialHelper.getKeystoreCredential(cli.getKeystore(), cli.getKeystorePassword(), cli.getKeystoreProvider(), cli.getKeystoreType(), cli.getKey(), cli.getKeyPassword());
            }
            catch (IOException e) {
                log.error("Unable to read keystore " + cli.getKeystore(), (Throwable)e);
                System.exit(2);
            }
            catch (GeneralSecurityException e) {
                log.error("Unable to recover key entry from keystore", (Throwable)e);
                System.exit(2);
            }
        }
        if (cli.getKeyInfoKeyNames() != null) {
            credential.getKeyNames().addAll(cli.getKeyInfoKeyNames());
        }
        credential.setCRLs(XmlSecTool.getCRLs(cli));
        return credential;
    }

    protected static Collection<X509CRL> getCRLs(XmlSecToolCommandLineArguments cli) {
        List<String> keyInfoCrls = cli.getKeyInfoCrls();
        if (keyInfoCrls == null || keyInfoCrls.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<X509CRL> crls = new ArrayList<X509CRL>();
        File crlFile = null;
        try {
            for (String crlFilePath : keyInfoCrls) {
                crlFile = new File(crlFilePath);
                if (!crlFile.exists() || !crlFile.canRead()) {
                    log.error("Unable to read CRL file " + crlFilePath);
                    System.exit(6);
                }
                crls.addAll(X509Util.decodeCRLs((File)crlFile));
            }
        }
        catch (CRLException e) {
            log.error("Unable to parse CRL file " + crlFile.getAbsolutePath(), (Throwable)e);
            System.exit(6);
        }
        return crls;
    }

    protected static void writeDocument(XmlSecToolCommandLineArguments cli, Node xml) {
        try {
            FileOutputStream output;
            log.debug("Attempting to write output to file {}", (Object)cli.getOutputFile());
            File file = new File(cli.getOutputFile());
            if (file.exists() && file.isDirectory()) {
                log.error(MessageFormatter.format((String)"Output file {} is a directory", (Object)cli.getOutputFile()));
                System.exit(2);
            }
            file.createNewFile();
            if (!file.canWrite()) {
                log.error(MessageFormatter.format((String)"Unable to write to output file {}", (Object)cli.getOutputFile()));
                System.exit(2);
            }
            if (cli.isBase64EncodedOutput()) {
                log.debug("Base64 encoding output to file");
                output = new Base64.OutputStream((OutputStream)new FileOutputStream(cli.getOutputFile()));
            } else {
                output = new FileOutputStream(cli.getOutputFile());
            }
            log.debug("Writting XML document to output file {}", (Object)cli.getOutputFile());
            XMLHelper.writeNode((Node)xml, (OutputStream)output);
            output.flush();
            ((OutputStream)output).close();
            log.info("XML document written to file {}", (Object)file.getAbsolutePath());
        }
        catch (IOException e) {
            log.error(MessageFormatter.format((String)"Unable to write document to file {}", (Object)cli.getOutputFile()), (Throwable)e);
            System.exit(2);
        }
    }

    protected static void initLogging(XmlSecToolCommandLineArguments cli) {
        if (cli.getLoggingConfiguration() != null) {
            System.setProperty("logback.configurationFile", cli.getLoggingConfiguration());
        } else if (cli.doVerboseOutput()) {
            System.setProperty("logback.configurationFile", "logger-verbose.xml");
        } else if (cli.doQuietOutput()) {
            System.setProperty("logback.configurationFile", "logger-quiet.xml");
        } else {
            System.setProperty("logback.configurationFile", "logger-normal.xml");
        }
        log = LoggerFactory.getLogger(XmlSecTool.class);
    }
}

