/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.security;

import jargs.gnu.CmdLineParser;
import java.io.PrintStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlSecToolCommandLineArguments {
    private boolean sign;
    private CmdLineParser.Option SIGN_ARG;
    private boolean schemaValidate;
    private CmdLineParser.Option V_SCHEMA_ARG;
    private boolean signatureVerify;
    private CmdLineParser.Option V_SIG_ARG;
    private String inFile;
    private CmdLineParser.Option IN_FILE_ARG;
    private String inUrl;
    private CmdLineParser.Option IN_URL_ARG;
    private String httpProxy;
    private CmdLineParser.Option HTTP_PROXY_ARG;
    private int httpProxyPort;
    private CmdLineParser.Option HTTP_PROXY_PORT_ARG;
    private String httpProxyUsername;
    private CmdLineParser.Option HTTP_PROXY_USERNAME_ARG;
    private String httpProxyPassword;
    private CmdLineParser.Option HTTP_PROXY_PASSWORD_ARG;
    private String schemaDirectory;
    private CmdLineParser.Option SCHEMA_DIR_ARG;
    private boolean xsdSchema;
    private CmdLineParser.Option SCHEMA_XSD_LANG_ARG;
    private boolean rngSchema;
    private CmdLineParser.Option SCHEMA_RNG_LANG_ARG;
    private boolean signatureRequired;
    private CmdLineParser.Option SIG_REQUIRED_ARG;
    private String refIdAttributeName;
    private CmdLineParser.Option SIG_REF_ID_ATT_ARG;
    private String signaturePosition;
    private CmdLineParser.Option SIG_POS_ARG;
    private List<String> inclusiveNamespacePrefixs;
    private CmdLineParser.Option SIG_INC_PREFIX_ARG;
    private List<String> kiKeyNames;
    private CmdLineParser.Option KI_KEY_NAME_ARG;
    private List<String> kiCrls;
    private CmdLineParser.Option KI_CRL_ARG;
    private String outFile;
    private CmdLineParser.Option OUT_FILE_ARG;
    private boolean base64EncodeOutput;
    private CmdLineParser.Option BASE64_OUT_ARG;
    private String cert;
    private CmdLineParser.Option CERT_ARG;
    private String key;
    private CmdLineParser.Option KEY_ARG;
    private String keyPassword;
    private CmdLineParser.Option KEY_PASSWORD_ARG;
    private String keystore;
    private CmdLineParser.Option KEYSTORE_ARG;
    private String keystorePassword;
    private CmdLineParser.Option KEYSTORE_PASSWORD_ARG;
    private String keystoreType;
    private CmdLineParser.Option KEYSTORE_TYPE_ARG;
    private String keystoreProvider;
    private CmdLineParser.Option KEYSTORE_PROVIDER_ARG;
    private String pkcs11Config;
    private CmdLineParser.Option PKCS11_CONFIG_ARG;
    private boolean verbose;
    private CmdLineParser.Option VERBOSE_ARG;
    private boolean quiet;
    private CmdLineParser.Option QUIET_ARG;
    private String logConfig;
    private CmdLineParser.Option LOG_CONFIG_ARG;
    private boolean help;
    private CmdLineParser.Option HELP_ARG;
    private CmdLineParser cliParser = new CmdLineParser();

    public XmlSecToolCommandLineArguments(String[] args) {
        this.SIGN_ARG = this.cliParser.addBooleanOption("sign");
        this.V_SCHEMA_ARG = this.cliParser.addBooleanOption("validateSchema");
        this.V_SIG_ARG = this.cliParser.addBooleanOption("verifySignature");
        this.IN_FILE_ARG = this.cliParser.addStringOption("inFile");
        this.IN_URL_ARG = this.cliParser.addStringOption("inUrl");
        this.HTTP_PROXY_ARG = this.cliParser.addStringOption("httpProxy");
        this.HTTP_PROXY_PORT_ARG = this.cliParser.addIntegerOption("httpProxyPort");
        this.HTTP_PROXY_USERNAME_ARG = this.cliParser.addStringOption("httpProxyUsername");
        this.HTTP_PROXY_PASSWORD_ARG = this.cliParser.addStringOption("httpProxyPassword");
        this.SCHEMA_DIR_ARG = this.cliParser.addStringOption("schemaDirectory");
        this.SCHEMA_XSD_LANG_ARG = this.cliParser.addBooleanOption("xsd");
        this.SCHEMA_RNG_LANG_ARG = this.cliParser.addBooleanOption("relaxng");
        this.SIG_REQUIRED_ARG = this.cliParser.addBooleanOption("signatureRequired");
        this.SIG_REF_ID_ATT_ARG = this.cliParser.addStringOption("referenceIdAttributeName");
        this.SIG_POS_ARG = this.cliParser.addStringOption("signaturePosition");
        this.SIG_INC_PREFIX_ARG = this.cliParser.addStringOption("inclusiveNamespacePrefix");
        this.KI_KEY_NAME_ARG = this.cliParser.addStringOption("keyInfoKeyName");
        this.KI_CRL_ARG = this.cliParser.addStringOption("keyInfoCRL");
        this.OUT_FILE_ARG = this.cliParser.addStringOption("outFile");
        this.BASE64_OUT_ARG = this.cliParser.addBooleanOption("base64EncodeOutput");
        this.CERT_ARG = this.cliParser.addStringOption("certificate");
        this.KEY_ARG = this.cliParser.addStringOption("key");
        this.KEY_PASSWORD_ARG = this.cliParser.addStringOption("keyPassword");
        this.KEYSTORE_ARG = this.cliParser.addStringOption("keystore");
        this.KEYSTORE_PASSWORD_ARG = this.cliParser.addStringOption("keystorePassword");
        this.KEYSTORE_TYPE_ARG = this.cliParser.addStringOption("keystoreType");
        this.KEYSTORE_PROVIDER_ARG = this.cliParser.addStringOption("keystoreProvider");
        this.PKCS11_CONFIG_ARG = this.cliParser.addStringOption("pkcs11Config");
        this.VERBOSE_ARG = this.cliParser.addBooleanOption("verbose");
        this.QUIET_ARG = this.cliParser.addBooleanOption("quiet");
        this.LOG_CONFIG_ARG = this.cliParser.addStringOption("logConfig");
        this.HELP_ARG = this.cliParser.addBooleanOption("help");
    }

    public void parseCommandLineArguments(String[] args) {
        try {
            this.cliParser.parse(args);
            this.sign = (Boolean)this.cliParser.getOptionValue(this.SIGN_ARG, (Object)Boolean.FALSE);
            this.schemaValidate = (Boolean)this.cliParser.getOptionValue(this.V_SCHEMA_ARG, (Object)Boolean.FALSE);
            this.signatureVerify = (Boolean)this.cliParser.getOptionValue(this.V_SIG_ARG, (Object)Boolean.FALSE);
            this.inFile = (String)this.cliParser.getOptionValue(this.IN_FILE_ARG);
            this.inUrl = (String)this.cliParser.getOptionValue(this.IN_URL_ARG);
            this.schemaDirectory = (String)this.cliParser.getOptionValue(this.SCHEMA_DIR_ARG);
            this.xsdSchema = (Boolean)this.cliParser.getOptionValue(this.SCHEMA_XSD_LANG_ARG, (Object)Boolean.FALSE);
            this.rngSchema = (Boolean)this.cliParser.getOptionValue(this.SCHEMA_RNG_LANG_ARG, (Object)Boolean.FALSE);
            if (!this.xsdSchema && !this.rngSchema) {
                this.xsdSchema = true;
            }
            this.signatureRequired = (Boolean)this.cliParser.getOptionValue(this.SIG_REQUIRED_ARG, (Object)Boolean.TRUE);
            this.refIdAttributeName = (String)this.cliParser.getOptionValue(this.SIG_REF_ID_ATT_ARG);
            this.signaturePosition = (String)this.cliParser.getOptionValue(this.SIG_POS_ARG);
            this.inclusiveNamespacePrefixs = this.cliParser.getOptionValues(this.SIG_INC_PREFIX_ARG);
            this.kiKeyNames = this.cliParser.getOptionValues(this.KI_KEY_NAME_ARG);
            this.kiCrls = this.cliParser.getOptionValues(this.KI_CRL_ARG);
            this.outFile = (String)this.cliParser.getOptionValue(this.OUT_FILE_ARG);
            this.base64EncodeOutput = (Boolean)this.cliParser.getOptionValue(this.BASE64_OUT_ARG, (Object)Boolean.FALSE);
            this.httpProxy = (String)this.cliParser.getOptionValue(this.HTTP_PROXY_ARG);
            this.httpProxyPort = (Integer)this.cliParser.getOptionValue(this.HTTP_PROXY_PORT_ARG, (Object)80);
            this.httpProxyUsername = (String)this.cliParser.getOptionValue(this.HTTP_PROXY_USERNAME_ARG);
            this.httpProxyPassword = (String)this.cliParser.getOptionValue(this.HTTP_PROXY_PASSWORD_ARG);
            this.cert = (String)this.cliParser.getOptionValue(this.CERT_ARG);
            this.key = (String)this.cliParser.getOptionValue(this.KEY_ARG);
            this.keyPassword = (String)this.cliParser.getOptionValue(this.KEY_PASSWORD_ARG);
            this.keystore = (String)this.cliParser.getOptionValue(this.KEYSTORE_ARG);
            this.keystorePassword = (String)this.cliParser.getOptionValue(this.KEYSTORE_PASSWORD_ARG);
            this.keystoreType = (String)this.cliParser.getOptionValue(this.KEYSTORE_TYPE_ARG);
            this.keystoreProvider = (String)this.cliParser.getOptionValue(this.KEYSTORE_PROVIDER_ARG);
            this.pkcs11Config = (String)this.cliParser.getOptionValue(this.PKCS11_CONFIG_ARG);
            this.verbose = (Boolean)this.cliParser.getOptionValue(this.VERBOSE_ARG, (Object)Boolean.FALSE);
            this.quiet = (Boolean)this.cliParser.getOptionValue(this.QUIET_ARG, (Object)Boolean.FALSE);
            this.logConfig = (String)this.cliParser.getOptionValue(this.LOG_CONFIG_ARG);
            this.help = (Boolean)this.cliParser.getOptionValue(this.HELP_ARG, (Object)false);
            this.validateCommandLineArguments();
        }
        catch (CmdLineParser.OptionException e) {
            this.errorAndExit(e.getMessage());
        }
    }

    public String getHttpProxy() {
        return this.httpProxy;
    }

    public int getHttpProxyPort() {
        return this.httpProxyPort;
    }

    public String getHttpProxyUsername() {
        return this.httpProxyUsername;
    }

    public String getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    public boolean doSign() {
        return this.sign;
    }

    public boolean doSchemaValidation() {
        return this.schemaValidate;
    }

    public boolean doSignatureVerify() {
        return this.signatureVerify;
    }

    public boolean isSignatureRequired() {
        return this.signatureRequired;
    }

    public String getReferenceIdAttributeName() {
        return this.refIdAttributeName;
    }

    public String getSignaturePosition() {
        return this.signaturePosition;
    }

    public List<String> getInclusiveNamespacePrefixs() {
        return this.inclusiveNamespacePrefixs;
    }

    public List<String> getKeyInfoKeyNames() {
        return this.kiKeyNames;
    }

    public List<String> getKeyInfoCrls() {
        return this.kiCrls;
    }

    public String getInputFile() {
        return this.inFile;
    }

    public String getInputUrl() {
        return this.inUrl;
    }

    public String getSchemaDirectory() {
        return this.schemaDirectory;
    }

    public boolean isXsdSchema() {
        return this.xsdSchema;
    }

    public boolean isRngSchema() {
        return this.rngSchema;
    }

    public String getOutputFile() {
        return this.outFile;
    }

    public boolean isBase64EncodedOutput() {
        return this.base64EncodeOutput;
    }

    public String getCertificate() {
        return this.cert;
    }

    public String getKey() {
        return this.key;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public String getKeystore() {
        return this.keystore;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public String getKeystoreProvider() {
        return this.keystoreProvider;
    }

    public String getPkcs11Config() {
        return this.pkcs11Config;
    }

    public boolean doVerboseOutput() {
        return this.verbose;
    }

    public boolean doQuietOutput() {
        return this.quiet;
    }

    public String getLoggingConfiguration() {
        return this.logConfig;
    }

    public boolean doHelp() {
        return this.help;
    }

    private void validateCommandLineArguments() {
        if (this.doHelp()) {
            return;
        }
        if (!(this.doSchemaValidation() || this.doSignatureVerify() || this.doSign())) {
            this.errorAndExit("No action was specified");
        }
        if (this.getInputFile() == null && this.getInputUrl() == null || this.getInputFile() != null && this.getInputUrl() != null) {
            this.errorAndExit("One, and only one, document input method must be specified");
        }
        if (this.doSchemaValidation()) {
            if (this.getSchemaDirectory() == null) {
                this.errorAndExit(this.SCHEMA_DIR_ARG.longForm() + " option is required");
            }
            if (this.isXsdSchema() && this.isRngSchema()) {
                this.errorAndExit("XML Schema and RelaxNG languages may not be used simultaneously");
            }
        }
        if (this.doSign() && this.doSignatureVerify()) {
            this.errorAndExit("The signing and signature verification actions are mutually exclusive");
        }
        if ((this.doSign() || this.doSignatureVerify()) && this.getCertificate() == null && this.getPkcs11Config() == null && this.getKeystore() == null) {
            this.errorAndExit("No credential source was given, unable to perform signature operation");
        }
        if (this.doSign()) {
            if (this.getKey() == null) {
                this.errorAndExit(this.KEY_ARG.longForm() + " option is required");
            }
            if ((this.getKeystore() != null || this.getPkcs11Config() != null) && this.getKeyPassword() == null) {
                this.errorAndExit(this.KEY_PASSWORD_ARG.longForm() + " option is required");
            }
            if (this.getOutputFile() == null) {
                this.errorAndExit("No output location specified");
            }
        }
        if (this.doVerboseOutput() && this.doQuietOutput()) {
            this.errorAndExit("Verbos and quiet output are mutually exclusive");
        }
    }

    public void printHelp(PrintStream out) {
        out.println("XML Tool");
        out.println("Provides a command line interface for schema validating, signing, and signature validating an XML file.");
        out.println();
        out.println("==== Command Line Options ====");
        out.println();
        out.println(String.format("  --%-20s %s", this.HELP_ARG.longForm(), "Prints this help information"));
        out.println();
        out.println("Action Options - '" + this.SIGN_ARG.longForm() + "' and '" + this.V_SIG_ARG.longForm() + "' are mutually exclusive.  At least one option is required.");
        out.println(String.format("  --%-20s %s", this.V_SCHEMA_ARG.longForm(), "Schema validate the document."));
        out.println(String.format("  --%-20s %s", this.SIGN_ARG.longForm(), "Sign the SAML document."));
        out.println(String.format("  --%-20s %s", this.V_SIG_ARG.longForm(), "Check the signature on a signed document."));
        out.println();
        out.println("Data Input Options - '" + this.IN_FILE_ARG.longForm() + "' and '" + this.IN_URL_ARG.longForm() + "' are mutually exclusive, one is required.");
        out.println(String.format("  --%-20s %s", this.IN_FILE_ARG.longForm(), "Specifies the file from which the SAML document will be read."));
        out.println(String.format("  --%-20s %s", this.IN_URL_ARG.longForm(), "Specifies the URL from which the SAML document will be read. HTTPS certificates are not validated."));
        out.println(String.format("  --%-20s %s", this.HTTP_PROXY_ARG.longForm(), "HTTP proxy address used when fetching URL-based input files."));
        out.println(String.format("  --%-20s %s", this.HTTP_PROXY_PORT_ARG.longForm(), "HTTP proxy port. (default: 80)"));
        out.println(String.format("  --%-20s %s", this.HTTP_PROXY_USERNAME_ARG.longForm(), "Username used to authenticate to the HTTP proxy."));
        out.println(String.format("  --%-20s %s", this.HTTP_PROXY_PASSWORD_ARG.longForm(), "Password used to authenticated to the HTTP proxy."));
        out.println();
        out.println("Schema Validation Option - '" + this.SCHEMA_XSD_LANG_ARG.longForm() + "' (default) and '" + this.SCHEMA_RNG_LANG_ARG.longForm() + "' are mutually exclusive option.");
        out.println(String.format("  --%-20s %s", this.SCHEMA_DIR_ARG.longForm(), "Specifies a schema file or directory of schema files.  Subdirectories are also read."));
        out.println(String.format("  --%-20s %s", this.SCHEMA_XSD_LANG_ARG.longForm(), "Indicates schema files are W3 XML Schema 1.0 files (.xsd)."));
        out.println(String.format("  --%-20s %s", this.SCHEMA_RNG_LANG_ARG.longForm(), "Indicates schema files are OASIS RELAX NG files (.rng)."));
        out.println();
        out.println("Signature Creation Options");
        out.println(String.format("  --%-20s %s", this.SIG_REQUIRED_ARG.longForm(), "Specifies that the document being verified is required to contain a signature."));
        out.println(String.format("  --%-20s %s", this.SIG_REF_ID_ATT_ARG.longForm(), "Specifies that the name of the attribute, on the document element, whose value is used as the URI reference of the signature"));
        out.println(String.format("  --%-20s %s", this.SIG_POS_ARG.longForm(), "Specifies, by 1-based index, which element to place the signature BEFORE.  'FIRST' may be used to indicate that the signature goes BEFORE the first element. 'LAST' may be used to indicate that the signature goes AFTER the last element. (default value: FIRST)"));
        out.println(String.format("  --%-20s %s", this.KI_KEY_NAME_ARG.longForm(), "Specifies a key name to be included in the key info.  Option may be used more than once."));
        out.println(String.format("  --%-20s %s", this.KI_CRL_ARG.longForm(), "Specifies a file path for a CRL to be included in the key info.  Option may be used more than once."));
        out.println();
        out.println("Signature Verification Options");
        out.println(String.format("  --%-20s %s", this.SIG_REQUIRED_ARG.longForm(), "Treat unsigned documents as an error.  (default: true)"));
        out.println();
        out.println("PEM/DER Encoded Certificate/Key Options - these options are mutually exclusive with the Keystore and PKCS11 options. Options '" + this.CERT_ARG.longForm() + "' and '" + this.KEY_ARG.longForm() + "' are required.");
        out.println(String.format("  --%-20s %s", this.CERT_ARG.longForm(), "Specifies the file from which the signing, or validation, certificate is read."));
        out.println(String.format("  --%-20s %s", this.KEY_ARG.longForm(), "Specifies the file from which the signing key is read."));
        out.println(String.format("  --%-20s %s", this.KEY_PASSWORD_ARG.longForm(), "Specifies the password for the signing key."));
        out.println();
        out.println("Keystore Certificate/Key Options - these options are mutually exclusive with the PEM/DER and PKCS11 options. Options '" + this.KEYSTORE_ARG.longForm() + "', '" + this.KEY_ARG.longForm() + "', and '" + this.KEY_PASSWORD_ARG.longForm() + "' are required.");
        out.println(String.format("  --%-20s %s", this.KEYSTORE_ARG.longForm(), "Specifies the keystore file."));
        out.println(String.format("  --%-20s %s", this.KEYSTORE_PASSWORD_ARG.longForm(), "Specifies the password for the keystore. If not provided then the key password is used."));
        out.println(String.format("  --%-20s %s", this.KEYSTORE_TYPE_ARG.longForm(), "Specifies the type of the keystore."));
        out.println(String.format("  --%-20s %s", this.KEYSTORE_PROVIDER_ARG.longForm(), "Specifies the keystore provider class to use instead of the default one for the JVM."));
        out.println(String.format("  --%-20s %s", this.KEY_ARG.longForm(), "Specifies the key alias for the signing key is read."));
        out.println(String.format("  --%-20s %s", this.KEY_PASSWORD_ARG.longForm(), "Specifies the password for the signing key. Keystore password used if none is given."));
        out.println();
        out.println("PKCS11 Device Certificate/Key Options - these options are mutually exclusive with the PEM/DER and Keystore options. Options '" + this.PKCS11_CONFIG_ARG.longForm() + "' and '" + this.KEY_ARG.longForm() + "' are required. Option '" + this.KEY_PASSWORD_ARG.longForm() + "' required when signing and, with some PKCS11 devices, during signature verification.");
        out.println(String.format("  --%-20s %s", this.PKCS11_CONFIG_ARG.longForm(), "The PKCS11 token configuration file."));
        out.println(String.format("  --%-20s %s", this.KEY_ARG.longForm(), "Specifies the key alias for the signing key is read."));
        out.println(String.format("  --%-20s %s", this.KEY_PASSWORD_ARG.longForm(), "Specifies the pin for the signing key."));
        out.println(String.format("  --%-20s %s", this.KEYSTORE_PROVIDER_ARG.longForm(), "The fully qualified class name of the PKCS11 keystore provider implementation. (default: sun.security.pkcs11.SunPKCS11)"));
        out.println();
        out.println("Data Output Options - Option '" + this.OUT_FILE_ARG.longForm() + "' is required.");
        out.println(String.format("  --%-20s %s", this.OUT_FILE_ARG.longForm(), "Specifies the file to which the signed SAML document will be written."));
        out.println(String.format("  --%-20s %s", this.BASE64_OUT_ARG.longForm(), "Base64 encode the output. Ensures signed content isn't corrupted."));
        out.println();
        out.println("Logging Options - these options are mutually exclusive");
        out.println(String.format("  --%-20s %s", this.VERBOSE_ARG.longForm(), "Turn on verbose messages."));
        out.println(String.format("  --%-20s %s", this.QUIET_ARG.longForm(), "Do not write any messages to STDERR or STDOUT."));
        out.println(String.format("  --%-20s %s", this.LOG_CONFIG_ARG.longForm(), "Specifies a logback configuration file to use to configure logging."));
        out.println();
    }

    private void errorAndExit(String error) {
        System.err.println(error);
        System.err.flush();
        System.out.println();
        this.printHelp(System.out);
        System.out.flush();
        System.exit(1);
    }
}

