/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi;

import java.util.ArrayList;
import org.owasp.esapi.codecs.Codec;

public class PreparedString {
    char parameterCharacter = (char)63;
    Codec codec = null;
    String[] parameters = null;
    ArrayList parts = new ArrayList();
    private static final char[] IMMUNE = new char[0];

    public PreparedString(String template, Codec codec) {
        this.codec = codec;
        this.split(template, this.parameterCharacter);
    }

    public PreparedString(String template, char parameterCharacter, Codec codec) {
        this.codec = codec;
        this.parameterCharacter = parameterCharacter;
        this.split(template, parameterCharacter);
    }

    private void split(String str, char c) {
        int index = 0;
        int pcount = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != c) continue;
            ++pcount;
            this.parts.add(str.substring(index, i));
            index = i + 1;
        }
        this.parts.add(str.substring(index));
        this.parameters = new String[pcount];
    }

    public void set(int index, String value) {
        String encoded;
        if (index < 1 || index > this.parameters.length) {
            throw new IllegalArgumentException("Attempt to set parameter " + index + " on a PreparedString with only " + this.parameters.length + " placeholders");
        }
        this.parameters[index - 1] = encoded = this.codec.encode(IMMUNE, value);
    }

    public void set(int index, String value, Codec codec) {
        String encoded;
        if (index < 1 || index > this.parameters.length) {
            throw new IllegalArgumentException("Attempt to set parameter " + index + " on a PreparedString with only " + this.parameters.length + " placeholders");
        }
        this.parameters[index - 1] = encoded = codec.encode(IMMUNE, value);
    }

    public String toString() {
        for (int ix = 0; ix < this.parameters.length; ++ix) {
            if (this.parameters[ix] != null) continue;
            throw new RuntimeException("Attempt to render PreparedString without setting parameter " + (ix + 1));
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (int p = 0; p < this.parts.size(); ++p) {
            sb.append(this.parts.get(p));
            if (i >= this.parameters.length) continue;
            sb.append(this.parameters[i++]);
        }
        return sb.toString();
    }
}

