/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.wayf;

import edu.internet2.middleware.shibboleth.common.ShibbolethConfigurationException;
import edu.internet2.middleware.shibboleth.wayf.HandlerConfig;
import edu.internet2.middleware.shibboleth.wayf.IdPSite;
import edu.internet2.middleware.shibboleth.wayf.WayfException;
import edu.internet2.middleware.shibboleth.wayf.plugins.Plugin;
import edu.internet2.middleware.shibboleth.wayf.plugins.PluginMetadataParameter;
import edu.internet2.middleware.shibboleth.wayf.plugins.provider.BindingFilter;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TreeMap;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.opensaml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.Organization;
import org.opensaml.saml2.metadata.OrganizationDisplayName;
import org.opensaml.saml2.metadata.OrganizationName;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.provider.AbstractReloadingMetadataProvider;
import org.opensaml.saml2.metadata.provider.FileBackedHTTPMetadataProvider;
import org.opensaml.saml2.metadata.provider.FilesystemMetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataFilter;
import org.opensaml.saml2.metadata.provider.MetadataFilterChain;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.saml2.metadata.provider.ObservableMetadataProvider;
import org.opensaml.saml2.metadata.provider.RequiredValidUntilFilter;
import org.opensaml.saml2.metadata.provider.SignatureValidationFilter;
import org.opensaml.ws.soap.client.http.HttpClientBuilder;
import org.opensaml.ws.soap.client.http.TLSProtocolSocketFactory;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.CredentialResolver;
import org.opensaml.xml.security.credential.StaticCredentialResolver;
import org.opensaml.xml.security.keyinfo.BasicProviderKeyInfoCredentialResolver;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xml.security.keyinfo.provider.DSAKeyValueProvider;
import org.opensaml.xml.security.keyinfo.provider.InlineX509DataProvider;
import org.opensaml.xml.security.keyinfo.provider.RSAKeyValueProvider;
import org.opensaml.xml.security.x509.BasicX509Credential;
import org.opensaml.xml.security.x509.X509Util;
import org.opensaml.xml.signature.SignatureTrustEngine;
import org.opensaml.xml.signature.impl.ExplicitKeySignatureTrustEngine;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class IdPSiteSet
implements ObservableMetadataProvider.Observer {
    private static final Logger LOG = LoggerFactory.getLogger((String)IdPSiteSet.class.getName());
    private static Timer timer;
    private ObservableMetadataProvider metadata;
    private Set<String> spNames = new HashSet<String>(0);
    private Set<String> idpNames = new HashSet<String>(0);
    private final String identifier;
    private final String displayName;
    private String location;
    private final Map<Plugin, PluginMetadataParameter> plugins = new HashMap<Plugin, PluginMetadataParameter>();

    protected IdPSiteSet(Element element, ParserPool parserPool, boolean warnOnBadBinding) throws ShibbolethConfigurationException {
        Object provider;
        this.identifier = element.getAttribute("identifier");
        this.displayName = element.getAttribute("displayName");
        this.location = DatatypeHelper.safeTrimOrNullString((String)element.getAttribute("url"));
        if (null == this.location) {
            this.location = element.getAttribute("url");
        }
        MetadataFilterChain filterChain = this.buildFilterChain(element, warnOnBadBinding);
        LOG.info("Loading Metadata for " + this.displayName);
        try {
            URL url = new URL(this.location);
            provider = "file".equalsIgnoreCase(url.getProtocol()) ? new FilesystemMetadataProvider(new File(url.getFile())) : this.buildHTTPProvider(element, url);
        }
        catch (MetadataProviderException e) {
            throw new ShibbolethConfigurationException("Could not read " + this.location, e);
        }
        catch (MalformedURLException e) {
            throw new ShibbolethConfigurationException("Error configuring " + this.identifier + ": badly formed url ", e);
        }
        provider.setRefreshDelayFactor(this.getRefreshDelayFactor(element));
        provider.setMaxRefreshDelay(this.getMaxRefreshDelay(element));
        provider.setMinRefreshDelay(this.getMinRefreshDelay(element));
        provider.setParserPool(parserPool);
        try {
            provider.setMetadataFilter((MetadataFilter)filterChain);
            provider.initialize();
        }
        catch (MetadataProviderException e) {
            throw new ShibbolethConfigurationException("Error configuring " + this.identifier);
        }
        this.metadata = provider;
        this.metadata.getObservers().add(this);
        this.onEvent((MetadataProvider)this.metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timer getTimer() {
        if (null != timer) {
            return timer;
        }
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (null == timer) {
                timer = new Timer(true);
            }
            return timer;
        }
    }

    private float getRefreshDelayFactor(Element config) {
        float delayFactor = 0.75f;
        if (config.hasAttribute("refreshDelayFactor")) {
            String factorString = config.getAttribute("refreshDelayFactor");
            try {
                delayFactor = Float.parseFloat(factorString);
            }
            catch (NumberFormatException e) {
                LOG.error("Metadata provider '{}' had invalid refreshDelayFactor value '{}', using default value", (Object)this.identifier, (Object)factorString);
            }
        }
        if ((double)delayFactor <= 0.0 || (double)delayFactor >= 1.0) {
            LOG.error("Metadata provider '{}' had invalid refreshDelayFactor value '{}', using default value", (Object)this.identifier, (Object)Float.valueOf(delayFactor));
            delayFactor = 0.75f;
        }
        LOG.debug("Metadata provider '{}' refreshDelayFactor set to {}", (Object)this.identifier, (Object)Float.valueOf(delayFactor));
        return delayFactor;
    }

    private long getMaxRefreshDelay(Element config) {
        long maxRefreshDelay = 14400000L;
        String delayString = DatatypeHelper.safeTrimOrNullString((String)config.getAttribute("maxRefreshDelay"));
        if (null != delayString) {
            try {
                maxRefreshDelay = XMLHelper.durationToLong((String)delayString);
            }
            catch (IllegalArgumentException e) {
                LOG.error("Metadata provider '{}' had invalid maxRefreshDelay value '{}', using default value", (Object)this.identifier, (Object)delayString);
            }
        }
        if (maxRefreshDelay <= 0L) {
            LOG.error("Metadata provider '{}' had invalid maxRefreshDelay value '{}', using default value", (Object)this.identifier, (Object)maxRefreshDelay);
            maxRefreshDelay = 14400000L;
        }
        LOG.debug("Metadata provider '{}' maxRefreshDelay set to {}", (Object)this.identifier, (Object)maxRefreshDelay);
        return maxRefreshDelay;
    }

    private int getMinRefreshDelay(Element config) {
        int minRefreshDelay = 300000;
        String delayString = DatatypeHelper.safeTrimOrNullString((String)config.getAttribute("minRefreshDelay"));
        if (null != delayString) {
            try {
                long delay = XMLHelper.durationToLong((String)delayString);
                if (delay > Integer.MAX_VALUE) {
                    throw new IllegalArgumentException("Integer overflow");
                }
                minRefreshDelay = (int)delay;
            }
            catch (IllegalArgumentException e) {
                LOG.error("Metadata provider '{}' had invalid minRefreshDelay value '{}', using default value", (Object)this.identifier, (Object)delayString);
            }
        }
        if (minRefreshDelay <= 0) {
            LOG.error("Metadata provider '{}' had invalid minRefreshDelay value '{}', using default value", (Object)this.identifier, (Object)minRefreshDelay);
            minRefreshDelay = 300000;
        }
        LOG.debug("Metadata provider '{}' minRefreshDelay set to {}", (Object)this.identifier, (Object)minRefreshDelay);
        return minRefreshDelay;
    }

    private HttpClient buildHttpClient(Element config, URL metadataURL) {
        int requestTimeout;
        HttpClientBuilder builder;
        block12: {
            builder = new HttpClientBuilder();
            requestTimeout = 5000;
            String timeoutString = DatatypeHelper.safeTrimOrNullString((String)config.getAttribute("requestTimeout"));
            String delayString = DatatypeHelper.safeTrimOrNullString((String)config.getAttribute("timeout"));
            if (null != delayString) {
                LOG.warn("timeout qualifier is deprecated, please use requestTimeout");
            }
            if (null != timeoutString) {
                try {
                    long time = XMLHelper.durationToLong((String)timeoutString);
                    if (time > Integer.MAX_VALUE) {
                        LOG.error("Metadata provider '{}' had invalid requestTimeout value '{}', using default value", (Object)this.identifier, (Object)timeoutString);
                        break block12;
                    }
                    requestTimeout = (int)time;
                }
                catch (IllegalArgumentException e) {
                    LOG.error("Metadata provider '{}' had invalid requestTimeout value '{}', using default value", (Object)this.identifier, (Object)timeoutString);
                }
            } else if (null != delayString) {
                try {
                    requestTimeout = Integer.parseInt(delayString);
                }
                catch (NumberFormatException e) {
                    LOG.error("Metadata provider '{}' had invalid timeout value '{}', using default value", (Object)this.identifier, (Object)timeoutString);
                }
            }
        }
        LOG.debug("Metadata provider '{}' HTTP request timeout: {}ms", (Object)this.identifier, (Object)requestTimeout);
        builder.setConnectionTimeout(requestTimeout);
        if ("https".equalsIgnoreCase(metadataURL.getProtocol())) {
            boolean disregardSslCertificate = false;
            String disregard = DatatypeHelper.safeTrimOrNullString((String)config.getAttribute("disregardSslCertificate"));
            if (null != disregard) {
                disregardSslCertificate = Boolean.parseBoolean(disregard);
            }
            LOG.debug("Metadata provider '{}' disregards server SSL certificate: {}", (Object)this.identifier, (Object)disregardSslCertificate);
            if (disregardSslCertificate) {
                builder.setHttpsProtocolSocketFactory((SecureProtocolSocketFactory)new TLSProtocolSocketFactory(null, this.buildNoTrustTrustManager()));
            }
        }
        this.setHttpProxySettings(builder, config);
        HttpClient httpClient = builder.buildClient();
        this.setHttpBasicAuthSettings(httpClient, config, metadataURL);
        return httpClient;
    }

    private X509TrustManager buildNoTrustTrustManager() {
        X509TrustManager noTrustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String auth) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String auth) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
        return noTrustManager;
    }

    private void setHttpProxySettings(HttpClientBuilder builder, Element config) {
        String proxyUser;
        String proxyHost = DatatypeHelper.safeTrimOrNullString((String)config.getAttribute("proxyHost"));
        if (proxyHost == null) {
            return;
        }
        LOG.debug("Metadata provider '{}' HTTP proxy host: {}", (Object)this.identifier, (Object)proxyHost);
        builder.setProxyHost(proxyHost);
        String proxyPort = DatatypeHelper.safeTrimOrNullString((String)config.getAttribute("proxyPort"));
        if (null != proxyPort) {
            int port = Integer.parseInt(proxyPort);
            LOG.debug("Metadata provider '{}' HTTP proxy port: ", (Object)this.identifier, (Object)proxyPort);
            builder.setProxyPort(port);
        }
        if ((proxyUser = DatatypeHelper.safeTrimOrNullString((String)config.getAttribute("proxyUser"))) != null) {
            LOG.debug("Metadata provider '{}' HTTP proxy username: ", (Object)this.identifier, (Object)proxyUser);
            builder.setProxyUsername(proxyUser);
            LOG.debug("Metadata provider '{}' HTTP proxy password not shown", (Object)this.identifier);
            builder.setProxyPassword(DatatypeHelper.safeTrimOrNullString((String)config.getAttribute("proxyPassword")));
        }
    }

    private void setHttpBasicAuthSettings(HttpClient httpClient, Element config, URL metadataURL) {
        String authUser = DatatypeHelper.safeTrimOrNullString((String)config.getAttribute("basicAuthUser"));
        if (authUser == null) {
            return;
        }
        LOG.debug("Metadata provider '{}' HTTP Basic Auth username: {}", (Object)this.identifier, (Object)authUser);
        String authPassword = DatatypeHelper.safeTrimOrNullString((String)config.getAttribute("basicAuthPassword"));
        LOG.debug("Metadata provider '{}' HTTP Basic Auth password not show", (Object)this.identifier);
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(authUser, authPassword);
        AuthScope authScope = new AuthScope(metadataURL.getHost(), metadataURL.getPort());
        httpClient.getState().setCredentials(authScope, (Credentials)credentials);
    }

    private AbstractReloadingMetadataProvider buildHTTPProvider(Element element, URL metadataURL) throws ShibbolethConfigurationException {
        String spoolSpace = DatatypeHelper.safeTrimOrNullString((String)element.getAttribute("backingFile"));
        if (spoolSpace == null) {
            throw new ShibbolethConfigurationException("BackingFile must be specified for " + this.identifier);
        }
        try {
            return new FileBackedHTTPMetadataProvider(this.getTimer(), this.buildHttpClient(element, metadataURL), this.location, spoolSpace);
        }
        catch (MetadataProviderException e) {
            throw new ShibbolethConfigurationException("Error accessing metadataprovider from " + this.identifier + " at " + this.location);
        }
    }

    private MetadataFilterChain buildFilterChain(Element el, boolean warnOnBadBinding) throws ShibbolethConfigurationException {
        NodeList itemElements = el.getElementsByTagNameNS("urn:mace:shibboleth:wayf:config:1.0", "Filter");
        ArrayList<MetadataFilter> filters = new ArrayList<MetadataFilter>(3 + itemElements.getLength());
        MetadataFilterChain filterChain = null;
        filterChain = new MetadataFilterChain();
        String param = DatatypeHelper.safeTrimOrNullString((String)el.getAttribute("certicateFile"));
        if (null != param) {
            filters.add(this.buildCertificateFilter(param));
        }
        if (null != (param = DatatypeHelper.safeTrimOrNullString((String)el.getAttribute("maxValidityInterval")))) {
            filters.add(this.buildValidUntilFilter(param));
        }
        filters.add(new BindingFilter(warnOnBadBinding));
        for (int i = 0; i < itemElements.getLength(); ++i) {
            Element element = (Element)itemElements.item(i);
            if (null == element) continue;
            filters.add(this.createFilter(element));
        }
        filterChain.setFilters(filters);
        return filterChain;
    }

    private MetadataFilter createFilter(Element element) throws ShibbolethConfigurationException {
        String ident = "<not specified>";
        String className = "<not specified>";
        ident = DatatypeHelper.safeTrimOrNullString((String)element.getAttribute("identifier"));
        if (null == ident) {
            LOG.error("Could not load filter with no identifier");
            throw new ShibbolethConfigurationException("Could not load filter with no identifier");
        }
        className = DatatypeHelper.safeTrimOrNullString((String)element.getAttribute("type"));
        if (null == className) {
            LOG.error("Filter " + this.identifier + " did not have a valid class name");
            throw new ShibbolethConfigurationException("Filter " + this.identifier + " did not have a valid class name");
        }
        try {
            Class<?> filterClass = Class.forName(className);
            Class[] classParams = new Class[]{Element.class};
            Constructor<?> constructor = filterClass.getConstructor(classParams);
            Object[] constructorParams = new Object[]{element};
            return (MetadataFilter)constructor.newInstance(constructorParams);
        }
        catch (ClassNotFoundException e) {
            LOG.error("Could not load filter " + ident + "()" + className + ") for " + this.identifier, (Throwable)e);
            throw new ShibbolethConfigurationException("Could not load filter", e);
        }
        catch (SecurityException e) {
            LOG.error("Could not load filter " + ident + "()" + className + ") for " + this.identifier, (Throwable)e);
            throw new ShibbolethConfigurationException("Could not load filter", e);
        }
        catch (NoSuchMethodException e) {
            LOG.error("Could not load filter " + ident + "()" + className + ") for " + this.identifier, (Throwable)e);
            throw new ShibbolethConfigurationException("Could not load filter", e);
        }
        catch (IllegalArgumentException e) {
            LOG.error("Could not load filter " + ident + "()" + className + ") for " + this.identifier, (Throwable)e);
            throw new ShibbolethConfigurationException("Could not load filter", e);
        }
        catch (InstantiationException e) {
            LOG.error("Could not load filter " + ident + "()" + className + ") for " + this.identifier, (Throwable)e);
            throw new ShibbolethConfigurationException("Could not load filter", e);
        }
        catch (IllegalAccessException e) {
            LOG.error("Could not load filter " + ident + "()" + className + ") for " + this.identifier, (Throwable)e);
            throw new ShibbolethConfigurationException("Could not load filter", e);
        }
        catch (InvocationTargetException e) {
            LOG.error("Could not load filter " + ident + "()" + className + ") for " + this.identifier, (Throwable)e);
            throw new ShibbolethConfigurationException("Could not load filter", e);
        }
    }

    private MetadataFilter buildValidUntilFilter(String duration) throws ShibbolethConfigurationException {
        RequiredValidUntilFilter filter;
        try {
            filter = new RequiredValidUntilFilter(XMLHelper.durationToLong((String)duration) / 1000L);
        }
        catch (IllegalArgumentException e) {
            throw new ShibbolethConfigurationException("Could not convert duration to delay", e);
        }
        return filter;
    }

    private MetadataFilter buildCertificateFilter(String param) throws ShibbolethConfigurationException {
        Collection decodedCerts;
        try {
            decodedCerts = X509Util.decodeCertificate((File)new File(param));
        }
        catch (CertificateException e) {
            LOG.error("Could not load cerfificate for " + this.identifier, (Throwable)e);
            throw new ShibbolethConfigurationException("Could not load cerfificate for " + this.identifier, e);
        }
        Credential credential = this.credentialFor(new ArrayList<X509Certificate>(decodedCerts));
        SignatureTrustEngine engine = this.trustEngineFor(credential);
        SignatureValidationFilter filter = new SignatureValidationFilter(engine);
        filter.setRequireSignature(true);
        return filter;
    }

    private SignatureTrustEngine trustEngineFor(Credential credential) {
        StaticCredentialResolver credResolver = new StaticCredentialResolver(credential);
        ArrayList<Object> keyInfoProviders = new ArrayList<Object>();
        keyInfoProviders.add(new DSAKeyValueProvider());
        keyInfoProviders.add(new RSAKeyValueProvider());
        keyInfoProviders.add(new InlineX509DataProvider());
        BasicProviderKeyInfoCredentialResolver keyInfoCredResolver = new BasicProviderKeyInfoCredentialResolver(keyInfoProviders);
        return new ExplicitKeySignatureTrustEngine((CredentialResolver)credResolver, (KeyInfoCredentialResolver)keyInfoCredResolver);
    }

    private Credential credentialFor(List<X509Certificate> certificates) {
        BasicX509Credential credential = new BasicX509Credential();
        credential.setEntityCertificateChain(new ArrayList<X509Certificate>(certificates));
        credential.setEntityCertificate(certificates.get(0));
        credential.setPrivateKey(null);
        credential.setPublicKey(credential.getEntityCertificate().getPublicKey());
        return credential;
    }

    private static boolean isMatch(EntityDescriptor entity, String str, HandlerConfig config) {
        StringTokenizer input = new StringTokenizer(str);
        while (input.hasMoreElements()) {
            String currentToken = (String)input.nextElement();
            if (config.isIgnoredForMatch(currentToken)) continue;
            currentToken = currentToken.toLowerCase();
            if (entity.getEntityID().indexOf(currentToken) > -1) {
                return true;
            }
            Organization org = entity.getOrganization();
            if (org == null) continue;
            List orgNames = org.getOrganizationNames();
            for (OrganizationName name : orgNames) {
                if (name.getName().getLocalString().toLowerCase().indexOf(currentToken) <= -1) continue;
                return true;
            }
            List orgDisplayNames = org.getDisplayNames();
            for (OrganizationDisplayName name : orgDisplayNames) {
                if (name.getName().getLocalString().toLowerCase().indexOf(currentToken) <= -1) continue;
                return true;
            }
        }
        return false;
    }

    protected Map<String, IdPSite> getIdPSites(String searchString, boolean isWAYFprotocol, HandlerConfig config, Collection<IdPSite> searchMatches) {
        List<Object> entities;
        XMLObject object;
        try {
            object = this.metadata.getMetadata();
        }
        catch (MetadataProviderException e) {
            LOG.error("Metadata for " + this.location + "could not be read", (Throwable)e);
            return null;
        }
        if (object == null) {
            return null;
        }
        if (object instanceof EntityDescriptor) {
            entities = new ArrayList<EntityDescriptor>(1);
            entities.add((EntityDescriptor)object);
        } else if (object instanceof EntitiesDescriptor) {
            EntitiesDescriptor entitiesDescriptor = (EntitiesDescriptor)object;
            entities = this.getAllEntities(entitiesDescriptor);
        } else {
            return null;
        }
        TreeMap<String, IdPSite> result = new TreeMap<String, IdPSite>();
        for (EntityDescriptor entityDescriptor : entities) {
            if (!entityDescriptor.isValid() || !IdPSiteSet.hasIdPRole(entityDescriptor, isWAYFprotocol)) continue;
            IdPSite site = new IdPSite(entityDescriptor);
            result.put(site.getName(), site);
            if (searchMatches == null || !IdPSiteSet.isMatch(entityDescriptor, searchString, config)) continue;
            searchMatches.add(site);
        }
        return result;
    }

    protected String getIdentifier() {
        return this.identifier;
    }

    protected String getDisplayName() {
        return this.displayName;
    }

    protected boolean containsSP(String sPName) {
        XMLObject object;
        if (sPName == null || sPName.isEmpty()) {
            return true;
        }
        try {
            object = this.metadata.getMetadata();
        }
        catch (MetadataProviderException e) {
            return false;
        }
        if (object instanceof EntitiesDescriptor || object instanceof EntityDescriptor) {
            return this.spNames.contains(sPName);
        }
        return false;
    }

    protected boolean containsIdP(String idPName) {
        XMLObject object;
        if (idPName == null || idPName.length() == 0) {
            return true;
        }
        try {
            object = this.metadata.getMetadata();
        }
        catch (MetadataProviderException e) {
            return false;
        }
        if (object instanceof EntitiesDescriptor || object instanceof EntityDescriptor) {
            return this.idpNames.contains(idPName);
        }
        return false;
    }

    protected void addPlugin(Plugin plugin) {
        if (this.plugins.containsKey(plugin)) {
            return;
        }
        PluginMetadataParameter param = plugin.refreshMetadata((MetadataProvider)this.metadata);
        this.plugins.put(plugin, param);
    }

    protected PluginMetadataParameter paramFor(Plugin plugin) {
        return this.plugins.get(plugin);
    }

    private List<EntityDescriptor> getAllEntities(EntitiesDescriptor entitiesDescriptor) {
        ArrayList<EntityDescriptor> result = new ArrayList<EntityDescriptor>(entitiesDescriptor.getEntityDescriptors());
        for (EntitiesDescriptor entities : entitiesDescriptor.getEntitiesDescriptors()) {
            result.addAll(this.getAllEntities(entities));
        }
        return result;
    }

    public void onEvent(MetadataProvider provider) {
        XMLObject obj;
        HashSet<String> spNameSet = new HashSet<String>(0);
        HashSet<String> idpNameSet = new HashSet<String>(0);
        try {
            obj = provider.getMetadata();
        }
        catch (MetadataProviderException e) {
            LOG.error("Couldn't read metadata for " + this.location, (Throwable)e);
            return;
        }
        if (obj instanceof EntitiesDescriptor) {
            EntitiesDescriptor entitiesDescriptor = (EntitiesDescriptor)obj;
            for (EntityDescriptor entity : this.getAllEntities(entitiesDescriptor)) {
                if (IdPSiteSet.hasSPRole(entity)) {
                    spNameSet.add(entity.getEntityID());
                }
                if (!IdPSiteSet.hasIdPRole(entity, false)) continue;
                idpNameSet.add(entity.getEntityID());
            }
        } else if (obj instanceof EntityDescriptor) {
            EntityDescriptor entity = (EntityDescriptor)obj;
            if (IdPSiteSet.hasSPRole(entity)) {
                spNameSet.add(entity.getEntityID());
            }
            if (IdPSiteSet.hasIdPRole(entity, false)) {
                idpNameSet.add(entity.getEntityID());
            }
        } else {
            LOG.error("Metadata for " + this.location + " isn't <EntitiesDescriptor> or <EntityDescriptor>");
            return;
        }
        this.spNames = spNameSet;
        this.idpNames = idpNameSet;
        for (Plugin plugin : this.plugins.keySet()) {
            this.plugins.put(plugin, plugin.refreshMetadata(provider));
        }
    }

    private static boolean hasIdPRole(EntityDescriptor entity, boolean isWAYFprotocol) {
        if (isWAYFprotocol) {
            return null != IdPSite.getAddressForWAYF(entity);
        }
        List roles = entity.getRoleDescriptors();
        for (RoleDescriptor role : roles) {
            if (!(role instanceof IDPSSODescriptor)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasSPRole(EntityDescriptor entity) {
        List roles = entity.getRoleDescriptors();
        for (RoleDescriptor role : roles) {
            if (!(role instanceof SPSSODescriptor)) continue;
            return true;
        }
        return false;
    }

    protected IdPSite getSite(String idpName) throws WayfException {
        try {
            return new IdPSite(this.metadata.getEntityDescriptor(idpName));
        }
        catch (MetadataProviderException e) {
            String s = "Couldn't resolve " + idpName + " in " + this.getDisplayName();
            LOG.error(s, (Throwable)e);
            throw new WayfException(s, e);
        }
    }

    protected EntityDescriptor getEntity(String name) throws WayfException {
        try {
            return this.metadata.getEntityDescriptor(name);
        }
        catch (MetadataProviderException e) {
            String s = "Couldn't resolve " + name + " in " + this.getDisplayName();
            LOG.error(s, (Throwable)e);
            throw new WayfException(s, e);
        }
    }
}

